/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.yy.gslbsdk.util.LogTools;

public class DBInitMgr
extends SQLiteOpenHelper {
    public static final String TB_HOST = "gslb_host";
    public static final String TB_PROBE = "gslb_probe";
    public static final String TB_RESULT = "gslb_result";
    public static final String TB_RESULT_V6 = "gslb_result";
    public static final String TB_IDX_RESULT = "gslb_result_idx";
    public static final String TB_IDX_RESULT_V6 = "gslb_result_v6_idx";
    public static final String TB_SERVER = "gslb_server";
    public static final String TB_SERVER_V6 = "gslb_server_v6";
    public static final String TB_DELAY = "gslb_delay";
    public static final String TB_HIJACK = "gslb_hijack";

    public DBInitMgr(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public void onCreate(SQLiteDatabase db) {
        this.createTbHost(db);
        this.createTbResult(db);
        this.createTbResultV6(db);
        this.createTbServer(db);
        this.createTbServerV6(db);
        this.createTbHijack(db);
        LogTools.printInfo("create all table");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.dropTbHost(db);
        this.dropTbProbe(db);
        this.dropTbResult(db);
        this.dropTbResultV6(db);
        this.dropTbServer(db);
        this.dropTbServerV6(db);
        this.dropTbDelay(db);
        this.dropTbHijack(db);
        this.onCreate(db);
        LogTools.printInfo("upgrade all table");
    }

    private void createTbHost(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_host(_id INTEGER PRIMARY KEY AUTOINCREMENT,host TEXT,is_pre INTEGER,insert_time INTEGER)");
    }

    private void createTbProbe(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_probe(_id INTEGER PRIMARY KEY AUTOINCREMENT,host TEXT,protocol INTEGER,method INTEGER,url TEXT)");
    }

    private void createTbResult(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_result(_id INTEGER PRIMARY KEY AUTOINCREMENT,network TEXT,host TEXT,ip TEXT,ttl INTEGER,end_time INTEGER,cmd TEXT,update_time INTEGER,_view TEXT,uip TEXT,src INTEGER)");
        db.execSQL("CREATE INDEX gslb_result_idx ON gslb_result(network,host)");
    }

    private void createTbResultV6(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_result(_id INTEGER PRIMARY KEY AUTOINCREMENT,network TEXT,host TEXT,ip TEXT,ttl INTEGER,end_time INTEGER,cmd TEXT,update_time INTEGER,_view TEXT,uip TEXT,src INTEGER)");
        db.execSQL("CREATE INDEX gslb_result_v6_idx ON gslb_result(network,host)");
    }

    private void createTbServer(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_server(_id INTEGER PRIMARY KEY AUTOINCREMENT,isp INTEGER,ip TEXT,ver TEXT)");
    }

    private void createTbServerV6(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_server_v6(_id INTEGER PRIMARY KEY AUTOINCREMENT,isp INTEGER,ip TEXT,ver TEXT)");
    }

    private void createTbDelay(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_delay(_id INTEGER PRIMARY KEY AUTOINCREMENT,host TEXT,ip TEXT,delay INTEGER)");
        LogTools.printInfo("CREATE TABLE gslb_delay");
    }

    private void createTbHijack(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS gslb_hijack(_id INTEGER PRIMARY KEY AUTOINCREMENT,host TEXT,nt INTEGER,uip TEXT,dnsip TEXT,hip TEXT)");
    }

    private void dropTbHost(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS gslb_host");
        LogTools.printInfo("DROP TABLE gslb_host");
    }

    private void dropTbProbe(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS gslb_probe");
    }

    private void dropTbResult(SQLiteDatabase db) {
        try {
            db.execSQL("DROP INDEX gslb_result_idx ON gslb_result");
        }
        catch (Exception e) {
            LogTools.printInfo("drop index error");
        }
        db.execSQL("DROP TABLE IF EXISTS gslb_result");
    }

    private void dropTbResultV6(SQLiteDatabase db) {
        try {
            db.execSQL("DROP INDEX gslb_result_v6_idx ON gslb_result");
        }
        catch (Exception e) {
            LogTools.printInfo("drop index error");
        }
        db.execSQL("DROP TABLE IF EXISTS gslb_result");
    }

    private void dropTbServer(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS gslb_server");
    }

    private void dropTbServerV6(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS gslb_server_v6");
    }

    private void dropTbDelay(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS gslb_delay");
    }

    private void dropTbHijack(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS gslb_hijack");
    }
}

