/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.protocol;

import com.yy.gslbsdk.protocol.CmdInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.LinkedList;
import org.json.JSONObject;

public class DnsInfo {
    private String host;
    private int ttl;
    private long endTime;
    private long probeTime;
    private LinkedList<String> ips = new LinkedList();
    private CmdInfo cmd;
    private String view;
    private String uip;
    private int nt;
    private int source;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
        this.endTime = System.currentTimeMillis() + (long)((int)((float)ttl * GlobalTools.TTL_EXPIRED_FACTOR * 1000.0f));
        this.probeTime = System.currentTimeMillis() + (long)((int)((float)ttl * GlobalTools.TTL_PROBE_FACTOR * 1000.0f));
    }

    public LinkedList<String> getIps() {
        return this.ips;
    }

    public void setIps(LinkedList<String> ips) {
        if (ips == null) {
            return;
        }
        this.ips = ips;
    }

    public CmdInfo getCmd() {
        return this.cmd;
    }

    public void setCmd(CmdInfo cmd) {
        this.cmd = cmd;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public long getProbeTime() {
        return this.probeTime;
    }

    public void setProbeTime(long probeTime) {
        this.probeTime = probeTime;
    }

    public String getUip() {
        return this.uip;
    }

    public void setUip(String uip) {
        this.uip = uip;
    }

    public int getNt() {
        return this.nt;
    }

    public void setNt(int nt) {
        this.nt = nt;
    }

    public String getIPStr() {
        if (this.ips != null && !this.ips.isEmpty()) {
            String ipstr = "";
            for (int i = 0; i < this.ips.size(); ++i) {
                ipstr = ipstr + this.ips.get(i);
                if (i == this.ips.size() - 1) continue;
                ipstr = ipstr + ",";
            }
            return ipstr;
        }
        return null;
    }

    public void setIPStr(String str) {
        if (str != null) {
            String[] strs;
            for (String item : strs = str.split(",")) {
                if (item == null) continue;
                if (this.ips == null) {
                    this.ips = new LinkedList();
                }
                this.ips.add(item);
            }
        }
    }

    public String getCmdStr() {
        if (this.cmd != null) {
            try {
                JSONObject cmdstr = new JSONObject();
                cmdstr.put("pe", this.cmd.isPe());
                cmdstr.put("re", this.cmd.isRe());
                return cmdstr.toString();
            }
            catch (Exception e) {
                LogTools.printError("getCmdStr() exception:" + e.getMessage());
                return "";
            }
        }
        return "";
    }

    public void setCmdStr(String str) {
        if (str != null && !str.equals("")) {
            try {
                JSONObject cmdjson = new JSONObject(str);
                this.cmd = new CmdInfo();
                if (cmdjson.has("pe")) {
                    this.cmd.setPe(cmdjson.getBoolean("pe"));
                }
                if (cmdjson.has("re")) {
                    this.cmd.setRe(cmdjson.getBoolean("re"));
                }
            }
            catch (Exception e) {
                LogTools.printError("setCmdStr() exception:" + e.getMessage());
            }
        }
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public void cloneDnsInfo(DnsInfo newItem) {
        this.host = newItem.getHost();
        this.uip = newItem.getUip();
        this.view = newItem.getView();
        this.ttl = newItem.getTtl();
        this.probeTime = newItem.getProbeTime();
        this.endTime = newItem.getEndTime();
        this.cmd = newItem.getCmd();
        this.ips = newItem.getIps();
        this.source = newItem.getSource();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.host);
        sb.append(":[");
        sb.append(this.getIPStr());
        sb.append("],");
        sb.append("ttl=");
        sb.append(String.valueOf(this.ttl));
        return sb.toString();
    }
}

