/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.cache;

import android.content.Context;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public enum DataV6CacheMgr {
    INSTANCE;

    private ConcurrentHashMap<String, DnsInfo> mLocalDNSCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResultTB> mHttpDNSCache = new ConcurrentHashMap();

    public void putLocalDNSIntoCache(DnsInfo dnsInfo) {
        if (dnsInfo != null) {
            this.mLocalDNSCache.put(dnsInfo.getHost(), dnsInfo);
        }
    }

    public int getLocalDNSFromCache(String host, DnsInfo dnsInfo) {
        if (dnsInfo != null) {
            if (this.mLocalDNSCache.containsKey(host)) {
                DnsInfo info = this.mLocalDNSCache.get(host);
                if (info.getEndTime() > System.currentTimeMillis()) {
                    dnsInfo.cloneDnsInfo(info);
                    return 0;
                }
                return 2;
            }
            return 2;
        }
        return 5;
    }

    public int putHttpDNSIntoMemCache(ResultTB resInfo) {
        if (resInfo != null) {
            try {
                this.mHttpDNSCache.put(resInfo.getHost(), resInfo);
            }
            catch (Exception e) {
                GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
                LogTools.printWarning(e);
            }
        }
        return 0;
    }

    public ResultTB getHttpDNSFromMemCache(String network, String host) {
        try {
            ResultTB rs = this.mHttpDNSCache.get(host);
            if (rs != null && network.equals(rs.getNetwork())) {
                return rs;
            }
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return null;
    }

    public void deleteHttpDNSFromMemCache(String host) {
        try {
            this.mHttpDNSCache.remove(host);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
    }

    public ConcurrentHashMap<String, DnsInfo> getAllLocalDNSFromCache() {
        return this.mLocalDNSCache;
    }

    public int putHttpDNSIntoCache(Context context, ResInfo resInfo) {
        if (resInfo.getNetInfo() != null) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
            String netId = resInfo.getNetInfo().getNetStatusID();
            if (resInfo.getDns() != null) {
                for (DnsInfo dnsInfo : resInfo.getDns().values()) {
                    ResultTB addItem = new ResultTB();
                    addItem.setNetwork(netId);
                    addItem.setHost(dnsInfo.getHost());
                    addItem.setTtl(dnsInfo.getTtl());
                    addItem.setEndTime(dnsInfo.getEndTime());
                    addItem.setCmd(dnsInfo.getCmdStr());
                    addItem.setUpdateTime(System.currentTimeMillis());
                    addItem.setView(dnsInfo.getView());
                    addItem.setUip(dnsInfo.getUip());
                    addItem.setSource(dnsInfo.getSource());
                    if (dnsInfo.getIPStr() != null) {
                        addItem.setIp(dnsInfo.getIPStr());
                        dbMgr.addOrUpdateV6(addItem, true);
                    }
                    this.putHttpDNSIntoMemCache(addItem);
                }
                return 0;
            }
            return 5;
        }
        return 5;
    }

    public int getHttpDNSFromCache(Context context, String network, String host, DnsInfo dnsInfo) {
        if (dnsInfo != null) {
            DBAccessMgr dbMgr;
            List<ResultTB> result;
            ResultTB item = this.getHttpDNSFromMemCache(network, host);
            if (item == null && (result = (dbMgr = DBAccessMgr.getInstance(context)).getResultV6ByNetworkHost(network, host)) != null && !result.isEmpty()) {
                item = result.get(0);
            }
            if (item != null) {
                dnsInfo.setHost(item.getHost());
                dnsInfo.setTtl(item.getTtl());
                dnsInfo.setIPStr(item.getIp());
                dnsInfo.setCmdStr(item.getCmd());
                dnsInfo.setView(item.getView());
                dnsInfo.setUip(item.getUip());
                dnsInfo.setEndTime(item.getEndTime());
                dnsInfo.setProbeTime(item.getUpdateTime() + (long)((int)((float)item.getTtl() * GlobalTools.TTL_PROBE_FACTOR * 1000.0f)));
                return 0;
            }
            return 2;
        }
        return 5;
    }
}

