/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.statistic;

import android.text.TextUtils;
import com.yy.gslbsdk.statistic.StatisticInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticMgr {
    private static StatisticMgr sInstance = null;
    private IGslbStatistic mStatistic = null;
    private Map<String, StatisticInfo> mMapStatistic = new ConcurrentHashMap<String, StatisticInfo>();

    public static StatisticMgr getInstance() {
        if (sInstance == null) {
            sInstance = new StatisticMgr();
        }
        return sInstance;
    }

    public void setStatistic(IGslbStatistic statistic) {
        this.mStatistic = statistic;
    }

    public void onStatistic(Map<String, String> rsInfo) {
        if (this.mStatistic == null) {
            return;
        }
        this.mStatistic.onStatistic(rsInfo);
    }

    public StatisticInfo getStatisticInfo(String requestId) {
        if (TextUtils.isEmpty((CharSequence)requestId)) {
            return null;
        }
        return this.mMapStatistic.get(requestId);
    }

    public boolean setStatisticInfo(String requestId, StatisticInfo rsInfo) {
        if (TextUtils.isEmpty((CharSequence)requestId)) {
            return false;
        }
        if (this.mMapStatistic.containsKey(requestId)) {
            return false;
        }
        this.mMapStatistic.put(requestId, rsInfo);
        return true;
    }

    public void removeStatisticInfo(String requestId) {
        this.mMapStatistic.remove(requestId);
    }

    public static interface IGslbStatistic {
        public void onStatistic(Map<String, String> var1);
    }
}

