/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.db.DBInitMgr;
import com.yy.gslbsdk.db.HijackTB;
import com.yy.gslbsdk.db.HostTB;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.db.ServerTB;
import com.yy.gslbsdk.db.ServerV6TB;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DBAccessMgr {
    private SQLiteDatabase db = null;
    private DBInitMgr dbHelper = null;
    private static DBAccessMgr instance = null;

    public static synchronized DBAccessMgr getInstance(Context context) {
        if (instance == null) {
            instance = new DBAccessMgr(context);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBAccessMgr(Context context) {
        boolean again = false;
        try {
            this.dbHelper = new DBInitMgr(context, GlobalTools.DB_NAME, null, GlobalTools.DB_VERSION);
            this.db = this.dbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            LogTools.printError(String.format("open db failed. %s ", e.getMessage()));
            GslbEvent.INSTANCE.onMessage(String.format("open db failed. %s ", e.getMessage()));
            again = true;
        }
        if (!again) {
            return;
        }
        try {
            if (this.dbHelper != null) {
                this.dbHelper.close();
            }
            if (this.db != null && this.db.isOpen()) {
                this.db.close();
            }
        }
        catch (Exception e) {
            LogTools.printError(String.format("close db failed before open it again. %s ", e.getMessage()));
            GslbEvent.INSTANCE.onMessage(String.format("close db failed before open it again. %s ", e.getMessage()));
        }
        finally {
            context.deleteDatabase(GlobalTools.DB_NAME);
        }
        try {
            this.dbHelper = new DBInitMgr(context, GlobalTools.DB_NAME, null, GlobalTools.DB_VERSION);
            this.db = this.dbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            LogTools.printError(String.format("open db failed again. %s ", e.getMessage()));
            GslbEvent.INSTANCE.onMessage(String.format("open db failed again. %s ", e.getMessage()));
        }
    }

    public synchronized void Close() {
        this.db.close();
        this.dbHelper.close();
    }

    public synchronized Long addHost(HostTB host) {
        ContentValues values = new ContentValues();
        values.put("host", host.getHost());
        values.put("insert_time", Long.valueOf(host.getInsertTime()));
        values.put("is_pre", Integer.valueOf(host.getIsPre()));
        Long id = 0L;
        try {
            id = this.db.insert("gslb_host", null, values);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return id;
    }

    public synchronized int delHost(HostTB host) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (host.getId() != -1) {
            whereClause.add("_id=?");
            whereArgs.add(String.valueOf(host.getId()));
        }
        if (host.getHost() != null) {
            whereClause.add("host=?");
            whereArgs.add(String.valueOf(host.getHost()));
        }
        if (host.getIsPre() != -1) {
            whereClause.add("is_pre=?");
            whereArgs.add(String.valueOf(host.getIsPre()));
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_host", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized int updateHost(HostTB host) {
        ContentValues values = new ContentValues();
        if (host.getHost() != null) {
            values.put("host", host.getHost());
        }
        if (host.getIsPre() != -1) {
            values.put("is_pre", Integer.valueOf(host.getIsPre()));
        }
        if (host.getInsertTime() != -1L) {
            values.put("insert_time", Long.valueOf(host.getInsertTime()));
        }
        int num = 0;
        try {
            num = this.db.update("gslb_host", values, "_id=?", new String[]{String.valueOf(host.getId())});
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized List<HostTB> getAllHost() {
        ArrayList<HostTB> hostList = new ArrayList<HostTB>();
        try {
            Cursor cursor = this.db.query("gslb_host", null, null, null, null, null, "insert_time DESC");
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                HostTB host = new HostTB();
                host.setId(cursor.getInt(0));
                host.setHost(cursor.getString(1));
                host.setIsPre(cursor.getInt(2));
                host.setInsertTime(cursor.getLong(3));
                hostList.add(host);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return hostList;
    }

    public synchronized List<HostTB> getHostByHost(String host) {
        ArrayList<HostTB> hostList = new ArrayList<HostTB>();
        try {
            Cursor cursor = this.db.query("gslb_host", null, "host=?", new String[]{String.valueOf(host)}, null, null, null);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                HostTB hostInfo = new HostTB();
                hostInfo.setId(cursor.getInt(0));
                hostInfo.setHost(cursor.getString(1));
                hostInfo.setIsPre(cursor.getInt(2));
                hostInfo.setInsertTime(cursor.getLong(3));
                hostList.add(hostInfo);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return hostList;
    }

    public synchronized Long addResult(ResultTB result) {
        ContentValues values = new ContentValues();
        values.put("network", result.getNetwork());
        values.put("host", result.getHost());
        values.put("ip", result.getIp());
        values.put("ttl", Integer.valueOf(result.getTtl()));
        values.put("end_time", Long.valueOf(result.getEndTime()));
        values.put("cmd", result.getCmd());
        values.put("update_time", Long.valueOf(result.getUpdateTime()));
        values.put("_view", result.getView());
        values.put("uip", result.getUip());
        Long id = 0L;
        try {
            id = this.db.insert("gslb_result", null, values);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return id;
    }

    public synchronized Long addOrUpdate(ResultTB result, boolean update) {
        List<ResultTB> rs = this.getResultByNetworkHost(result.getNetwork(), result.getHost());
        if (rs.isEmpty()) {
            return this.addResult(result);
        }
        if (update) {
            result.setId(rs.get(0).getId());
            this.updateResult(result);
        }
        return 0L;
    }

    public synchronized int delResult(ResultTB result) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (result.getId() != -1) {
            whereClause.add("_id=?");
            whereArgs.add(String.valueOf(result.getId()));
        }
        if (result.getNetwork() != null) {
            whereClause.add("network=?");
            whereArgs.add(String.valueOf(result.getNetwork()));
        }
        if (result.getHost() != null) {
            whereClause.add("host=?");
            whereArgs.add(String.valueOf(result.getHost()));
        }
        if (result.getIp() != null) {
            whereClause.add("ip=?");
            whereArgs.add(String.valueOf(result.getIp()));
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_result", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized int delResultByHost(String host) {
        if (host == null) {
            return 0;
        }
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        whereClause.add("host=?");
        whereArgs.add(host);
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_result", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized int updateResult(ResultTB result) {
        ContentValues values = new ContentValues();
        if (result.getNetwork() != null) {
            values.put("network", result.getNetwork());
        }
        if (result.getHost() != null) {
            values.put("host", result.getHost());
        }
        if (result.getIp() != null) {
            values.put("ip", result.getIp());
        }
        if (result.getTtl() != -1) {
            values.put("ttl", Integer.valueOf(result.getTtl()));
        }
        if (result.getEndTime() != -1L) {
            values.put("end_time", Long.valueOf(result.getEndTime()));
        }
        if (result.getCmd() != null) {
            values.put("cmd", result.getCmd());
        }
        if (result.getUpdateTime() != -1L) {
            values.put("update_time", Long.valueOf(result.getUpdateTime()));
        }
        if (result.getView() != null) {
            values.put("_view", result.getView());
        }
        if (result.getUip() != null) {
            values.put("uip", result.getUip());
        }
        int num = 0;
        try {
            num = this.db.update("gslb_result", values, "_id=?", new String[]{String.valueOf(result.getId())});
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized List<ResultTB> getResultByNetworkHost(String network, String host) {
        ArrayList<ResultTB> resultList = new ArrayList<ResultTB>();
        try {
            Cursor cursor = this.db.query("gslb_result", null, "network=? and host=?", new String[]{network, host}, null, null, null);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                ResultTB result = new ResultTB();
                result.setId(cursor.getInt(0));
                result.setNetwork(cursor.getString(1));
                result.setHost(cursor.getString(2));
                result.setIp(cursor.getString(3));
                result.setTtl(cursor.getInt(4));
                result.setEndTime(cursor.getLong(5));
                result.setCmd(cursor.getString(6));
                result.setUpdateTime(cursor.getLong(7));
                result.setView(cursor.getString(8));
                result.setUip(cursor.getString(9));
                result.setSource(cursor.getInt(10));
                resultList.add(result);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return resultList;
    }

    public synchronized Long addResultV6(ResultTB result) {
        ContentValues values = new ContentValues();
        values.put("network", result.getNetwork());
        values.put("host", result.getHost());
        values.put("ip", result.getIp());
        values.put("ttl", Integer.valueOf(result.getTtl()));
        values.put("end_time", Long.valueOf(result.getEndTime()));
        values.put("cmd", result.getCmd());
        values.put("update_time", Long.valueOf(result.getUpdateTime()));
        values.put("_view", result.getView());
        values.put("uip", result.getUip());
        Long id = 0L;
        try {
            id = this.db.insert("gslb_result", null, values);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return id;
    }

    public synchronized Long addOrUpdateV6(ResultTB result, boolean update) {
        List<ResultTB> rs = this.getResultV6ByNetworkHost(result.getNetwork(), result.getHost());
        if (rs.isEmpty()) {
            return this.addResultV6(result);
        }
        if (update) {
            result.setId(rs.get(0).getId());
            this.updateResultV6(result);
        }
        return 0L;
    }

    public synchronized int delResultV6(ResultTB result) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (result.getId() != -1) {
            whereClause.add("_id=?");
            whereArgs.add(String.valueOf(result.getId()));
        }
        if (result.getNetwork() != null) {
            whereClause.add("network=?");
            whereArgs.add(String.valueOf(result.getNetwork()));
        }
        if (result.getHost() != null) {
            whereClause.add("host=?");
            whereArgs.add(String.valueOf(result.getHost()));
        }
        if (result.getIp() != null) {
            whereClause.add("ip=?");
            whereArgs.add(String.valueOf(result.getIp()));
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_result", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized int delResultV6ByHost(String host) {
        if (host == null) {
            return 0;
        }
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        whereClause.add("host=?");
        whereArgs.add(host);
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_result", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized int updateResultV6(ResultTB result) {
        ContentValues values = new ContentValues();
        if (result.getNetwork() != null) {
            values.put("network", result.getNetwork());
        }
        if (result.getHost() != null) {
            values.put("host", result.getHost());
        }
        if (result.getIp() != null) {
            values.put("ip", result.getIp());
        }
        if (result.getTtl() != -1) {
            values.put("ttl", Integer.valueOf(result.getTtl()));
        }
        if (result.getEndTime() != -1L) {
            values.put("end_time", Long.valueOf(result.getEndTime()));
        }
        if (result.getCmd() != null) {
            values.put("cmd", result.getCmd());
        }
        if (result.getUpdateTime() != -1L) {
            values.put("update_time", Long.valueOf(result.getUpdateTime()));
        }
        if (result.getView() != null) {
            values.put("_view", result.getView());
        }
        if (result.getUip() != null) {
            values.put("uip", result.getUip());
        }
        int num = 0;
        try {
            num = this.db.update("gslb_result", values, "_id=?", new String[]{String.valueOf(result.getId())});
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized List<ResultTB> getResultV6ByNetworkHost(String network, String host) {
        ArrayList<ResultTB> resultList = new ArrayList<ResultTB>();
        try {
            Cursor cursor = this.db.query("gslb_result", null, "network=? and host=?", new String[]{network, host}, null, null, null);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                ResultTB result = new ResultTB();
                result.setId(cursor.getInt(0));
                result.setNetwork(cursor.getString(1));
                result.setHost(cursor.getString(2));
                result.setIp(cursor.getString(3));
                result.setTtl(cursor.getInt(4));
                result.setEndTime(cursor.getLong(5));
                result.setCmd(cursor.getString(6));
                result.setUpdateTime(cursor.getLong(7));
                result.setView(cursor.getString(8));
                result.setUip(cursor.getString(9));
                result.setSource(cursor.getInt(10));
                resultList.add(result);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return resultList;
    }

    public synchronized Long addServer(ServerTB server) {
        ContentValues values = new ContentValues();
        values.put("isp", Integer.valueOf(server.getIsp()));
        values.put("ip", server.getIp());
        values.put("ver", Integer.valueOf(server.getVer()));
        Long id = 0L;
        try {
            id = this.db.insert("gslb_server", null, values);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return id;
    }

    public synchronized int delServer(ServerTB server) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (server.getId() != -1) {
            whereClause.add("_id=?");
            whereArgs.add(String.valueOf(server.getId()));
        }
        if (server.getIsp() != -1) {
            whereClause.add("isp=?");
            whereArgs.add(String.valueOf(server.getIsp()));
        }
        if (server.getIp() != null) {
            whereClause.add("ip=?");
            whereArgs.add(String.valueOf(server.getIp()));
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_server", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized void delSomeServer(List<ServerTB> serverList) {
        if (serverList == null) {
            return;
        }
        for (ServerTB server : serverList) {
            this.delServer(server);
        }
    }

    public synchronized List<ServerTB> getAllServer() {
        ArrayList<ServerTB> serverList = new ArrayList<ServerTB>();
        try {
            Cursor cursor = this.db.query("gslb_server", null, null, null, null, null, "_id");
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                ServerTB server = new ServerTB();
                server.setId(cursor.getInt(0));
                server.setIsp(cursor.getInt(1));
                server.setIp(cursor.getString(2));
                server.setVer(cursor.getInt(3));
                serverList.add(server);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return serverList;
    }

    public synchronized List<ServerTB> getServerByIsp(int isp) {
        ArrayList<ServerTB> serverList = new ArrayList<ServerTB>();
        try {
            Cursor cursor = this.db.query("gslb_server", null, "isp=" + isp, null, null, null, "_id");
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                ServerTB server = new ServerTB();
                server.setId(cursor.getInt(0));
                server.setIsp(cursor.getInt(1));
                server.setIp(cursor.getString(2));
                server.setVer(cursor.getInt(3));
                serverList.add(server);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return serverList;
    }

    public synchronized Long addServerV6(ServerV6TB server) {
        ContentValues values = new ContentValues();
        values.put("isp", Integer.valueOf(server.getIsp()));
        values.put("ip", server.getIp());
        values.put("ver", Integer.valueOf(server.getVer()));
        Long id = 0L;
        try {
            id = this.db.insert("gslb_server_v6", null, values);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return id;
    }

    public synchronized int delServerV6(ServerV6TB server) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (server.getId() != -1) {
            whereClause.add("_id=?");
            whereArgs.add(String.valueOf(server.getId()));
        }
        if (server.getIsp() != -1) {
            whereClause.add("isp=?");
            whereArgs.add(String.valueOf(server.getIsp()));
        }
        if (server.getIp() != null) {
            whereClause.add("ip=?");
            whereArgs.add(String.valueOf(server.getIp()));
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_server_v6", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized void delSomeServerV6(List<ServerV6TB> serverList) {
        if (serverList == null) {
            return;
        }
        for (ServerV6TB server : serverList) {
            this.delServerV6(server);
        }
    }

    public synchronized List<ServerV6TB> getAllServerV6() {
        ArrayList<ServerV6TB> serverList = new ArrayList<ServerV6TB>();
        try {
            Cursor cursor = this.db.query("gslb_server_v6", null, null, null, null, null, "_id");
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                ServerV6TB server = new ServerV6TB();
                server.setId(cursor.getInt(0));
                server.setIsp(cursor.getInt(1));
                server.setIp(cursor.getString(2));
                server.setVer(cursor.getInt(3));
                serverList.add(server);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return serverList;
    }

    public synchronized List<ServerV6TB> getServerV6ByIsp(int isp) {
        ArrayList<ServerV6TB> serverList = new ArrayList<ServerV6TB>();
        try {
            Cursor cursor = this.db.query("gslb_server_v6", null, "isp=" + isp, null, null, null, "_id");
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                ServerV6TB server = new ServerV6TB();
                server.setId(cursor.getInt(0));
                server.setIsp(cursor.getInt(1));
                server.setIp(cursor.getString(2));
                server.setVer(cursor.getInt(3));
                serverList.add(server);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return serverList;
    }

    public synchronized Long addHijack(HijackTB hijack) {
        ContentValues values = new ContentValues();
        values.put("host", hijack.getHost());
        values.put("nt", Integer.valueOf(hijack.getNt()));
        values.put("uip", hijack.getUip());
        values.put("dnsip", hijack.getDnsip());
        values.put("hip", hijack.getHip());
        Long id = 0L;
        try {
            id = this.db.insert("gslb_hijack", null, values);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return id;
    }

    public synchronized int delHijack(HijackTB hijack) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (hijack.getId() != -1) {
            whereClause.add("_id=?");
            whereArgs.add(String.valueOf(hijack.getId()));
        }
        if (hijack.getHost() != null) {
            whereClause.add("host=?");
            whereArgs.add(String.valueOf(hijack.getHost()));
        }
        if (hijack.getNt() != -1) {
            whereClause.add("nt=?");
            whereArgs.add(String.valueOf(hijack.getNt()));
        }
        if (hijack.getUip() != null) {
            whereClause.add("uip=?");
            whereArgs.add(String.valueOf(hijack.getUip()));
        }
        if (hijack.getDnsip() != null) {
            whereClause.add("dnsip=?");
            whereArgs.add(String.valueOf(hijack.getDnsip()));
        }
        if (hijack.getHip() != null) {
            whereClause.add("hip=?");
            whereArgs.add(String.valueOf(hijack.getHip()));
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_hijack", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized int delHijackByHost(String host) {
        LinkedList<String> whereClause = new LinkedList<String>();
        LinkedList<String> whereArgs = new LinkedList<String>();
        if (host != null && host.length() > 0) {
            whereClause.add("host=?");
            whereArgs.add(host);
        }
        String whereClauseStr = "";
        for (int i = 0; i < whereClause.size(); ++i) {
            whereClauseStr = whereClauseStr + (String)whereClause.get(i);
            if (i == whereClause.size() - 1) continue;
            whereClauseStr = whereClauseStr + " and ";
        }
        int num = 0;
        try {
            num = this.db.delete("gslb_hijack", whereClauseStr, whereArgs.toArray(new String[0]));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return num;
    }

    public synchronized List<HijackTB> getAllHijack() {
        ArrayList<HijackTB> hijackList = new ArrayList<HijackTB>();
        try {
            Cursor cursor = this.db.query("gslb_hijack", null, null, null, null, null, null);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                HijackTB hijack = new HijackTB();
                hijack.setId(cursor.getInt(0));
                hijack.setHost(cursor.getString(1));
                hijack.setNt(cursor.getInt(2));
                hijack.setUip(cursor.getString(3));
                hijack.setDnsip(cursor.getString(4));
                hijack.setHip(cursor.getString(5));
                hijackList.add(hijack);
                cursor.moveToNext();
            }
            cursor.close();
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return hijackList;
    }
}

