/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.cache;

import android.content.Context;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.cache.ServerIPInfo;
import com.yy.gslbsdk.cache.ServerIPV6Mgr;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.ServerTB;
import com.yy.gslbsdk.protocol.UpdateServerInfo;
import com.yy.gslbsdk.protocol.UpdateServerProtocolMgr;
import com.yy.gslbsdk.thread.AsynTaskMgr;
import com.yy.gslbsdk.thread.ThreadInfo;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import com.yy.gslbsdk.util.RuntimeTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServerIPMgr {
    public static String curLocalDNSIp = null;
    public static String reportUrl = "http://cn-sdkreport.gslb.yy.com/sdk/report";
    public List<Integer> mListUsedIsp = null;
    public static final String[] SERVER_IP_CTL = new String[]{"221.228.79.252", "106.38.197.38", "150.138.202.132", "110.185.110.74", "113.107.236.203", "14.17.109.79"};
    public static final String[] SERVER_IP_CNC = new String[]{"175.20.85.131", "103.227.121.124", "123.125.184.134", "122.13.211.75"};
    public static final String[] SERVER_IP_CMC = new String[]{"120.195.158.59", "223.99.234.4", "183.232.136.138"};
    public static final String[] SERVER_IP_EDU = new String[]{"180.208.65.113"};
    public static final String[] SERVER_IP_PUBLIC = new String[0];
    public static final String[] SERVER_IP_LOCALIZE = new String[0];
    private static ServerIPMgr mServerIPMgr = null;
    private LinkedList<ServerIPInfo> mBestServerIpCache = new LinkedList();
    private ConcurrentMap<Integer, ArrayList<ServerTB>> mIspServerIpCache = new ConcurrentHashMap<Integer, ArrayList<ServerTB>>();

    public static ServerIPMgr getInstance() {
        if (mServerIPMgr == null) {
            mServerIPMgr = new ServerIPMgr();
        }
        return mServerIPMgr;
    }

    public synchronized void resetBestServerIPCache(ServerIPInfo ipInfo) {
        if (ipInfo != null && ipInfo.getIp() != null) {
            int i;
            for (i = 0; i < this.mBestServerIpCache.size(); ++i) {
                if (!this.mBestServerIpCache.get(i).getIp().equals(ipInfo.getIp())) continue;
                this.mBestServerIpCache.remove(i);
                break;
            }
            int num = this.mBestServerIpCache.size();
            for (i = 0; i < num; ++i) {
                if (ipInfo.getScore() >= this.mBestServerIpCache.get(i).getScore()) continue;
                this.mBestServerIpCache.add(i, ipInfo);
                break;
            }
            if (i == num) {
                this.mBestServerIpCache.add(ipInfo);
            }
        }
    }

    public synchronized LinkedList<ServerIPInfo> getBestServerIPCache() {
        return (LinkedList)this.mBestServerIpCache.clone();
    }

    public synchronized void clearBestServerIPCache() {
        this.mBestServerIpCache.clear();
    }

    public void initUsedIsp(String localize) {
        if (this.mListUsedIsp == null) {
            this.mListUsedIsp = new LinkedList<Integer>();
        } else {
            this.mListUsedIsp.clear();
        }
        if ("CN".equalsIgnoreCase(localize)) {
            this.mListUsedIsp.add(1);
            this.mListUsedIsp.add(2);
            this.mListUsedIsp.add(3);
            this.mListUsedIsp.add(4);
            this.mListUsedIsp.add(5);
        } else {
            this.mListUsedIsp.add(6);
            this.mListUsedIsp.add(5);
        }
    }

    public void initServerIP(final Context context, String localize) {
        curLocalDNSIp = RuntimeTools.execCmd(GlobalTools.CMD_GET_LOCALDNS_IP);
        this.initUsedIsp(localize);
        if (this.mIspServerIpCache == null || this.mIspServerIpCache.isEmpty()) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
            boolean initFromHardCode = true;
            List<ServerTB> serverList = dbMgr.getAllServer();
            if (serverList != null && !serverList.isEmpty()) {
                for (int i = 0; i < serverList.size(); ++i) {
                    ServerTB stb = serverList.get(i);
                    if (!this.mListUsedIsp.contains(stb.getIsp())) continue;
                    initFromHardCode = false;
                    break;
                }
            }
            if (!initFromHardCode) {
                this.addIspServerIpCache(serverList);
            } else {
                HashMap<Integer, String[]> mapUsedHardCodeServerIp = new HashMap<Integer, String[]>();
                mapUsedHardCodeServerIp.put(5, SERVER_IP_PUBLIC);
                if ("CN".equalsIgnoreCase(GlobalTools.APP_LOCALIZE_CODE)) {
                    mapUsedHardCodeServerIp.put(1, SERVER_IP_CTL);
                    mapUsedHardCodeServerIp.put(2, SERVER_IP_CNC);
                    mapUsedHardCodeServerIp.put(3, SERVER_IP_CMC);
                    mapUsedHardCodeServerIp.put(4, SERVER_IP_EDU);
                } else {
                    mapUsedHardCodeServerIp.put(6, SERVER_IP_LOCALIZE);
                }
                for (int i = 0; i < this.mListUsedIsp.size(); ++i) {
                    int isp = this.mListUsedIsp.get(i);
                    String[] arrServerIp = (String[])mapUsedHardCodeServerIp.get(isp);
                    if (arrServerIp != null && arrServerIp.length > 0) {
                        ArrayList<ServerTB> list = new ArrayList<ServerTB>(arrServerIp.length);
                        for (String ip : arrServerIp) {
                            ServerTB server = new ServerTB();
                            server.setIp(ip);
                            server.setIsp(isp);
                            server.setVer(0);
                            list.add(server);
                        }
                        Collections.shuffle(list);
                        this.mIspServerIpCache.putIfAbsent(isp, list);
                        continue;
                    }
                    LogTools.printError(String.format("initServerIP there is no server ip in hard code with isp = %d ", isp));
                }
                AsynTaskMgr.INSTANCE.post(new Runnable(){

                    @Override
                    public void run() {
                        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
                        List<ServerTB> serverList = dbMgr.getAllServer();
                        if (serverList != null && !serverList.isEmpty()) {
                            LogTools.printInfo(String.format("initServerIP db server ip is not empty, size is %d ", serverList.size()));
                            return;
                        }
                        for (int i = 0; i < ServerIPMgr.this.mListUsedIsp.size(); ++i) {
                            int isp = ServerIPMgr.this.mListUsedIsp.get(i);
                            List list = (List)ServerIPMgr.this.mIspServerIpCache.get(isp);
                            if (list == null || list.size() <= 0) continue;
                            for (ServerTB serverTB : list) {
                                dbMgr.addServer(serverTB);
                            }
                        }
                    }
                });
            }
        }
        LogTools.printDebug("initServerIP...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getServerIpListFromCache(int isp) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.mIspServerIpCache.containsKey(isp)) {
            ArrayList listRaw = (ArrayList)this.mIspServerIpCache.get(isp);
            ArrayList list = null;
            ArrayList arrayList = listRaw;
            synchronized (arrayList) {
                list = (ArrayList)listRaw.clone();
            }
            for (int i = 0; i < list.size(); ++i) {
                String ip = ((ServerTB)list.get(i)).getIp();
                if (ip == null) continue;
                result.add(ip);
            }
        }
        return result;
    }

    private ArrayList<String> getServerIpListFromDb(Context context, int isp) {
        ArrayList<String> result = new ArrayList<String>();
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
        List<ServerTB> serverList = dbMgr.getServerByIsp(isp);
        if (serverList != null && !serverList.isEmpty()) {
            for (int i = 0; i < serverList.size(); ++i) {
                String ip = serverList.get(i).getIp();
                if (ip == null) continue;
                result.add(ip);
            }
        }
        return result;
    }

    public ArrayList<String> getServerIPByKnownISP(Context context, int isp) {
        int i;
        ArrayList<String> listPublic;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> listCurr = this.getServerIpListFromCache(isp);
        Collections.shuffle(listCurr);
        if (listCurr.isEmpty()) {
            listCurr = this.getServerIpListFromDb(context, isp);
        }
        if (!listCurr.isEmpty()) {
            for (int i2 = 0; i2 < GlobalTools.CUR_ISP_IP_NUM && i2 < listCurr.size(); ++i2) {
                result.add(listCurr.get(i2));
            }
        }
        if ((listPublic = this.getServerIpListFromCache(5)).isEmpty()) {
            listPublic = this.getServerIpListFromDb(context, 5);
        }
        if (!listPublic.isEmpty()) {
            for (int i3 = 0; i3 < GlobalTools.OTHER_ISP_IP_NUM && i3 < listPublic.size(); ++i3) {
                result.add(listPublic.get(i3));
            }
        }
        ArrayList<String> listOther = new ArrayList<String>();
        for (i = 0; i < this.mListUsedIsp.size(); ++i) {
            int ispOther = this.mListUsedIsp.get(i);
            if (isp == ispOther) continue;
            ArrayList<String> listTmp = this.getServerIpListFromCache(ispOther);
            if (listTmp.isEmpty()) {
                listTmp = this.getServerIpListFromDb(context, ispOther);
            }
            if (listTmp.isEmpty()) continue;
            listOther.addAll(listTmp);
        }
        if (!listOther.isEmpty()) {
            Collections.shuffle(listOther);
            result.add((String)listOther.get(0));
        }
        if (result.size() < GlobalTools.MIN_CHN_ISP_IP_NUM) {
            for (i = 0; i < result.size(); ++i) {
                listCurr.remove(result.get(i));
            }
            for (int j = 0; j < listCurr.size() && result.size() < GlobalTools.MIN_CHN_ISP_IP_NUM; ++j) {
                result.add(listCurr.get(j));
            }
        }
        return result;
    }

    public ArrayList<String> getServerIPByUnKnownISP(Context context) {
        int numMin;
        ArrayList<String> result = new ArrayList<String>();
        boolean isCN = "CN".equalsIgnoreCase(GlobalTools.APP_LOCALIZE_CODE);
        for (int x = 0; x < this.mListUsedIsp.size(); ++x) {
            int isp = this.mListUsedIsp.get(x);
            ArrayList<String> listServerIp = this.getServerIpListFromCache(isp);
            if (listServerIp.isEmpty()) {
                listServerIp = this.getServerIpListFromDb(context, isp);
            }
            if (listServerIp.isEmpty()) continue;
            if (isCN) {
                Collections.shuffle(listServerIp);
                for (int y = 0; y < GlobalTools.CHN_ISP_IP_NUM && y < listServerIp.size(); ++y) {
                    result.add(listServerIp.get(y));
                }
                continue;
            }
            if (isp == 6) {
                int i;
                for (i = 0; i < GlobalTools.INTL_ISP_IP_NUM && i < listServerIp.size(); ++i) {
                    result.add(listServerIp.get(i));
                }
                for (i = 0; i < result.size(); ++i) {
                    listServerIp.remove(result.get(i));
                }
                if (listServerIp.isEmpty()) continue;
                Collections.shuffle(listServerIp);
                result.add(listServerIp.get(0));
                continue;
            }
            if (isp != 5) continue;
            result.add(listServerIp.get(0));
        }
        ArrayList<Integer> listIsp2AddServerIp = new ArrayList<Integer>();
        if (isCN) {
            numMin = GlobalTools.MIN_CHN_ISP_IP_NUM;
            listIsp2AddServerIp.add(5);
        } else {
            numMin = GlobalTools.MIN_INTL_ISP_IP_NUM;
            listIsp2AddServerIp.add(6);
        }
        if (result.size() < numMin) {
            block4: for (int i = 0; i < listIsp2AddServerIp.size(); ++i) {
                int addIsp = (Integer)listIsp2AddServerIp.get(i);
                ArrayList<String> listServerIp = this.getServerIpListFromCache(addIsp);
                if (listServerIp.isEmpty()) {
                    listServerIp = this.getServerIpListFromDb(context, addIsp);
                }
                for (int z = 0; z < listServerIp.size(); ++z) {
                    String serverIp = listServerIp.get(z);
                    if (result.contains(serverIp)) continue;
                    result.add(serverIp);
                    if (result.size() >= numMin) continue block4;
                }
            }
        }
        return result;
    }

    public String getOneServerIPByKnownISP(Context context, int isp) {
        String result = null;
        ArrayList<String> listIp = this.getServerIpListFromCache(isp);
        if (listIp == null || listIp.isEmpty()) {
            listIp = this.getServerIpListFromDb(context, isp);
        }
        if (listIp != null && !listIp.isEmpty()) {
            result = listIp.get(0);
        }
        return result;
    }

    public String getOneServerIPByUnKnownISP(Context context) {
        if (this.mListUsedIsp == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        List<Integer> listIsp = this.mListUsedIsp;
        for (int i = 0; i < listIsp.size(); ++i) {
            int isp = listIsp.get(i);
            ArrayList<String> listIp = this.getServerIpListFromCache(isp);
            if (listIp == null || listIp.isEmpty()) {
                listIp = this.getServerIpListFromDb(context, isp);
            }
            if (listIp == null || listIp.isEmpty()) continue;
            result.add(listIp.get(0));
        }
        if (!result.isEmpty()) {
            Collections.shuffle(result);
            return (String)result.get(0);
        }
        return null;
    }

    public boolean canUpdate(Context context, int newVer) {
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
        List<ServerTB> serverList = dbMgr.getAllServer();
        if (serverList != null && !serverList.isEmpty()) {
            int curVer = serverList.get(0).getVer();
            return newVer > curVer;
        }
        return false;
    }

    public int updateServerIpByLocalDns(Context context) {
        return this.updateServerIP(context, GlobalTools.LOCALDNS_UPDATE_SERVER_HOST);
    }

    public int updateServerIP(final Context context, final String ip) {
        ThreadInfo task = new ThreadInfo("UpdateServerIP");
        task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

            @Override
            public void handleOper(String name) {
                String[] res = UpdateServerProtocolMgr.requestProtocol(ip, GlobalTools.HTTPS_LEVEL != 0);
                if (res == null) {
                    LogTools.printError("update server ip request error");
                    return;
                }
                LinkedHashMap<Integer, UpdateServerInfo> mapServerIpNew = new LinkedHashMap<Integer, UpdateServerInfo>();
                int code = UpdateServerProtocolMgr.responseProtocol(res[1], mapServerIpNew);
                if (code != 0) {
                    return;
                }
                code = ServerIPV6Mgr.getInstance().updateServerIP(context, res[1]);
                if (code != 0) {
                    return;
                }
                DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
                List<ServerTB> serverList = dbMgr.getAllServer();
                if (serverList != null && serverList.size() > 0) {
                    ServerTB serverTB = serverList.get(0);
                    Iterator<UpdateServerInfo> iterator = mapServerIpNew.values().iterator();
                    if (!iterator.hasNext()) {
                        return;
                    }
                    UpdateServerInfo info = iterator.next();
                    if (info.getVer() == serverTB.getVer()) {
                        GslbEvent.INSTANCE.onMessage(String.format("updateServerIP version is same. ver: %d", info.getVer()));
                        return;
                    }
                }
                ArrayList<ServerTB> listCacheNew = new ArrayList<ServerTB>(mapServerIpNew.size());
                for (int key : mapServerIpNew.keySet()) {
                    UpdateServerInfo info = mapServerIpNew.get(key);
                    for (String strIP : info.getIps()) {
                        ServerTB server = new ServerTB();
                        server.setIp(strIP);
                        server.setIsp(info.getIsp());
                        server.setVer(info.getVer());
                        dbMgr.addServer(server);
                        listCacheNew.add(server);
                    }
                }
                ServerIPMgr.this.mIspServerIpCache.clear();
                ServerIPMgr.this.addIspServerIpCache(listCacheNew);
                dbMgr.delSomeServer(serverList);
                ServerIPMgr.this.clearBestServerIPCache();
            }
        });
        ThreadPoolMgr.getInstance().addTask(task);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIspServerIpCache(List<ServerTB> list) {
        for (int i = 0; i < list.size(); ++i) {
            ServerTB server = list.get(i);
            int isp = server.getIsp();
            if (!this.mListUsedIsp.contains(isp)) continue;
            if (this.mIspServerIpCache.containsKey(isp)) {
                ArrayList listOld;
                ArrayList arrayList = listOld = (ArrayList)this.mIspServerIpCache.get(isp);
                synchronized (arrayList) {
                    listOld.add(server);
                    continue;
                }
            }
            ArrayList<ServerTB> listNew = new ArrayList<ServerTB>();
            listNew.add(server);
            this.mIspServerIpCache.putIfAbsent(isp, listNew);
        }
    }
}

