/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.network;

import android.os.Build;
import com.yy.gslbsdk.util.LogTools;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class GoodSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory defaultFactory;
    static String[] protocols = null;
    static String[] cipherSuites = null;

    public GoodSSLSocketFactory(X509TrustManager tm) {
        try {
            TrustManager[] trustManagerArray;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            if (tm != null) {
                TrustManager[] trustManagerArray2 = new X509TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = tm;
            } else {
                trustManagerArray = null;
            }
            sslContext.init(null, trustManagerArray, null);
            this.defaultFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError();
        }
    }

    private void upgradeTLS(SSLSocket ssl) {
        if (protocols != null) {
            ssl.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1"});
            LogTools.printDebug(String.format("getEnabledProtocols: %s", Arrays.toString(ssl.getEnabledProtocols())));
        }
        if (Build.VERSION.SDK_INT < 21 && cipherSuites != null) {
            ssl.setEnabledCipherSuites(cipherSuites);
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return cipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return cipherSuites;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket ssl = this.defaultFactory.createSocket(s, host, port, autoClose);
        if (ssl instanceof SSLSocket) {
            this.upgradeTLS((SSLSocket)ssl);
        }
        return ssl;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket ssl = this.defaultFactory.createSocket(host, port);
        if (ssl instanceof SSLSocket) {
            this.upgradeTLS((SSLSocket)ssl);
        }
        return ssl;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket ssl = this.defaultFactory.createSocket(host, port, localHost, localPort);
        if (ssl instanceof SSLSocket) {
            this.upgradeTLS((SSLSocket)ssl);
        }
        return ssl;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket ssl = this.defaultFactory.createSocket(host, port);
        if (ssl instanceof SSLSocket) {
            this.upgradeTLS((SSLSocket)ssl);
        }
        return ssl;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket ssl = this.defaultFactory.createSocket(address, port, localAddress, localPort);
        if (ssl instanceof SSLSocket) {
            this.upgradeTLS((SSLSocket)ssl);
        }
        return ssl;
    }

    static {
        try {
            SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
            if (socket != null) {
                LinkedList<String> protocols = new LinkedList<String>();
                for (String protocol : socket.getSupportedProtocols()) {
                    if (protocol.toUpperCase().contains("SSL")) continue;
                    protocols.add(protocol);
                }
                GoodSSLSocketFactory.protocols = protocols.toArray(new String[protocols.size()]);
                if (Build.VERSION.SDK_INT < 21) {
                    List<String> allowedCiphers = Arrays.asList("TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECHDE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
                    List<String> availableCiphers = Arrays.asList(socket.getSupportedCipherSuites());
                    HashSet<String> preferredCiphers = new HashSet<String>(allowedCiphers);
                    preferredCiphers.retainAll(availableCiphers);
                    HashSet<String> enabledCiphers = preferredCiphers;
                    enabledCiphers.addAll(new HashSet<String>(Arrays.asList(socket.getEnabledCipherSuites())));
                    cipherSuites = enabledCiphers.toArray(new String[enabledCiphers.size()]);
                }
            }
            LogTools.printDebug(String.format("protocols: %s, cipherSuites: %s", Arrays.toString(protocols), Arrays.toString(cipherSuites)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

