/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.network;

import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;

public class UDPMgr {
    private static LinkedBlockingQueue<Integer> portQueue = new LinkedBlockingQueue();
    private static int currentPortCounter = 0;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryByUDP(String ip, int port, String sendData) {
        String response = null;
        int bindPort = UDPMgr.getEnablePort();
        try {
            DatagramSocket client = new DatagramSocket(bindPort);
            DatagramPacket data = new DatagramPacket(sendData.getBytes(), sendData.getBytes().length, InetAddress.getByName(ip), port);
            byte[] receiveBuffer = new byte[10240];
            DatagramPacket receiveData = new DatagramPacket(receiveBuffer, receiveBuffer.length);
            client.setSoTimeout(GlobalTools.UDP_TIMEOUT);
            client.send(data);
            boolean endReceiving = false;
            int timeoutTimes = 0;
            while (!endReceiving) {
                try {
                    if (timeoutTimes > 0) {
                        client.send(data);
                    }
                    client.receive(receiveData);
                    if (receiveData.getLength() <= 0) continue;
                    int len = receiveData.getLength();
                    endReceiving = true;
                    response = new String(receiveBuffer, 0, len);
                }
                catch (SocketTimeoutException e) {
                    LogTools.printError("queryByUDP\uff1a" + e.getMessage());
                    if (++timeoutTimes < GlobalTools.UDP_RETRY_TIME) continue;
                    endReceiving = true;
                }
            }
            client.close();
        }
        catch (BindException e) {
            LogTools.printError("queryByUDP\uff1a" + e.getMessage());
        }
        catch (SocketException e) {
            LogTools.printError("queryByUDP\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            LogTools.printError("queryByUDP\uff1a" + e.getMessage());
        }
        finally {
            UDPMgr.returnPort(bindPort);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int getEnablePort() {
        int result = 0;
        Object object = lock;
        synchronized (object) {
            result = portQueue.size() == 0 ? (currentPortCounter == 0 ? (currentPortCounter = GlobalTools.UDP_LOCAL_PORT) : ++currentPortCounter) : portQueue.poll();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void returnPort(Integer port) {
        Object object = lock;
        synchronized (object) {
            if (portQueue.contains(port)) {
                return;
            }
            portQueue.add(port);
        }
    }
}

