/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.flow;

import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.cache.ServerIPMgr;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.DelayTB;
import com.yy.gslbsdk.db.HijackTB;
import com.yy.gslbsdk.db.ProbeTB;
import com.yy.gslbsdk.device.DeviceMgr;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.flow.DnsResolveFlow;
import com.yy.gslbsdk.network.HTTPMgr;
import com.yy.gslbsdk.protocol.CmdInfo;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.HijackInfo;
import com.yy.gslbsdk.protocol.ReportInfo;
import com.yy.gslbsdk.protocol.ReportProtocolMgr;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.protocol.StatsInfo;
import com.yy.gslbsdk.thread.TimerMgr;
import com.yy.gslbsdk.thread.TimerTaskInfo;
import com.yy.gslbsdk.util.FormatTools;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class QualityDetectFlow {
    private static QualityDetectFlow mQualityDetectFlow = null;

    public static QualityDetectFlow getInstance() {
        if (mQualityDetectFlow == null) {
            mQualityDetectFlow = new QualityDetectFlow();
        }
        return mQualityDetectFlow;
    }

    private ReportInfo collectStats0Data(NetStatusInfo network) {
        int countFailedDns = DataCacheMgr.INSTANCE.getFailedDnsCount();
        int countLocalDns = DataCacheMgr.INSTANCE.getLocalDnsCount();
        List<Long> listDnsCost = DataCacheMgr.INSTANCE.getListDnsCost();
        if (countFailedDns == 0 && countLocalDns == 0 && listDnsCost.size() == 0) {
            return null;
        }
        ReportInfo report = new ReportInfo();
        report.setHost(GlobalTools.HTTPDNS_REPORT_HOST);
        report.setNetInfo(network);
        report.setView("");
        report.setFc(countFailedDns);
        report.setLc(countLocalDns);
        StatsInfo statsInfo = new StatsInfo();
        statsInfo.setSip("0.0.0.0");
        for (long cost : listDnsCost) {
            int index = -1;
            if (cost >= 0L && cost <= 20L) {
                index = 0;
            } else if (cost > 20L && cost <= 100L) {
                index = 1;
            } else if (cost > 100L && cost <= 200L) {
                index = 2;
            } else if (cost > 200L && cost <= 500L) {
                index = 3;
            } else if (cost > 500L) {
                index = 4;
            }
            if (index == -1) continue;
            long[] lArray = statsInfo.getIts().get(index);
            lArray[1] = lArray[1] + 1L;
            long[] lArray2 = statsInfo.getIts().get(index);
            lArray2[2] = lArray2[2] + cost;
        }
        for (int i = 0; i < statsInfo.getIts().size(); ++i) {
            long[] arr = statsInfo.getIts().get(i);
            if (arr[1] == 0L) continue;
            arr[0] = arr[2] / arr[1];
        }
        report.setStats0(statsInfo);
        return report;
    }

    private HashMap<String, ReportInfo> collectMin1Data(List<DelayTB> min1List, NetStatusInfo network) {
        HashMap<String, ReportInfo> min1Data = new HashMap<String, ReportInfo>();
        for (DelayTB delayInfo : min1List) {
            ReportInfo reportInfo;
            String host = delayInfo.getHost();
            if (!min1Data.containsKey(host)) {
                ReportInfo report = new ReportInfo();
                report.setHost(host);
                report.setNetInfo(network);
                DnsInfo cacheDnsInfo = new DnsInfo();
                int code = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network.getNetStatusID(), host, cacheDnsInfo);
                if (code == 0) {
                    report.setView(cacheDnsInfo.getView());
                } else {
                    report.setView("");
                }
                min1Data.put(host, report);
            }
            if (!(reportInfo = min1Data.get(host)).getStats1().containsKey(delayInfo.getIp())) {
                StatsInfo stats = new StatsInfo();
                stats.setSip(delayInfo.getIp());
                reportInfo.getStats1().put(stats.getSip(), stats);
            }
            StatsInfo statsInfo = reportInfo.getStats1().get(delayInfo.getIp());
            long delay = delayInfo.getDelay();
            int index = -1;
            if (delay >= 500L && delay <= 600L) {
                index = 0;
            } else if (delay > 600L && delay <= 800L) {
                index = 1;
            } else if (delay > 800L && delay <= 1000L) {
                index = 2;
            } else if (delay > 1000L && delay <= 2000L) {
                index = 3;
            } else if (delay > 2000L) {
                index = 4;
            }
            if (index == -1) continue;
            long[] lArray = statsInfo.getIts().get(index);
            lArray[1] = lArray[1] + 1L;
            long[] lArray2 = statsInfo.getIts().get(index);
            lArray2[2] = lArray2[2] + delay;
        }
        return min1Data;
    }

    private HashMap<String, ReportInfo> collectMin15Data(List<DelayTB> min15List, NetStatusInfo network) {
        HashMap<String, ReportInfo> min15Data = new HashMap<String, ReportInfo>();
        for (DelayTB delayInfo : min15List) {
            ReportInfo reportInfo;
            String host = delayInfo.getHost();
            if (!min15Data.containsKey(host)) {
                ReportInfo report = new ReportInfo();
                report.setHost(host);
                report.setNetInfo(network);
                DnsInfo cacheDnsInfo = new DnsInfo();
                int code = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network.getNetStatusID(), host, cacheDnsInfo);
                if (code == 0) {
                    report.setView(cacheDnsInfo.getView());
                } else {
                    report.setView("");
                }
                min15Data.put(host, report);
            }
            if (!(reportInfo = min15Data.get(host)).getStats15().containsKey(delayInfo.getIp())) {
                StatsInfo stats = new StatsInfo();
                stats.setSip(delayInfo.getIp());
                reportInfo.getStats15().put(stats.getSip(), stats);
            }
            StatsInfo statsInfo = reportInfo.getStats15().get(delayInfo.getIp());
            long delay = delayInfo.getDelay();
            int index = -1;
            if (delay >= 0L && delay <= 50L) {
                index = 0;
            } else if (delay > 50L && delay <= 100L) {
                index = 1;
            } else if (delay > 100L && delay <= 200L) {
                index = 2;
            } else if (delay > 200L && delay <= 300L) {
                index = 3;
            } else if (delay > 300L && delay < 500L) {
                index = 4;
            }
            if (index == -1) continue;
            long[] lArray = statsInfo.getIts().get(index);
            lArray[1] = lArray[1] + 1L;
            long[] lArray2 = statsInfo.getIts().get(index);
            lArray2[2] = lArray2[2] + delay;
        }
        return min15Data;
    }

    private HashMap<String, ReportInfo> collectHijackData(List<HijackTB> hijackList, NetStatusInfo network) {
        HashMap<String, ReportInfo> hijackData = new HashMap<String, ReportInfo>();
        String last_hijack = DataCacheMgr.INSTANCE.getReportDate(GlobalTools.APP_CONTEXT);
        SimpleDateFormat full_date_format2 = new SimpleDateFormat("yyyy-MM-dd");
        String today = full_date_format2.format(new Date());
        if (!(today.equals(last_hijack) || network.getNetType() == 1 || network.getNetType() == 0 || network.getNetType() != 2 && FormatTools.daysOfTwo(last_hijack, today) < 2)) {
            for (HijackTB hijackTB : hijackList) {
                String host = hijackTB.getHost();
                if (!hijackData.containsKey(host)) {
                    ReportInfo report = new ReportInfo();
                    report.setHost(host);
                    report.setNetInfo(network);
                    DnsInfo cacheDnsInfo = new DnsInfo();
                    int code = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network.getNetStatusID(), host, cacheDnsInfo);
                    if (code == 0) {
                        report.setView(cacheDnsInfo.getView());
                    } else {
                        report.setView("");
                    }
                    hijackData.put(host, report);
                }
                HijackInfo hijackInfo = new HijackInfo();
                hijackInfo.setUip(hijackTB.getUip());
                hijackInfo.setDnsip(hijackTB.getDnsip());
                hijackInfo.setHip(hijackTB.getHip());
                hijackData.get(host).getHijack().add(hijackInfo);
            }
        }
        return hijackData;
    }

    private void calAvgDelay(HashMap<String, ReportInfo> report) {
        if (report != null) {
            for (ReportInfo loop : report.values()) {
                HashMap<String, StatsInfo> stats15;
                HashMap<String, StatsInfo> stats1 = loop.getStats1();
                if (stats1 != null) {
                    for (StatsInfo loop1 : stats1.values()) {
                        for (int i = 0; i < loop1.getIts().size(); ++i) {
                            if (loop1.getIts().get(i)[1] == 0L) continue;
                            loop1.getIts().get((int)i)[0] = loop1.getIts().get(i)[2] / loop1.getIts().get(i)[1];
                        }
                    }
                }
                if ((stats15 = loop.getStats15()) == null) continue;
                for (StatsInfo loop1 : stats15.values()) {
                    for (int i = 0; i < loop1.getIts().size(); ++i) {
                        if (loop1.getIts().get(i)[1] == 0L) continue;
                        loop1.getIts().get((int)i)[0] = loop1.getIts().get(i)[2] / loop1.getIts().get(i)[1];
                    }
                }
            }
        }
    }

    private void handleStatsReport() {
        if (GlobalTools.IS_BACKGOUND_MODEL) {
            return;
        }
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
        NetStatusInfo network = DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT);
        GlobalTools.STATS_REPORT_TIME += 3;
        ReportInfo dataStats0 = this.collectStats0Data(network);
        if (dataStats0 != null) {
            String strReportStats0 = ReportProtocolMgr.reportProtocol(dataStats0);
            int cntRetry = 2;
            for (int i = 0; i < cntRetry; ++i) {
                String[] resStats0 = HTTPMgr.postHttp(ServerIPMgr.reportUrl, strReportStats0);
                if (resStats0 == null || !resStats0[0].equals("200")) continue;
                DataCacheMgr.INSTANCE.resetFailedDnsCount();
                DataCacheMgr.INSTANCE.resetLocalDnsCount();
                DataCacheMgr.INSTANCE.resetListDnsCost();
                LogTools.printDebug("Report stats0 success: " + strReportStats0);
                break;
            }
        }
        ArrayList<DelayTB> min1List = DataCacheMgr.INSTANCE.getAllDelayUpper();
        HashMap<String, ReportInfo> min1Data = this.collectMin1Data(min1List, network);
        this.calAvgDelay(min1Data);
        for (ReportInfo min1 : min1Data.values()) {
            String reportStr = ReportProtocolMgr.reportProtocol(min1);
            String[] res = HTTPMgr.postHttp(ServerIPMgr.reportUrl, reportStr);
            if (res == null || !res[0].equals("200")) continue;
            DataCacheMgr.INSTANCE.deleteDelayByHostFromUpper(min1.getHost());
            LogTools.printDebug("Report min1 success: " + (String)reportStr);
        }
        if (GlobalTools.STATS_REPORT_TIME >= 15) {
            GlobalTools.STATS_REPORT_TIME = 0;
            ArrayList<DelayTB> min15List = DataCacheMgr.INSTANCE.getAllDelayLower();
            HashMap<String, ReportInfo> min15Data = this.collectMin15Data(min15List, network);
            this.calAvgDelay(min15Data);
            for (ReportInfo min15 : min15Data.values()) {
                String reportStr;
                String[] res;
                if (this.canReport(min15.getHost())) {
                    int tt = DataCacheMgr.INSTANCE.getInvokeApiNum(min15.getHost());
                    int ct = DataCacheMgr.INSTANCE.getHitCacheNum(min15.getHost());
                    min15.setTt(tt);
                    min15.setCt(ct);
                }
                if ((res = HTTPMgr.postHttp(ServerIPMgr.reportUrl, reportStr = ReportProtocolMgr.reportProtocol(min15))) == null || !res[0].equals("200")) continue;
                DataCacheMgr.INSTANCE.deleteDelayByHostFromLower(min15.getHost());
                DataCacheMgr.INSTANCE.clearInvokeApiNum(min15.getHost());
                DataCacheMgr.INSTANCE.clearHitCacheNum(min15.getHost());
                LogTools.printDebug("Report min15 success: " + reportStr);
            }
            List<HijackTB> hijackList = dbMgr.getAllHijack();
            HashMap<String, ReportInfo> hijackData = this.collectHijackData(hijackList, network);
            for (ReportInfo hk : hijackData.values()) {
                String reportStr = ReportProtocolMgr.reportProtocol(hk);
                String[] res = HTTPMgr.postHttp(ServerIPMgr.reportUrl, reportStr);
                if (res == null || !res[0].equals("200")) continue;
                dbMgr.delHijackByHost(hk.getHost());
                SimpleDateFormat full_date_format2 = new SimpleDateFormat("yyyy-MM-dd");
                DataCacheMgr.INSTANCE.setReportDate(GlobalTools.APP_CONTEXT, full_date_format2.format(new Date()));
                LogTools.printDebug("Report hijack success: " + reportStr);
            }
        }
    }

    private void handleQualityMonitor() {
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
        ArrayList<ProbeTB> probeList = DataCacheMgr.INSTANCE.getALlProbe();
        for (ProbeTB probeInfo : probeList) {
            DnsInfo cacheDnsInfo;
            String host = probeInfo.getHost();
            if (!this.canProbe(host, cacheDnsInfo = new DnsInfo())) continue;
            boolean canReport = this.canReport(host);
            LinkedList<String> ips = cacheDnsInfo.getIps();
            for (String ip : ips) {
                HashMap<String, String> params;
                String url = probeInfo.getUrl().replace(host, ip);
                long beingTime = System.currentTimeMillis();
                if (probeInfo.getMethod() == 1) {
                    params = new HashMap<String, String>();
                    params.put("host", host);
                    HTTPMgr.headHttp(url, params);
                } else {
                    params = new HashMap();
                    params.put("host", host);
                    HTTPMgr.getHttp(url, params);
                }
                long endTime = System.currentTimeMillis();
                if (!canReport) continue;
                this.addReportData(host, ip, endTime - beingTime);
                LogTools.printDebug("Probe success: " + host + " " + ip + " " + (endTime - beingTime) + "ms");
            }
        }
    }

    private void handleHijackMonitor() {
        NetStatusInfo netstatus = DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT);
        ConcurrentHashMap<String, DnsInfo> cacheLocalDNS = DataCacheMgr.INSTANCE.getAllLocalDNSFromCache();
        LinkedList<String> hostList = new LinkedList<String>();
        int index = 0;
        for (String host : cacheLocalDNS.keySet()) {
            hostList.add(host);
            if (hostList.size() == 5 || index == cacheLocalDNS.size() - 1) {
                ResInfo realTimeResInfo = new ResInfo();
                DnsResolveFlow.getInstance().handleHttpDNSIgnoreCache(netstatus, hostList.toArray(new String[0]), realTimeResInfo, true);
                if (realTimeResInfo.getStatus() == 0) {
                    for (String tmpHost : hostList) {
                        DnsInfo dnsInfo = cacheLocalDNS.get(tmpHost);
                        LinkedList<String> localIps = dnsInfo.getIps();
                        LinkedList<String> httpIps = null;
                        if (realTimeResInfo.getDns() != null && realTimeResInfo.getDns().get(tmpHost) != null) {
                            httpIps = realTimeResInfo.getDns().get(tmpHost).getIps();
                        }
                        if (localIps == null || httpIps == null) continue;
                        for (String localip : localIps) {
                            if (FormatTools.containInList(httpIps, localip)) continue;
                            this.addHijackData(tmpHost, dnsInfo.getNt(), dnsInfo.getUip(), localip);
                            LogTools.printDebug("add hijack data success: " + tmpHost + " " + dnsInfo.getNt() + " " + localip);
                        }
                    }
                }
                hostList.clear();
            }
            ++index;
        }
    }

    public synchronized void updateDectorList(String host, int protocol, int method, String url) {
        if (GlobalTools.APP_CONTEXT != null) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
            ProbeTB probe = new ProbeTB();
            probe.setHost(host);
            probe.setProtocol(protocol);
            probe.setMethod(method);
            probe.setUrl(url);
            DataCacheMgr.INSTANCE.addProbe(probe);
        }
    }

    public void addReportData(String host, String ip, long delay) {
        if (GlobalTools.APP_CONTEXT != null) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
            DelayTB delayInfo = new DelayTB();
            delayInfo.setHost(host);
            delayInfo.setIp(ip);
            delayInfo.setDelay(delay);
            DataCacheMgr.INSTANCE.addDelay(delayInfo);
        }
    }

    public synchronized void addHijackData(String host, int nt, String uip, String hip) {
        if (GlobalTools.APP_CONTEXT != null) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
            HijackTB hijack = new HijackTB();
            hijack.setHost(host);
            hijack.setNt(nt);
            hijack.setUip(uip);
            hijack.setHip(hip);
            hijack.setDnsip(ServerIPMgr.curLocalDNSIp);
            dbMgr.delHijack(hijack);
            dbMgr.addHijack(hijack);
        }
    }

    public boolean canReport(String host) {
        if (GlobalTools.APP_CONTEXT != null) {
            NetStatusInfo netstatus = DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT);
            DnsInfo cacheDnsInfo = new DnsInfo();
            int code = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, netstatus.getNetStatusID(), host, cacheDnsInfo);
            if (code == 0) {
                CmdInfo cmd = cacheDnsInfo.getCmd();
                return cmd != null && cmd.isRe();
            }
            return false;
        }
        return false;
    }

    public boolean canProbe(String host, DnsInfo cacheDnsInfo) {
        CmdInfo cmd;
        NetStatusInfo netstatus;
        int code;
        boolean result = false;
        if (GlobalTools.APP_CONTEXT != null && cacheDnsInfo != null && (code = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, (netstatus = DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT)).getNetStatusID(), host, cacheDnsInfo)) == 0 && (cmd = cacheDnsInfo.getCmd()) != null && cmd.isPe() && System.currentTimeMillis() > cacheDnsInfo.getProbeTime()) {
            result = true;
        }
        return result;
    }

    public synchronized int beginQualityMonitor() {
        if (GlobalTools.APP_CONTEXT != null) {
            TimerTaskInfo newWorker = new TimerTaskInfo();
            newWorker.setTaskName(GlobalTools.QUALITY_MONITOR_NAME);
            newWorker.setWorker(new TimerTask(){

                @Override
                public void run() {
                    QualityDetectFlow.this.handleQualityMonitor();
                }
            });
            TimerMgr.getInstance().addWorker(newWorker, 0L, GlobalTools.QUALITY_MONITOR_PERIOD);
            LogTools.printDebug("beginQualityMonitor...");
            return 0;
        }
        return 5;
    }

    public synchronized int stopAllMonitor() {
        TimerMgr.getInstance().stopAllWorker();
        return 0;
    }

    public synchronized int beginHijackMonitor() {
        if (GlobalTools.APP_CONTEXT != null) {
            TimerTaskInfo newWorker = new TimerTaskInfo();
            newWorker.setTaskName(GlobalTools.HIJACK_MONITOR_NAME);
            newWorker.setWorker(new TimerTask(){

                @Override
                public void run() {
                    QualityDetectFlow.this.handleHijackMonitor();
                }
            });
            TimerMgr.getInstance().addWorker(newWorker, 0L, GlobalTools.HIJACK_MONITOR_PERIOD);
            LogTools.printDebug("beginHijackMonitor...");
            return 0;
        }
        return 5;
    }

    public synchronized int beginStatsReport() {
        if (GlobalTools.APP_CONTEXT != null) {
            TimerTaskInfo newWorker = new TimerTaskInfo();
            newWorker.setTaskName(GlobalTools.STATS_REPORT_NAME);
            newWorker.setWorker(new TimerTask(){

                @Override
                public void run() {
                    QualityDetectFlow.this.handleStatsReport();
                }
            });
            TimerMgr.getInstance().addWorker(newWorker, 0L, GlobalTools.STATS_REPORT_PERIOD);
            LogTools.printDebug("beginStatsReport...");
            return 0;
        }
        return 5;
    }
}

