/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.control;

import java.util.ArrayList;
import java.util.List;

public class TtlController {
    private static TtlController sInstance = null;
    public static final int MAX_QUEUE_SIZE = 15;
    public static final int ACTIVE_THRESHOLD = 5;
    public static final int ENABLE_EXPIRED_THRESHOLD = 7;
    public static final int[] TTL_INTERVAL = new int[]{1, 6, 10, 16, 32, 64, 80, 92, 104, 114, 120};
    private int mTtlIntervalCount = 0;
    private int mTtlFailedCount = 0;
    List<Boolean> mList = new ArrayList<Boolean>();

    public static synchronized TtlController getInstance() {
        if (sInstance == null) {
            sInstance = new TtlController();
        }
        return sInstance;
    }

    public int getTtlIntervalLevel() {
        int countFailed = this.getFailedCount();
        if (countFailed <= 5) {
            return 0;
        }
        return countFailed - 5;
    }

    public int getTtlIntervalValue() {
        return TTL_INTERVAL[this.getTtlIntervalLevel()];
    }

    public boolean addTtlIntervalCount() {
        if (++this.mTtlIntervalCount < this.getTtlIntervalValue()) {
            return false;
        }
        this.resetTtlIntervalCount();
        return true;
    }

    public int getTtlIntervalCount() {
        return this.mTtlIntervalCount;
    }

    public void resetTtlIntervalCount() {
        this.mTtlIntervalCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStatus(boolean result) {
        List<Boolean> list = this.mList;
        synchronized (list) {
            this.mList.add(result);
            if (this.mList.size() < 15) {
                return false;
            }
            while (this.mList.size() > 15) {
                this.mList.remove(0);
            }
        }
        this.calcFailedCount();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcFailedCount() {
        int count = 0;
        List cloneList = null;
        List<Boolean> list = this.mList;
        synchronized (list) {
            cloneList = (List)((ArrayList)this.mList).clone();
        }
        for (Boolean b : cloneList) {
            if (b == null || b.booleanValue()) continue;
            ++count;
        }
        this.mTtlFailedCount = Math.min(count, 15);
    }

    public int getFailedCount() {
        return this.mTtlFailedCount;
    }

    public boolean isActive() {
        return this.getFailedCount() > 5;
    }

    public boolean enableExpired() {
        return this.getFailedCount() > 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List cloneList = null;
        List<Boolean> list = this.mList;
        synchronized (list) {
            cloneList = (List)((ArrayList)this.mList).clone();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("( ");
        for (int i = 0; i < cloneList.size(); ++i) {
            sb.append(i).append("-").append((Boolean)cloneList.get(i) != false ? "t" : "f").append(" ");
        }
        sb.append(")");
        return String.format("[TtlController failed: %d, level: %d, value: %d, count: %d, isActive: %b, enableExpired: %b, queue: %s]", this.getFailedCount(), this.getTtlIntervalLevel(), this.getTtlIntervalValue(), this.getTtlIntervalCount(), this.isActive(), this.enableExpired(), sb.toString());
    }
}

