/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.cache;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.DelayTB;
import com.yy.gslbsdk.db.ProbeTB;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.device.DeviceMgr;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public enum DataCacheMgr {
    INSTANCE;

    private ConcurrentHashMap<String, DnsInfo> mLocalDNSCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResultTB> mHttpDNSCache = new ConcurrentHashMap();
    private ArrayList<ProbeTB> mProbeCache = new ArrayList();
    private HashMap<String, ArrayList<DelayTB>> mDelayCacheUpper = new HashMap();
    private HashMap<String, ArrayList<DelayTB>> mDelayCacheLower = new HashMap();
    private HashMap<String, Integer> mInvokeApiNum = new HashMap();
    private HashMap<String, Integer> mHitCacheNum = new HashMap();
    private NetStatusInfo mCacheNetStatusInfo = null;
    private String mCacheIdentity = null;
    private int mCountFailedDns = 0;
    private int mCountLocalDns = 0;
    private List<Long> mListDnsCost = new LinkedList<Long>();

    public synchronized void addInvokeApiNum(String host) {
        int newVal = 0;
        if (this.mInvokeApiNum.containsKey(host)) {
            newVal = this.mInvokeApiNum.get(host);
        }
        this.mInvokeApiNum.put(host, ++newVal);
    }

    public synchronized int getInvokeApiNum(String host) {
        int val = 0;
        if (this.mInvokeApiNum.containsKey(host)) {
            val = this.mInvokeApiNum.get(host);
        }
        return val;
    }

    public synchronized void clearInvokeApiNum(String host) {
        this.mInvokeApiNum.remove(host);
    }

    public synchronized void clearAllInvokeApiNum() {
        this.mInvokeApiNum.clear();
    }

    public synchronized void addHitCacheNum(String host) {
        int newVal = 0;
        if (this.mHitCacheNum.containsKey(host)) {
            newVal = this.mHitCacheNum.get(host);
        }
        this.mHitCacheNum.put(host, ++newVal);
    }

    public synchronized int getHitCacheNum(String host) {
        int val = 0;
        if (this.mHitCacheNum.containsKey(host)) {
            val = this.mHitCacheNum.get(host);
        }
        return val;
    }

    public synchronized void clearHitCacheNum(String host) {
        this.mHitCacheNum.remove(host);
    }

    public synchronized void clearAllHitCacheNum() {
        this.mHitCacheNum.clear();
    }

    public void putLocalDNSIntoCache(DnsInfo dnsInfo) {
        if (dnsInfo != null) {
            this.mLocalDNSCache.put(dnsInfo.getHost(), dnsInfo);
        }
    }

    public int getLocalDNSFromCache(String host, DnsInfo dnsInfo) {
        if (dnsInfo != null) {
            if (this.mLocalDNSCache.containsKey(host)) {
                DnsInfo info = this.mLocalDNSCache.get(host);
                if (info.getEndTime() > System.currentTimeMillis()) {
                    dnsInfo.updateDnsInfo(info);
                    return 0;
                }
                return 2;
            }
            return 2;
        }
        return 5;
    }

    public int putHttpDNSIntoMemCache(ResultTB resInfo) {
        if (resInfo != null) {
            try {
                this.mHttpDNSCache.put(resInfo.getHost(), resInfo);
            }
            catch (Exception e) {
                GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
                LogTools.printWarning(e);
            }
        }
        return 0;
    }

    public ResultTB getHttpDNSFromMemCache(String network, String host) {
        try {
            ResultTB rs = this.mHttpDNSCache.get(host);
            if (rs != null && network.equals(rs.getNetwork())) {
                return rs;
            }
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
        return null;
    }

    public void deleteHttpDNSFromMemCache(String host) {
        try {
            this.mHttpDNSCache.remove(host);
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
        }
    }

    public ConcurrentHashMap<String, DnsInfo> getAllLocalDNSFromCache() {
        return this.mLocalDNSCache;
    }

    public int putHttpDNSIntoCache(Context context, ResInfo resInfo) {
        if (resInfo.getNetInfo() != null) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
            String netId = resInfo.getNetInfo().getNetStatusID();
            if (resInfo.getDns() != null) {
                for (DnsInfo dnsInfo : resInfo.getDns().values()) {
                    ResultTB addItem = new ResultTB();
                    addItem.setNetwork(netId);
                    addItem.setHost(dnsInfo.getHost());
                    addItem.setTtl(dnsInfo.getTtl());
                    addItem.setEndTime(dnsInfo.getEndTime());
                    addItem.setCmd(dnsInfo.getCmdStr());
                    addItem.setUpdateTime(System.currentTimeMillis());
                    addItem.setView(dnsInfo.getView());
                    addItem.setUip(dnsInfo.getUip());
                    if (dnsInfo.getIPStr() != null) {
                        addItem.setIp(dnsInfo.getIPStr());
                        dbMgr.addOrUpdate(addItem, true);
                    }
                    this.putHttpDNSIntoMemCache(addItem);
                }
                return 0;
            }
            return 5;
        }
        return 5;
    }

    public int getHttpDNSFromCache(Context context, String network, String host, DnsInfo dnsInfo) {
        if (dnsInfo != null) {
            DBAccessMgr dbMgr;
            List<ResultTB> result;
            ResultTB item = this.getHttpDNSFromMemCache(network, host);
            if (item == null && (result = (dbMgr = DBAccessMgr.getInstance(context)).getResultByNetworkHost(network, host)) != null && !result.isEmpty()) {
                item = result.get(0);
            }
            if (item != null) {
                dnsInfo.setHost(item.getHost());
                dnsInfo.setTtl(item.getTtl());
                dnsInfo.setIPStr(item.getIp());
                dnsInfo.setCmdStr(item.getCmd());
                dnsInfo.setView(item.getView());
                dnsInfo.setUip(item.getUip());
                dnsInfo.setEndTime(item.getEndTime());
                dnsInfo.setProbeTime(item.getUpdateTime() + (long)((int)((float)item.getTtl() * GlobalTools.TTL_PROBE_FACTOR * 1000.0f)));
                return 0;
            }
            return 2;
        }
        return 5;
    }

    public void setReportDate(Context ctx, String date) {
        SharedPreferences reportConfig = ctx.getSharedPreferences("reportConfig", 0);
        reportConfig.edit().putString("last_hijack", date).commit();
    }

    public String getReportDate(Context ctx) {
        SharedPreferences reportConfig = ctx.getSharedPreferences("reportConfig", 0);
        SimpleDateFormat full_date_format2 = new SimpleDateFormat("yyyy-MM-dd");
        return reportConfig.getString("last_hijack", full_date_format2.format(new Date(System.currentTimeMillis() - GlobalTools.ONE_DAY_MILSEC)));
    }

    public synchronized String getIdentity(Context ctx) {
        if (this.mCacheIdentity != null) {
            return this.mCacheIdentity;
        }
        SharedPreferences preference = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        this.mCacheIdentity = preference.getString("gslb_identity", "");
        if (this.mCacheIdentity.length() == 0) {
            this.mCacheIdentity = UUID.randomUUID().toString();
            preference.edit().putString("gslb_identity", this.mCacheIdentity).commit();
        }
        return this.mCacheIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachedNetStateInfo(NetStatusInfo netStateInfo) {
        DataCacheMgr dataCacheMgr = this;
        synchronized (dataCacheMgr) {
            this.mCacheNetStatusInfo = netStateInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetStatusInfo getCachedNetStatusInfo() {
        if (this.mCacheNetStatusInfo == null) {
            NetStatusInfo netInfo = DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT);
            DataCacheMgr dataCacheMgr = this;
            synchronized (dataCacheMgr) {
                this.mCacheNetStatusInfo = netInfo;
            }
        }
        return this.mCacheNetStatusInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProbe(ProbeTB probe) {
        if (probe != null) {
            ArrayList<ProbeTB> arrayList = this.mProbeCache;
            synchronized (arrayList) {
                if (!this.mProbeCache.contains(probe)) {
                    this.mProbeCache.add(probe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProbeTB> getALlProbe() {
        ArrayList<ProbeTB> arrayList = this.mProbeCache;
        synchronized (arrayList) {
            return (ArrayList)this.mProbeCache.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelay(DelayTB delay) {
        if (delay != null) {
            if (delay.getDelay() >= 500L) {
                HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheUpper;
                synchronized (hashMap) {
                    ArrayList<DelayTB> arr = this.mDelayCacheUpper.get(delay.getHost());
                    if (arr == null) {
                        arr = new ArrayList();
                        this.mDelayCacheUpper.put(delay.getHost(), arr);
                    }
                    arr.add(delay);
                }
            }
            HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheLower;
            synchronized (hashMap) {
                ArrayList<DelayTB> arr = this.mDelayCacheLower.get(delay.getHost());
                if (arr == null) {
                    arr = new ArrayList();
                    this.mDelayCacheLower.put(delay.getHost(), arr);
                }
                arr.add(delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DelayTB> getAllDelayUpper() {
        ArrayList<DelayTB> all = new ArrayList<DelayTB>();
        HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheUpper;
        synchronized (hashMap) {
            for (Map.Entry<String, ArrayList<DelayTB>> entry : this.mDelayCacheUpper.entrySet()) {
                ArrayList<DelayTB> val = entry.getValue();
                all.addAll(val);
            }
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DelayTB> getAllDelayLower() {
        ArrayList<DelayTB> all = new ArrayList<DelayTB>();
        HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheLower;
        synchronized (hashMap) {
            for (Map.Entry<String, ArrayList<DelayTB>> entry : this.mDelayCacheLower.entrySet()) {
                ArrayList<DelayTB> val = entry.getValue();
                all.addAll(val);
            }
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllDelay() {
        HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheLower;
        synchronized (hashMap) {
            this.mDelayCacheLower.clear();
        }
        hashMap = this.mDelayCacheUpper;
        synchronized (hashMap) {
            this.mDelayCacheUpper.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDelayByHostFromUpper(String host) {
        if (host != null) {
            HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheUpper;
            synchronized (hashMap) {
                this.mDelayCacheUpper.remove(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDelayByHostFromLower(String host) {
        if (host != null) {
            HashMap<String, ArrayList<DelayTB>> hashMap = this.mDelayCacheLower;
            synchronized (hashMap) {
                this.mDelayCacheLower.remove(host);
            }
        }
    }

    public void addFailedDnsCount() {
        ++this.mCountFailedDns;
    }

    public int getFailedDnsCount() {
        return this.mCountFailedDns;
    }

    public void resetFailedDnsCount() {
        this.mCountFailedDns = 0;
    }

    public void addLocalDnsCount() {
        ++this.mCountLocalDns;
    }

    public int getLocalDnsCount() {
        return this.mCountLocalDns;
    }

    public void resetLocalDnsCount() {
        this.mCountLocalDns = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDnsCost(long t) {
        if (this.mListDnsCost == null) {
            this.mListDnsCost = new LinkedList<Long>();
        }
        List<Long> list = this.mListDnsCost;
        synchronized (list) {
            this.mListDnsCost.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getListDnsCost() {
        if (this.mListDnsCost == null) {
            this.mListDnsCost = new LinkedList<Long>();
        }
        List<Long> list = this.mListDnsCost;
        synchronized (list) {
            return (List)((LinkedList)this.mListDnsCost).clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetListDnsCost() {
        if (this.mListDnsCost == null) {
            this.mListDnsCost = new LinkedList<Long>();
        } else {
            List<Long> list = this.mListDnsCost;
            synchronized (list) {
                this.mListDnsCost.clear();
            }
        }
    }
}

