/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.statistic;

import android.text.TextUtils;
import com.yy.gslbsdk.statistic.StatisticInfo;
import com.yy.gslbsdk.thread.ThreadInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class StatisticMgr {
    private static StatisticMgr sInstance = null;
    private IGslbStatistic mStatistic = null;
    private ScheduledThreadPoolExecutor mExecutor = new ScheduledThreadPoolExecutor(1);
    private Map<String, StatisticInfo> mMapStatistic = new ConcurrentHashMap<String, StatisticInfo>();

    public static StatisticMgr getInstance() {
        if (sInstance == null) {
            sInstance = new StatisticMgr();
        }
        return sInstance;
    }

    public void setStatistic(IGslbStatistic statistic) {
        this.mStatistic = statistic;
    }

    public IGslbStatistic getStatistic() {
        return this.mStatistic;
    }

    public void onStatistic(Map<String, String> rsInfo) {
        if (this.mStatistic == null) {
            return;
        }
        this.mStatistic.onStatistic(rsInfo);
    }

    public void addTask(ThreadInfo task) {
        this.mExecutor.execute(task);
    }

    public void addTask(ThreadInfo task, long delay) {
        this.mExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public StatisticInfo getStatisticInfo(String requestId) {
        if (TextUtils.isEmpty((CharSequence)requestId)) {
            return null;
        }
        StatisticInfo rsInfo = this.mMapStatistic.get(requestId);
        if (rsInfo == null) {
            rsInfo = new StatisticInfo();
        }
        return rsInfo;
    }

    public boolean setStatisticInfo(String requestId, StatisticInfo rsInfo) {
        if (TextUtils.isEmpty((CharSequence)requestId)) {
            return false;
        }
        if (this.mMapStatistic.containsKey(requestId)) {
            return false;
        }
        this.mMapStatistic.put(requestId, rsInfo);
        return true;
    }

    public void removeStatisticInfo(String requestId) {
        this.mMapStatistic.remove(requestId);
    }

    public static interface IGslbStatistic {
        public void onStatistic(Map<String, String> var1);
    }
}

