/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.protocol;

import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.network.HTTPMgr;
import com.yy.gslbsdk.protocol.CmdInfo;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.HttpDnsInfo;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpDNSProtocolMgr {
    public static String udpRequestProtocolV2(String[] host, long seqId, boolean total) {
        String result = null;
        if (host != null && host.length > 0) {
            try {
                JSONObject result_json = new JSONObject();
                result_json.put("seq_id", seqId);
                result_json.put("version", (Object)"v2");
                JSONArray array = new JSONArray();
                for (String item : host) {
                    array.put((Object)item);
                }
                result_json.put("dns_name", (Object)array);
                if (total) {
                    result_json.put("res_count", -1);
                }
                result = result_json.toString();
            }
            catch (Exception e) {
                LogTools.printError("udpRequestProtocolV2: " + e.getMessage());
            }
        }
        return result;
    }

    public static String getRequestUrlProtocolV2(String[] host, String serverIP, boolean total) {
        String url = "http://" + serverIP + "/dns_query_v2?";
        for (int i = 0; i < host.length; ++i) {
            url = url + "dns=" + host[i];
            if (i == host.length - 1) continue;
            url = url + "&";
        }
        if (total) {
            url = url + "&rescount=-1";
        }
        return url;
    }

    public static String[] requestHttpDnsV2(String[] host, String serverIP, boolean total) {
        return HttpDNSProtocolMgr.requestHttpDnsV2(host, serverIP, total, false, "");
    }

    public static String[] requestHttpDnsV2(String[] host, String serverIP, boolean total, boolean https, String requestId) {
        StringBuilder sb = new StringBuilder();
        int len = host.length;
        sb.append("dns=");
        for (int i = 0; i < len; ++i) {
            sb.append(host[i]);
            if (i >= len - 1) continue;
            sb.append(',');
        }
        String dnsString = sb.toString();
        String gslbId = DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT);
        HashMap<String, String> header_param = new HashMap<String, String>();
        header_param.put("host", GlobalTools.HTTPDNS_SERVER_HOST);
        header_param.put("platform", "andr");
        header_param.put("devid", GlobalTools.APP_DEV_ID);
        header_param.put("gslbid", gslbId);
        header_param.put("appid", GlobalTools.ACCOUNT_ID);
        header_param.put("version", "1.1.19-noSSID");
        LogTools.printInfo(String.format("Post Params, dns = %s, gslbid = %s, devid = %s", dnsString, gslbId, GlobalTools.APP_DEV_ID));
        String code = GlobalTools.APP_LOCALIZE_CODE;
        if (code == null || code.trim().length() < 1) {
            code = "";
        }
        if (https) {
            String url = "https://" + serverIP + "/dns_query_v2?usercfg=" + code + "&requestId=" + requestId;
            if (total) {
                url = url + "&rescount=-1";
            }
            return HTTPMgr.postSniHttps(url, GlobalTools.HTTPDNS_SERVER_HOST, sb.toString(), header_param);
        }
        String url = "http://" + serverIP + "/dns_query_v2?usercfg=" + code + "&requestId=" + requestId;
        if (total) {
            url = url + "&rescount=-1";
        }
        return HTTPMgr.postHttp(url, sb.toString(), header_param);
    }

    public static int responseProtocolV2(String json, ResInfo resInfo) {
        try {
            if (json == null || resInfo == null) {
                resInfo.setStatus(5);
                return 5;
            }
            JSONObject result_json = new JSONObject(json);
            resInfo.setStatus(HttpDNSProtocolMgr.translateErrCode(result_json.getInt("s")));
            resInfo.setUserIp(result_json.getString("u"));
            resInfo.setUserView(result_json.getString("v"));
            LinkedHashMap<String, DnsInfo> dns = new LinkedHashMap<String, DnsInfo>();
            JSONArray dns_json = result_json.getJSONArray("dns");
            for (int i = 0; i < dns_json.length(); ++i) {
                JSONObject dns_item = dns_json.getJSONObject(i);
                DnsInfo host = new DnsInfo();
                host.setView(result_json.getString("v"));
                host.setUip(result_json.getString("u"));
                host.setHost(dns_item.getString("name"));
                int ttl = Math.max(dns_item.getInt("ttl"), GlobalTools.sMinSecondTTL);
                host.setTtl(ttl);
                LinkedList<String> ips = new LinkedList<String>();
                if (!dns_item.isNull("ips")) {
                    JSONArray ips_json = dns_item.getJSONArray("ips");
                    for (int j = 0; j < ips_json.length(); ++j) {
                        ips.add(ips_json.getString(j));
                    }
                    host.setIps(ips);
                }
                CmdInfo cmd = new CmdInfo();
                JSONObject cmd_json = dns_item.getJSONObject("cmd");
                cmd.setPe(cmd_json.getBoolean("pe"));
                cmd.setRe(cmd_json.getBoolean("re"));
                host.setCmd(cmd);
                if (resInfo.getNetInfo() != null) {
                    host.setNt(resInfo.getNetInfo().getNetType());
                }
                dns.put(host.getHost(), host);
            }
            resInfo.setDns(dns);
            JSONObject httpdns_json = result_json.getJSONObject("httpdns");
            HttpDnsInfo httpDnsInfo = new HttpDnsInfo();
            httpDnsInfo.setVer(httpdns_json.getInt("ver"));
            httpDnsInfo.setRe(httpdns_json.getBoolean("re"));
            resInfo.setHttpdns(httpDnsInfo);
            return 0;
        }
        catch (Exception e) {
            LogTools.printError("responseProtocolV2: " + e.getMessage());
            resInfo.setStatus(3);
            return 3;
        }
    }

    private static int translateErrCode(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2002: {
                return 6;
            }
            case 1002: {
                return 5;
            }
            case 4: {
                return 7;
            }
        }
        return 8;
    }
}

