/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.network;

import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.network.TlsOnlySocketFactory;
import com.yy.gslbsdk.network.TlsSniSocketFactory;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class HTTPMgr {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] doHttpURLConnection(String strUrl, String content, HashMap<String, String> headParams, String method) {
        String[] result = new String[2];
        HttpURLConnection conn = null;
        try {
            URL url = new URL(strUrl);
            conn = (HttpURLConnection)url.openConnection();
            if (conn == null) {
                String[] stringArray = null;
                return stringArray;
            }
            if (headParams != null) {
                for (String key : headParams.keySet()) {
                    conn.addRequestProperty(key, headParams.get(key));
                }
            }
            conn.setRequestMethod(method);
            conn.setConnectTimeout(GlobalTools.HTTP_TIMEOUT);
            conn.setRequestProperty("Connection", "Close");
            conn.setDoInput(true);
            if (content != null && content.length() > 0) {
                conn.setDoOutput(true);
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(content.getBytes("UTF-8"));
                outputStream.flush();
                outputStream.close();
            } else {
                conn.setDoOutput(false);
                content = "null";
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                StringBuffer sb = new StringBuffer();
                String readLine = null;
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine).append("\n");
                }
                responseReader.close();
                result[0] = String.valueOf(responseCode);
                result[1] = sb.toString();
                LogTools.printDebug(String.format("http %s url: %s, content: %s, code: %d, json: %s", method, strUrl, content, responseCode, result[1]));
                String[] stringArray = result;
                return stringArray;
            }
            result[0] = String.valueOf(4);
            result[1] = String.format("http code is %d", responseCode);
            LogTools.printInfo(String.format("http %s data failed, code = %d", method, responseCode));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s doHttpURLConnection warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
            LogTools.printWarning("doHttpURLConnection\uff1a" + e.getMessage());
            result[0] = String.valueOf(9);
            result[1] = e.getMessage();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return result;
    }

    public static String[] getHttp(String strUrl, HashMap<String, String> headParams) {
        return HTTPMgr.doHttpURLConnection(strUrl, null, headParams, "GET");
    }

    public static String[] headHttp(String url, HashMap<String, String> headParams) {
        return HTTPMgr.doHttpURLConnection(url, null, headParams, "HEAD");
    }

    public static String[] postHttp(String urlStr, String content, HashMap<String, String> headParams) {
        return HTTPMgr.doHttpURLConnection(urlStr, content, headParams, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] postHttp(String urlStr, String content) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(new String(urlStr));
            conn = (HttpURLConnection)url.openConnection();
            if (conn == null) {
                LogTools.printError("postHttp\uff1afail to url.openConnection");
                String[] stringArray = null;
                return stringArray;
            }
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(GlobalTools.HTTP_TIMEOUT);
            conn.setRequestProperty("Connection", "Close");
            if (content != null && content.length() > 0) {
                conn.setDoOutput(true);
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(content.getBytes("UTF-8"));
                outputStream.flush();
                outputStream.close();
            } else {
                conn.setDoOutput(false);
            }
            String[] result = new String[]{String.valueOf(conn.getResponseCode()), conn.getResponseMessage()};
            LogTools.printInfo("postHttp " + urlStr);
            String[] stringArray = result;
            return stringArray;
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s postHttp warning. msg: %s", LogTools.TAG, e.getMessage()));
            LogTools.printWarning(e);
            LogTools.printWarning("postHttp\uff1a" + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static String[] postSniHttps(String strUrl, String realHost, String content, HashMap<String, String> headParams) {
        return HTTPMgr.doHttpsURLConnection(strUrl, realHost, content, headParams, "POST");
    }

    public static String[] getHttps(String strUrl, String realHost, HashMap<String, String> headParams) {
        return HTTPMgr.doHttpsURLConnection(strUrl, realHost, null, headParams, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] doHttpsURLConnection(String strUrl, String realHost, String content, HashMap<String, String> headParams, String method) {
        String[] result = new String[2];
        HttpURLConnection conn = null;
        try {
            URL url = new URL(strUrl);
            conn = (HttpsURLConnection)url.openConnection();
            if (conn == null) {
                String[] stringArray = null;
                return stringArray;
            }
            ((HttpsURLConnection)conn).setSSLSocketFactory(new TlsOnlySocketFactory());
            if (headParams != null) {
                for (String key : headParams.keySet()) {
                    conn.addRequestProperty(key, headParams.get(key));
                }
            }
            conn.setRequestMethod(method);
            conn.setConnectTimeout(GlobalTools.HTTP_TIMEOUT);
            conn.setRequestProperty("Connection", "Close");
            conn.setRequestProperty("Host", realHost);
            ((HttpsURLConnection)conn).setHostnameVerifier(new TlsSniSocketFactory.HostnameVerifierEx((HttpsURLConnection)conn){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    String host = this.mConn.getRequestProperty("Host");
                    if (null == host) {
                        host = this.mConn.getURL().getHost();
                    }
                    boolean ret = HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session);
                    return ret;
                }
            });
            conn.setDoInput(true);
            if (content != null && content.length() > 0) {
                conn.setDoOutput(true);
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(content.getBytes("UTF-8"));
                outputStream.flush();
                outputStream.close();
            } else {
                conn.setDoOutput(false);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                StringBuffer sb = new StringBuffer();
                String readLine = null;
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine).append("\n");
                }
                responseReader.close();
                result[0] = String.valueOf(responseCode);
                result[1] = sb.toString();
                LogTools.printInfo(String.format("doHttpsURLConnection url: %s, content: %s", strUrl, content == null ? "" : content));
                String[] stringArray = result;
                return stringArray;
            }
            result[0] = String.valueOf(4);
            result[1] = String.format("http code is %d", responseCode);
            LogTools.printInfo(String.format("doHttpsURLConnection data failed, code = %d", responseCode));
        }
        catch (Exception e) {
            GslbEvent.INSTANCE.onMessage(String.format("%s doHttpsURLConnection warning. url: %s msg: %s", LogTools.TAG, strUrl, e.getMessage()));
            LogTools.printWarning(e);
            LogTools.printWarning("doHttpsURLConnection\uff1a" + e.getMessage());
            result[0] = String.valueOf(9);
            result[1] = e.getMessage();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    private static String inputStreamToString(InputStream is) {
        String s = "";
        try {
            String line = "";
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            while ((line = rd.readLine()) != null) {
                s = s + line;
            }
        }
        catch (IOException e) {
            LogTools.printError("inputStreamToString\uff1a" + e.getMessage());
        }
        return s;
    }

    public static String[] post(String strUrl, String content, HashMap<String, String> headParams, boolean https) {
        if (strUrl != null) {
            if (https && strUrl.startsWith("http://")) {
                strUrl = strUrl.replace("http://", "https://");
            } else if (!https && strUrl.startsWith("https://")) {
                strUrl = strUrl.replace("https://", "http://");
            }
        }
        if (https) {
            return HTTPMgr.doHttpsURLConnection(strUrl, GlobalTools.HTTPDNS_REPORT_HOST, content, headParams, "POST");
        }
        return HTTPMgr.doHttpURLConnection(strUrl, content, headParams, "POST");
    }
}

