/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.flow;

import android.os.SystemClock;
import android.text.TextUtils;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.cache.ServerIPInfo;
import com.yy.gslbsdk.cache.ServerIPMgr;
import com.yy.gslbsdk.control.TtlController;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.HostTB;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.device.DeviceMgr;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.device.NetStatusReceiver;
import com.yy.gslbsdk.flow.QualityDetectFlow;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.HttpDNSProtocolMgr;
import com.yy.gslbsdk.protocol.LocalDNSProtocolMgr;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.statistic.StatisticInfo;
import com.yy.gslbsdk.statistic.StatisticMgr;
import com.yy.gslbsdk.thread.AsynTaskMgr;
import com.yy.gslbsdk.thread.ThreadInfo;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.gslbsdk.thread.TimerMgr;
import com.yy.gslbsdk.thread.TimerTaskInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.IPTools;
import com.yy.gslbsdk.util.LogTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DnsResolveFlow {
    private AtomicInteger mIncreaseId = new AtomicInteger(1);
    private static DnsResolveFlow mDnsResolveFlow = null;
    private ConcurrentHashMap<String, AtomicBoolean> mPendingReqs = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicInteger> mPendingHttpCode = new ConcurrentHashMap();
    private NetStatusReceiver mNetStatusReceiver = null;

    public static DnsResolveFlow getInstance() {
        if (mDnsResolveFlow == null) {
            mDnsResolveFlow = new DnsResolveFlow();
        }
        return mDnsResolveFlow;
    }

    private void handleTTL() {
        if (GlobalTools.IS_BACKGOUND_MODEL) {
            return;
        }
        TtlController ttlController = TtlController.getInstance();
        if (ttlController.isActive() && !ttlController.addTtlIntervalCount()) {
            return;
        }
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
        final NetStatusInfo network = new NetStatusInfo();
        network.resetVal(DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT));
        DataCacheMgr.INSTANCE.setCachedNetStateInfo(network);
        if (network.getNetType() == 0) {
            return;
        }
        final ArrayList<String> host2Update = new ArrayList<String>();
        if (!host2Update.isEmpty()) {
            host2Update.clear();
        }
        List<HostTB> hostList = dbMgr.getAllHost();
        for (HostTB hostInfo : hostList) {
            String host = hostInfo.getHost();
            if (this.isHostDead(hostInfo.getInsertTime())) {
                dbMgr.delHost(hostInfo);
                dbMgr.delResultByHost(host);
                DataCacheMgr.INSTANCE.deleteHttpDNSFromMemCache(host);
                continue;
            }
            List<ResultTB> res = dbMgr.getResultByNetworkHost(DataCacheMgr.INSTANCE.getNetworkOrIgnore(host, network.getNetStatusID()), host);
            if (res != null && !res.isEmpty()) {
                ResultTB resultInfo = res.get(0);
                if (this.isDead(resultInfo.getUpdateTime())) {
                    dbMgr.delResult(resultInfo);
                    DataCacheMgr.INSTANCE.deleteHttpDNSFromMemCache(host);
                }
                if (!this.isNearlyExpired(resultInfo.getEndTime())) continue;
                host2Update.add(resultInfo.getHost());
                if (host2Update.size() < 10) continue;
                break;
            }
            host2Update.add(host);
            if (host2Update.size() < 10) continue;
            break;
        }
        if (!host2Update.isEmpty()) {
            ThreadInfo task = new ThreadInfo("HttpDNS-TTL-Update-" + String.valueOf(System.currentTimeMillis()));
            task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

                @Override
                public void handleOper(String name) {
                    long millisTimeStart = SystemClock.uptimeMillis();
                    Object[] arrHost = host2Update.toArray(new String[host2Update.size()]);
                    String requestId = DnsResolveFlow.this.createRequestId();
                    final StatisticInfo rsInfo = new StatisticInfo();
                    StatisticMgr.getInstance().setStatisticInfo(requestId, rsInfo);
                    rsInfo.requestId = requestId;
                    rsInfo.host = TextUtils.join((CharSequence)"|", (Object[])arrHost);
                    rsInfo.async = 0;
                    rsInfo.netType = network.getNetType();
                    rsInfo.http = 1;
                    rsInfo.cacheType = 4;
                    int status = DnsResolveFlow.this.handleHttpDNS(network, (String[])arrHost, requestId);
                    if (status == 0) {
                        TtlController.getInstance().addStatus(true);
                    } else {
                        TtlController.getInstance().addStatus(false);
                    }
                    long stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                    rsInfo.ts = (int)stampCost;
                    if (StatisticMgr.getInstance().getStatistic() != null) {
                        ThreadInfo task = new ThreadInfo("Statistic");
                        task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

                            @Override
                            public void handleOper(String name) {
                                StatisticMgr.getInstance().removeStatisticInfo(rsInfo.requestId);
                                StatisticMgr.getInstance().onStatistic(rsInfo.toMap());
                            }
                        });
                        StatisticMgr.getInstance().addTask(task);
                    }
                }
            });
            ThreadPoolMgr.getInstance().addTask(task);
        }
    }

    private boolean isExpired(long endTime) {
        return System.currentTimeMillis() >= endTime;
    }

    private boolean isNearlyExpired(long endTime) {
        return endTime - System.currentTimeMillis() < (long)GlobalTools.TTL_NEARLY_EXPIRED_TIME_SPAN;
    }

    private boolean isDead(long updateTime) {
        long deadTime = updateTime + (long)(GlobalTools.TTL_LIVE_SECOND * 1000);
        return System.currentTimeMillis() >= deadTime;
    }

    private boolean isHostDead(long updateTime) {
        long deadTime = updateTime + (long)(GlobalTools.TTL_HOST_ALIVE_SECOND * 1000);
        return System.currentTimeMillis() >= deadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleDegradation(final String host, final DnsResultInfo resultInfo) {
        AtomicInteger requestLock;
        AtomicInteger atomicInteger = requestLock = new AtomicInteger(-1);
        synchronized (atomicInteger) {
            ThreadInfo task = new ThreadInfo("LocalDNS-" + host);
            task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleOper(String name) {
                    DnsInfo dnsInfo = LocalDNSProtocolMgr.requestProtocol(host);
                    if (dnsInfo == null) {
                        resultInfo.mErrorCode = 2;
                        resultInfo.mDataSource = 0;
                        resultInfo.mIps = new String[0];
                    } else {
                        DataCacheMgr.INSTANCE.putLocalDNSIntoCache(dnsInfo);
                        resultInfo.mErrorCode = 0;
                        resultInfo.mDataSource = 4;
                        resultInfo.mIps = dnsInfo.getIps().toArray(new String[0]);
                    }
                    AtomicInteger atomicInteger = requestLock;
                    synchronized (atomicInteger) {
                        requestLock.set(resultInfo.mErrorCode);
                        requestLock.notifyAll();
                    }
                }
            });
            ThreadPoolMgr.getInstance().addTask(task);
            try {
                requestLock.wait(GlobalTools.LOCALDNS_TIMEOUT);
            }
            catch (InterruptedException e) {
                GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
                LogTools.printWarning(e);
            }
            if (requestLock.get() == -1) {
                return 1;
            }
            return requestLock.get();
        }
    }

    private int handleLocalDNS(final String host) {
        ThreadInfo task = new ThreadInfo("LocalDNS-" + host);
        task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

            @Override
            public void handleOper(String name) {
                DnsInfo dnsInfo = LocalDNSProtocolMgr.requestProtocol(host);
                if (dnsInfo != null) {
                    NetStatusInfo network = DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT);
                    dnsInfo.setNt(network.getNetType());
                    DnsInfo cacheDnsInfo = new DnsInfo();
                    int code = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network.getNetStatusID(), host, cacheDnsInfo);
                    if (code == 0) {
                        dnsInfo.setUip(cacheDnsInfo.getUip());
                    }
                    dnsInfo.setEndTime(System.currentTimeMillis() + 600000L);
                    DataCacheMgr.INSTANCE.putLocalDNSIntoCache(dnsInfo);
                } else {
                    LogTools.printError("local parse error");
                }
            }
        });
        ThreadPoolMgr.getInstance().addTask(task);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleHttpDNS(final NetStatusInfo network, final String[] host, final String requestId) {
        if (network.getNetType() == 0) {
            return 10;
        }
        ServerIPMgr.getInstance().initServerIP(GlobalTools.APP_CONTEXT, GlobalTools.APP_LOCALIZE_CODE);
        ArrayList<Object> listServerIp = null;
        LinkedList<ServerIPInfo> listBest = ServerIPMgr.getInstance().getBestServerIPCache();
        if (listBest.size() < GlobalTools.ALL_ISP_IP_NUM) {
            listServerIp = network.isKnowIsp() ? ServerIPMgr.getInstance().getServerIPByKnownISP(GlobalTools.APP_CONTEXT, network.getIsp()) : ServerIPMgr.getInstance().getServerIPByUnKnownISP(GlobalTools.APP_CONTEXT);
        } else {
            listServerIp = new ArrayList();
            int cnt = GlobalTools.ALL_ISP_IP_NUM <= listBest.size() ? GlobalTools.ALL_ISP_IP_NUM : listBest.size();
            for (int i = 0; i < cnt; ++i) {
                String ip = listBest.get(i).getIp();
                if (ip == null) continue;
                listServerIp.add(ip);
            }
        }
        if (listServerIp.size() == 0) {
            LogTools.printError("request HttpDns no ServerIp");
            GslbEvent.INSTANCE.onMessage("request HttpDns no ServerIp");
            return 8;
        }
        final StatisticInfo rsInfo = StatisticMgr.getInstance().getStatisticInfo(requestId);
        rsInfo.setSrvIp(listServerIp);
        final AtomicInteger requestLock = new AtomicInteger(-1);
        final AtomicInteger requestFailedCount = new AtomicInteger(listServerIp.size());
        final int httpsLevel = GlobalTools.HTTPS_LEVEL;
        AtomicInteger atomicInteger = requestLock;
        synchronized (atomicInteger) {
            for (int i = 0; i < listServerIp.size(); ++i) {
                int numHttp;
                final String ip = (String)listServerIp.get(i);
                final boolean https = httpsLevel == 2 ? true : (httpsLevel == 1 ? i >= (numHttp = listServerIp.size() / 2) : false);
                ThreadInfo task = new ThreadInfo("HttpDNS-" + network.getNetStatusID() + "-" + ip + "-" + IPTools.hosts2String(host));
                task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleOper(String name) {
                        LogTools.printDebug(String.format("HttpDns thread, host: %s, serverIp: %s, is_https: %b, httpsLevel: %d", Arrays.toString(host), ip, https, httpsLevel));
                        long millisTimeBegin = SystemClock.uptimeMillis();
                        String[] res = HttpDNSProtocolMgr.requestHttpDnsV2(host, ip, false, https, requestId);
                        if (res == null || !"200".equals(res[0])) {
                            GslbEvent.INSTANCE.onMessage("server ip = " + ip + ", httpdns parse error");
                            if (res != null) {
                                rsInfo.httpErrCode = Integer.parseInt(res[0]);
                                rsInfo.httpErrMsg = res[1];
                            } else {
                                rsInfo.httpErrCode = -999;
                                rsInfo.httpErrMsg = "result is null";
                            }
                            if (0 == requestFailedCount.decrementAndGet()) {
                                requestLock.compareAndSet(-1, rsInfo.httpErrCode);
                                AtomicInteger atomicInteger = requestLock;
                                synchronized (atomicInteger) {
                                    requestLock.notifyAll();
                                }
                            }
                            return;
                        }
                        GslbEvent.INSTANCE.onMessage("server ip = " + ip + ", result = " + res[1]);
                        long millisTimeEnd = SystemClock.uptimeMillis();
                        ResInfo resInfo = new ResInfo();
                        resInfo.setNetInfo(network);
                        HttpDNSProtocolMgr.responseProtocolV2(res[1], resInfo);
                        AtomicInteger atomicInteger = requestLock;
                        synchronized (atomicInteger) {
                            if (resInfo.getStatus() == 0 || resInfo.getStatus() == 6) {
                                rsInfo.httpErrCode = 0;
                                rsInfo.httpErrMsg = "success";
                                long delay = millisTimeEnd - millisTimeBegin;
                                if (requestLock.get() == -1) {
                                    requestLock.set(resInfo.getStatus());
                                    if (resInfo.getStatus() == 6 && resInfo.getDns() != null) {
                                        for (DnsInfo dnsInfo : resInfo.getDns().values()) {
                                            if (!dnsInfo.getIps().isEmpty()) continue;
                                            dnsInfo.setTtl(31536000);
                                        }
                                    }
                                    DataCacheMgr.INSTANCE.putHttpDNSIntoCache(GlobalTools.APP_CONTEXT, resInfo);
                                }
                                ServerIPInfo ipInfo = new ServerIPInfo();
                                ipInfo.setIp(ip);
                                ipInfo.setScore(delay);
                                ServerIPMgr.getInstance().resetBestServerIPCache(ipInfo);
                                if (resInfo.getHttpdns().isRe()) {
                                    QualityDetectFlow.getInstance().addReportData(GlobalTools.HTTPDNS_REPORT_HOST, ip, delay);
                                }
                                if (ServerIPMgr.getInstance().canUpdate(GlobalTools.APP_CONTEXT, resInfo.getHttpdns().getVer())) {
                                    ServerIPMgr.getInstance().updateServerIP(GlobalTools.APP_CONTEXT, ip);
                                }
                                requestLock.notifyAll();
                            } else if (0 == requestFailedCount.decrementAndGet()) {
                                requestLock.compareAndSet(-1, resInfo.getStatus());
                                requestLock.notifyAll();
                            }
                        }
                    }
                });
                ThreadPoolMgr.getInstance().addTask(task);
            }
            try {
                requestLock.wait(GlobalTools.HTTPDNS_TIMEOUT);
            }
            catch (InterruptedException e) {
                GslbEvent.INSTANCE.onMessage(String.format("%s warning. msg: %s", LogTools.TAG, e.getMessage()));
                LogTools.printWarning(e);
            }
            if (requestLock.get() == -1) {
                GslbEvent.INSTANCE.onMessage("all httpdns request timeout");
                rsInfo.httpErrCode = 1;
                rsInfo.httpErrMsg = "all httpdns request timeout";
                return 1;
            }
            return requestLock.get();
        }
    }

    public int handleHttpDNSIgnoreCache(NetStatusInfo network, String[] host, ResInfo realTimeResInfo, boolean total) {
        String serverIP = null;
        LinkedList<ServerIPInfo> serverIPCache = ServerIPMgr.getInstance().getBestServerIPCache();
        serverIP = serverIPCache.isEmpty() ? ServerIPMgr.getInstance().getOneServerIPByUnKnownISP(GlobalTools.APP_CONTEXT) : serverIPCache.get(0).getIp();
        if (serverIP == null) {
            LogTools.printInfo("ServerIP is NULL");
            return 8;
        }
        String[] res = HttpDNSProtocolMgr.requestHttpDnsV2(host, serverIP, total);
        if (res != null) {
            HttpDNSProtocolMgr.responseProtocolV2(res[1], realTimeResInfo);
        }
        return realTimeResInfo.getStatus();
    }

    private int deleteHost(String host) {
        if (GlobalTools.APP_CONTEXT != null) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
            HostTB hosttb = new HostTB();
            hosttb.setHost(host);
            dbMgr.delHost(hosttb);
            return 0;
        }
        return 5;
    }

    private int synUpdateHostList(ArrayList<String> hostList, boolean isPreResolve) {
        if (GlobalTools.APP_CONTEXT != null) {
            long insertTime = System.currentTimeMillis();
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
            for (String loop : hostList) {
                HostTB host;
                List<HostTB> hosts = dbMgr.getHostByHost(loop);
                if (hosts.isEmpty()) {
                    host = new HostTB();
                    host.setHost(loop);
                    host.setInsertTime(insertTime);
                    host.setIsPre(isPreResolve ? 1 : 0);
                    dbMgr.addHost(host);
                    continue;
                }
                host = hosts.get(0);
                host.setInsertTime(insertTime);
                host.setIsPre(isPreResolve ? 1 : 0);
                dbMgr.updateHost(host);
            }
            List<HostTB> curList = dbMgr.getAllHost();
            for (int i = curList.size() - 1; i >= GlobalTools.KEEP_HOST_NUM; --i) {
                dbMgr.delHost(curList.get(i));
            }
            curList.clear();
            return 0;
        }
        return 5;
    }

    private void judgeUpdateHost(String host, int codeHttp, int codeCacheHttp) {
        if (codeHttp == 0 && codeCacheHttp == 0) {
            ArrayList<String> newHostList = new ArrayList<String>();
            newHostList.add(host);
            this.updateHostList(newHostList, false);
        }
    }

    public void updateHostList(ArrayList<String> hostList, boolean isPreResolve) {
        AsynTaskMgr.INSTANCE.updateHost(hostList, isPreResolve);
    }

    public synchronized int beginNetworkMonitor() {
        if (GlobalTools.APP_CONTEXT != null) {
            if (this.mNetStatusReceiver == null) {
                this.mNetStatusReceiver = new NetStatusReceiver(new NetStatusReceiver.ChangeNetworkInter(){

                    @Override
                    public void onNetStateChanged() {
                        DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
                        if (GlobalTools.REFRESH_AFTER_NETWORK_CHANGE) {
                            ServerIPMgr.getInstance().clearBestServerIPCache();
                        }
                        DataCacheMgr.INSTANCE.setCachedNetStateInfo(DeviceMgr.getNetworkInfo(GlobalTools.APP_CONTEXT));
                        DataCacheMgr.INSTANCE.deleteAllDelay();
                        DataCacheMgr.INSTANCE.clearAllInvokeApiNum();
                        DataCacheMgr.INSTANCE.clearAllHitCacheNum();
                    }
                });
            }
            this.mNetStatusReceiver.register(GlobalTools.APP_CONTEXT);
            LogTools.printDebug("beginNetworkMonitor...");
            return 0;
        }
        return 5;
    }

    public synchronized int stopNetworkMonitor() {
        if (GlobalTools.APP_CONTEXT != null) {
            if (this.mNetStatusReceiver != null) {
                this.mNetStatusReceiver.unregister(GlobalTools.APP_CONTEXT);
            }
            return 0;
        }
        return 5;
    }

    public synchronized int beginTTLMonitor() {
        if (GlobalTools.APP_CONTEXT != null) {
            TimerTaskInfo newWorker = new TimerTaskInfo();
            newWorker.setTaskName(GlobalTools.TTL_MONITOR_NAME);
            newWorker.setWorker(new TimerTask(){

                @Override
                public void run() {
                    DnsResolveFlow.this.handleTTL();
                }
            });
            TimerMgr.getInstance().addWorker(newWorker, 0L, GlobalTools.TTL_MONITOR_PERIOD);
            LogTools.printDebug("beginTTLMonitor...");
            return 0;
        }
        return 5;
    }

    private String createRequestId() {
        String gslbId = DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT);
        String requestId = String.format("%s_%d_%d", gslbId, System.currentTimeMillis(), this.mIncreaseId.getAndIncrement());
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public DnsResultInfo handleDNS(String host, boolean degradation, boolean async, boolean enableExpiredIp, boolean forceRefresh, boolean enableLocalDns) {
        block35: {
            block36: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    millisTimeStart = SystemClock.uptimeMillis();
                                    DataCacheMgr.INSTANCE.addInvokeApiNum(host);
                                    host = host.trim();
                                    requestId = this.createRequestId();
                                    rsInfo = new StatisticInfo();
                                    StatisticMgr.getInstance().setStatisticInfo(requestId, rsInfo);
                                    rsInfo.requestId = requestId;
                                    rsInfo.host = host;
                                    v0 = rsInfo.async = async != false ? 1 : 0;
                                    if (GlobalTools.sListHostIgnoreNetChange.contains(host)) {
                                        rsInfo.netType = 1;
                                    } else {
                                        network = DataCacheMgr.INSTANCE.getCachedNetStatusInfo();
                                        rsInfo.netType = network.getNetType();
                                    }
                                    resultInfo = new DnsResultInfo();
                                    try {
                                        if (host != null && !"".equals(host.trim())) break block30;
                                        var12_11 = resultInfo;
                                    }
                                    catch (Throwable var20_37) {
                                        stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                                        this.collectStat0(millisTimeStart, resultInfo);
                                        rsInfo.ts = (int)stampCost;
                                        if (resultInfo.mErrorCode == 0) {
                                            ips = Arrays.asList(resultInfo.mIps);
                                            rsInfo.rsIp.addAll(ips);
                                        }
                                        if (StatisticMgr.getInstance().getStatistic() != null) {
                                            task = new ThreadInfo("Statistic");
                                            task.setThreadMainOper(new ThreadInfo.ThreadMainOper(rsInfo){
                                                final /* synthetic */ StatisticInfo val$rsInfo;
                                                {
                                                    this.val$rsInfo = statisticInfo;
                                                }

                                                @Override
                                                public void handleOper(String name) {
                                                    StatisticMgr.getInstance().removeStatisticInfo(this.val$rsInfo.requestId);
                                                    StatisticMgr.getInstance().onStatistic(this.val$rsInfo.toMap());
                                                }
                                            });
                                            StatisticMgr.getInstance().addTask(task, 3000L);
                                        }
                                        throw var20_37;
                                    }
                                    stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                                    this.collectStat0(millisTimeStart, resultInfo);
                                    rsInfo.ts = (int)stampCost;
                                    if (resultInfo.mErrorCode == 0) {
                                        ips = Arrays.asList(resultInfo.mIps);
                                        rsInfo.rsIp.addAll(ips);
                                    }
                                    if (StatisticMgr.getInstance().getStatistic() != null) {
                                        task = new ThreadInfo("Statistic");
                                        task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
                                        StatisticMgr.getInstance().addTask(task, 3000L);
                                    }
                                    return var12_11;
                                }
                                if (GlobalTools.APP_CONTEXT != null) break block31;
                                var12_12 = resultInfo;
                                stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                                this.collectStat0(millisTimeStart, resultInfo);
                                rsInfo.ts = (int)stampCost;
                                if (resultInfo.mErrorCode == 0) {
                                    ips = Arrays.asList(resultInfo.mIps);
                                    rsInfo.rsIp.addAll(ips);
                                }
                                if (StatisticMgr.getInstance().getStatistic() != null) {
                                    task = new ThreadInfo("Statistic");
                                    task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
                                    StatisticMgr.getInstance().addTask(task, 3000L);
                                }
                                return var12_12;
                            }
                            if (!degradation || !enableLocalDns) break block32;
                            this.deleteHost(host);
                            this.handleDegradation(host, resultInfo);
                            var12_13 = resultInfo;
                            stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                            this.collectStat0(millisTimeStart, resultInfo);
                            rsInfo.ts = (int)stampCost;
                            if (resultInfo.mErrorCode == 0) {
                                ips = Arrays.asList(resultInfo.mIps);
                                rsInfo.rsIp.addAll(ips);
                            }
                            if (StatisticMgr.getInstance().getStatistic() != null) {
                                task = new ThreadInfo("Statistic");
                                task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
                                StatisticMgr.getInstance().addTask(task, 3000L);
                            }
                            return var12_13;
                        }
                        if (forceRefresh) break block33;
                        forceEnableExpired = TtlController.getInstance().enableExpired();
                        arrCode = this.handleDnsCache(requestId, resultInfo, host, 2, forceEnableExpired != false || async != false && enableExpiredIp != false);
                        codeCacheHttp = arrCode[0];
                        v1 = expiredCacheHttp = arrCode[1] == 1;
                        if (codeCacheHttp != 0 || !forceEnableExpired && expiredCacheHttp) break block33;
                        var16_31 = resultInfo;
                        stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                        this.collectStat0(millisTimeStart, resultInfo);
                        rsInfo.ts = (int)stampCost;
                        if (resultInfo.mErrorCode == 0) {
                            ips = Arrays.asList(resultInfo.mIps);
                            rsInfo.rsIp.addAll(ips);
                        }
                        if (StatisticMgr.getInstance().getStatistic() != null) {
                            task = new ThreadInfo("Statistic");
                            task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
                            StatisticMgr.getInstance().addTask(task, 3000L);
                        }
                        return var16_31;
                    }
                    if (!async) ** GOTO lbl129
                    if (!forceRefresh) break block34;
                    GslbEvent.INSTANCE.onMessage(String.format("force refresh is valid only in synchronous function! ", new Object[0]));
                    LogTools.printError(String.format("force refresh is valid only in synchronous function! ", new Object[0]));
                    resultInfo.mErrorCode = 5;
                    forceEnableExpired = resultInfo;
                    stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                    this.collectStat0(millisTimeStart, resultInfo);
                    rsInfo.ts = (int)stampCost;
                    if (resultInfo.mErrorCode == 0) {
                        ips = Arrays.asList(resultInfo.mIps);
                        rsInfo.rsIp.addAll(ips);
                    }
                    if (StatisticMgr.getInstance().getStatistic() != null) {
                        task = new ThreadInfo("Statistic");
                        task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
                        StatisticMgr.getInstance().addTask(task, 3000L);
                    }
                    return forceEnableExpired;
                }
                if (enableLocalDns) {
                    this.handleLocalDNS(host);
                }
                this.handleDnsAsync(host, requestId);
                break block35;
lbl129:
                // 1 sources

                if (enableExpiredIp) {
                    GslbEvent.INSTANCE.onMessage(String.format("enableExpiredIp is valid only in asynchronous function! ", new Object[0]));
                    LogTools.printError(String.format("enableExpiredIp is valid only in asynchronous function! ", new Object[0]));
                }
                codeHttp = this.handleDnsSync(host, requestId);
                arrCode = this.handleDnsCache(requestId, resultInfo, host, codeHttp, false);
                codeCacheHttp = arrCode[0];
                v2 = expiredCacheHttp = arrCode[1] == 1;
                if (!forceRefresh || codeHttp == 0 && resultInfo.mDataSource == 3) break block36;
                GslbEvent.INSTANCE.onMessage(String.format("force fresh %s failed! ", new Object[]{host}));
                LogTools.printError(String.format("force fresh %s failed! ", new Object[]{host}));
                resultInfo.mErrorCode = codeHttp;
                resultInfo.mDataSource = 0;
                resultInfo.mIps = new String[0];
                rsInfo.cacheType = 0;
                var16_32 = resultInfo;
                stampCost = SystemClock.uptimeMillis() - millisTimeStart;
                this.collectStat0(millisTimeStart, resultInfo);
                rsInfo.ts = (int)stampCost;
                if (resultInfo.mErrorCode == 0) {
                    ips = Arrays.asList(resultInfo.mIps);
                    rsInfo.rsIp.addAll(ips);
                }
                if (StatisticMgr.getInstance().getStatistic() != null) {
                    task = new ThreadInfo("Statistic");
                    task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
                    StatisticMgr.getInstance().addTask(task, 3000L);
                }
                return var16_32;
            }
            if (codeHttp == 0 && codeCacheHttp != 0) {
                GslbEvent.INSTANCE.onMessage(host + " not support by gslb");
                LogTools.printDebug(String.format("%s not support by gslb", new Object[]{host}));
            }
            if (resultInfo.mDataSource == 0 && enableLocalDns) {
                this.handleLocalDNS(host);
            }
            this.judgeUpdateHost(host, codeHttp, codeCacheHttp);
        }
        stampCost = SystemClock.uptimeMillis() - millisTimeStart;
        this.collectStat0(millisTimeStart, resultInfo);
        rsInfo.ts = (int)stampCost;
        if (resultInfo.mErrorCode == 0) {
            ips = Arrays.asList(resultInfo.mIps);
            rsInfo.rsIp.addAll(ips);
        }
        if (StatisticMgr.getInstance().getStatistic() != null) {
            task = new ThreadInfo("Statistic");
            task.setThreadMainOper(new /* invalid duplicate definition of identical inner class */);
            StatisticMgr.getInstance().addTask(task, 3000L);
        }
        return resultInfo;
    }

    private void collectStat0(long millisTimeStart, DnsResultInfo resultInfo) {
        long stampCost = SystemClock.uptimeMillis() - millisTimeStart;
        DataCacheMgr.INSTANCE.addDnsCost(stampCost);
        if (resultInfo.mErrorCode != 0) {
            DataCacheMgr.INSTANCE.addFailedDnsCount();
        } else if (resultInfo.mDataSource == 4) {
            DataCacheMgr.INSTANCE.addLocalDnsCount();
        }
    }

    private void handleDnsAsync(final String host, final String requestId) {
        String network = DataCacheMgr.INSTANCE.getNetworkOrIgnore(host);
        ThreadInfo task = new ThreadInfo("HttpDNS-" + network + "-" + host);
        task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

            @Override
            public void handleOper(String name) {
                String network = DataCacheMgr.INSTANCE.getNetworkOrIgnore(host);
                int codeHttp = DnsResolveFlow.this.handleDnsSync(host, requestId);
                DnsInfo cacheDnsInfo = new DnsInfo();
                int codeCacheHttp = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network, host, cacheDnsInfo);
                DnsResolveFlow.this.judgeUpdateHost(host, codeHttp, codeCacheHttp);
            }
        });
        ThreadPoolMgr.getInstance().addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleDnsSync(String host, String requestId) {
        String network = DataCacheMgr.INSTANCE.getNetworkOrIgnore(host);
        int codeHttp = 2;
        String key = host + network;
        StatisticInfo rsInfo = StatisticMgr.getInstance().getStatisticInfo(requestId);
        AtomicBoolean req = null;
        AtomicInteger aiHttpCode = null;
        Serializable serializable = this.mPendingReqs;
        synchronized (serializable) {
            req = this.mPendingReqs.get(key);
            if (req == null) {
                req = new AtomicBoolean(false);
                this.mPendingReqs.putIfAbsent(key, req);
            }
            if ((aiHttpCode = this.mPendingHttpCode.get(key)) == null) {
                aiHttpCode = new AtomicInteger(codeHttp);
                this.mPendingHttpCode.putIfAbsent(key, aiHttpCode);
            }
        }
        if (req.compareAndSet(false, true)) {
            NetStatusInfo netStatus = DataCacheMgr.INSTANCE.getCachedNetStatusInfo();
            codeHttp = this.handleHttpDNS(netStatus, new String[]{host}, requestId);
            rsInfo.http = 1;
            aiHttpCode.set(codeHttp);
            req.set(false);
            this.mPendingHttpCode.remove(key);
            this.mPendingReqs.remove(key);
            AtomicBoolean atomicBoolean = req;
            synchronized (atomicBoolean) {
                req.notifyAll();
            }
        }
        if (req.get()) {
            serializable = req;
            synchronized (serializable) {
                try {
                    req.wait(GlobalTools.HTTPDNS_TIMEOUT);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        rsInfo.http = 2;
        codeHttp = aiHttpCode.get();
        return codeHttp;
    }

    private int[] handleDnsCache(String requestId, DnsResultInfo resultInfo, String host, int codeHttp, boolean enableExpiredIp) {
        String network = DataCacheMgr.INSTANCE.getNetworkOrIgnore(host);
        DnsInfo cacheDnsInfo = new DnsInfo();
        int codeCacheHttp = DataCacheMgr.INSTANCE.getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network, host, cacheDnsInfo);
        StatisticInfo rsInfo = StatisticMgr.getInstance().getStatisticInfo(requestId);
        boolean expiredCacheHttp = true;
        if (codeCacheHttp == 0) {
            expiredCacheHttp = this.isExpired(cacheDnsInfo.getEndTime());
            if (cacheDnsInfo.getIps().size() == 0) {
                resultInfo.mErrorCode = 6;
                resultInfo.mDataSource = 0;
                resultInfo.mIps = new String[0];
            } else if (enableExpiredIp || !expiredCacheHttp) {
                resultInfo.mErrorCode = 0;
                resultInfo.mDataSource = codeHttp == 0 ? 3 : 1;
                resultInfo.mIps = cacheDnsInfo.getIps().toArray(new String[0]);
                rsInfo.cacheType = expiredCacheHttp ? 2 : 1;
                rsInfo.uip = cacheDnsInfo.getUip();
            } else {
                resultInfo.mErrorCode = 2;
            }
        }
        if (resultInfo.mErrorCode != 0) {
            int codeCacheLocal = DataCacheMgr.INSTANCE.getLocalDNSFromCache(host, cacheDnsInfo);
            if (codeCacheLocal == 0) {
                resultInfo.mErrorCode = 0;
                resultInfo.mDataSource = 4;
                resultInfo.mIps = cacheDnsInfo.getIps().toArray(new String[0]);
                rsInfo.cacheType = 3;
            } else {
                resultInfo.mErrorCode = codeHttp;
                resultInfo.mDataSource = 0;
                resultInfo.mIps = new String[0];
            }
        }
        return new int[]{codeCacheHttp, expiredCacheHttp ? 1 : 0};
    }
}

