/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.device;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;

public class DeviceMgr {
    private static NetStatusInfo cur_network = new NetStatusInfo();

    public static int getISP(Context context) {
        int isp = 0;
        if (!"CN".equalsIgnoreCase(GlobalTools.APP_LOCALIZE_CODE)) {
            return isp;
        }
        try {
            TelephonyManager telManager;
            String operator;
            if (context != null && (operator = (telManager = (TelephonyManager)context.getSystemService("phone")).getSimOperator()) != null) {
                if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007") || operator.equals("46020")) {
                    isp = 3;
                } else if (operator.equals("46001") || operator.equals("46006")) {
                    isp = 2;
                } else if (operator.equals("46003") || operator.equals("46005")) {
                    isp = 1;
                }
            }
        }
        catch (Exception e) {
            LogTools.printError("getISP() exception:" + e.getMessage());
        }
        return isp;
    }

    public static int getNetworkType(Context context) {
        try {
            if (context != null) {
                ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivity == null) {
                    return 1;
                }
                NetworkInfo activeNetInfo = connectivity.getActiveNetworkInfo();
                if (activeNetInfo == null) {
                    return 0;
                }
                if (!activeNetInfo.isAvailable() || !activeNetInfo.isConnected()) {
                    return 0;
                }
                if (activeNetInfo.getType() == 1) {
                    return 2;
                }
                if (activeNetInfo.getType() == 0) {
                    switch (activeNetInfo.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            return 3;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 15: {
                            return 4;
                        }
                        case 13: {
                            return 5;
                        }
                    }
                    return 1;
                }
                return 1;
            }
        }
        catch (Exception e) {
            LogTools.printError("getNetworkType() exception:" + e.getMessage());
        }
        return 1;
    }

    public static String getWiFiSsid(Context context) {
        return "wifi";
    }

    public static NetworkInfo getActiveNetwork(Context context) {
        if (context == null) {
            return null;
        }
        ConnectivityManager mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (mConnMgr == null) {
            return null;
        }
        try {
            NetworkInfo aActiveInfo = mConnMgr.getActiveNetworkInfo();
            return aActiveInfo;
        }
        catch (Exception e) {
            LogTools.printError(String.format("getActiveNetwork error. msg: %s", e.getMessage()));
            return null;
        }
    }

    public static NetStatusInfo getNetworkInfo(Context context) {
        NetStatusInfo info = new NetStatusInfo();
        info.setNetType(DeviceMgr.getNetworkType(context));
        info.setIsp(DeviceMgr.getISP(context));
        info.setSsid(DeviceMgr.getWiFiSsid(context));
        return info;
    }

    public static boolean isChangeNetworkStatus(Context context) {
        boolean response = false;
        NetStatusInfo newInfo = DeviceMgr.getNetworkInfo(context);
        response = !newInfo.getNetStatusID().equals(cur_network.getNetStatusID());
        cur_network = newInfo;
        return response;
    }
}

