/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.date;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.wdullaer.materialdatetimepicker.GravitySnapHelper;
import com.wdullaer.materialdatetimepicker.Utils;
import com.wdullaer.materialdatetimepicker.date.DatePickerController;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import com.wdullaer.materialdatetimepicker.date.MonthAdapter;
import com.wdullaer.materialdatetimepicker.date.MonthView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public abstract class DayPickerView
extends RecyclerView
implements DatePickerDialog.OnDateChangedListener {
    private static final String TAG = "MonthFragment";
    protected Context mContext;
    protected MonthAdapter.CalendarDay mSelectedDay;
    protected MonthAdapter mAdapter;
    protected MonthAdapter.CalendarDay mTempDay;
    protected int mCurrentMonthDisplayed;
    protected int mPreviousScrollState = 0;
    private OnPageListener pageListener;
    private DatePickerController mController;

    public DayPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        DatePickerDialog.ScrollOrientation scrollOrientation = Build.VERSION.SDK_INT < 23 ? DatePickerDialog.ScrollOrientation.VERTICAL : DatePickerDialog.ScrollOrientation.HORIZONTAL;
        this.init(context, scrollOrientation);
    }

    public DayPickerView(Context context, DatePickerController controller) {
        super(context);
        this.init(context, controller.getScrollOrientation());
        this.setController(controller);
    }

    protected void setController(DatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.mSelectedDay = new MonthAdapter.CalendarDay(this.mController.getTimeZone());
        this.mTempDay = new MonthAdapter.CalendarDay(this.mController.getTimeZone());
        this.refreshAdapter();
    }

    public void init(Context context, DatePickerDialog.ScrollOrientation scrollOrientation) {
        int layoutOrientation = scrollOrientation == DatePickerDialog.ScrollOrientation.VERTICAL ? 1 : 0;
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, layoutOrientation, false);
        this.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setClipChildren(false);
        this.mContext = context;
        this.setUpRecyclerView(scrollOrientation);
    }

    protected void setUpRecyclerView(DatePickerDialog.ScrollOrientation scrollOrientation) {
        this.setVerticalScrollBarEnabled(false);
        this.setFadingEdgeLength(0);
        int gravity = scrollOrientation == DatePickerDialog.ScrollOrientation.VERTICAL ? 48 : 0x800003;
        GravitySnapHelper helper = new GravitySnapHelper(gravity, position -> {
            if (this.pageListener != null) {
                this.pageListener.onPageChanged(position);
            }
        });
        helper.attachToRecyclerView(this);
    }

    public void onChange() {
        this.refreshAdapter();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        MonthAdapter.CalendarDay focusedDay = this.findAccessibilityFocus();
        this.restoreAccessibilityFocus(focusedDay);
    }

    protected void refreshAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = this.createMonthAdapter(this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
            if (this.pageListener != null) {
                this.pageListener.onPageChanged(this.getMostVisiblePosition());
            }
        }
        this.setAdapter(this.mAdapter);
    }

    public abstract MonthAdapter createMonthAdapter(DatePickerController var1);

    public void setOnPageListener(@Nullable OnPageListener pageListener) {
        this.pageListener = pageListener;
    }

    @Nullable
    public OnPageListener getOnPageListener() {
        return this.pageListener;
    }

    public boolean goTo(MonthAdapter.CalendarDay day, boolean animate, boolean setSelected, boolean forceScroll) {
        int selectedPosition;
        View child;
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int minMonth = this.mController.getStartDate().get(2);
        int position = (day.year - this.mController.getMinYear()) * 12 + day.month - minMonth;
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null) {
            top = child.getTop();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("child at " + (i - 1) + " has top " + top));
            }
            if (top < 0) continue;
        }
        int n = selectedPosition = child != null ? this.getChildAdapterPosition(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("GoTo position " + position));
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 1;
            if (animate) {
                this.smoothScrollToPosition(position);
                if (this.pageListener != null) {
                    this.pageListener.onPageChanged(position);
                }
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void postSetSelection(int position) {
        this.clearFocus();
        this.post(() -> {
            ((LinearLayoutManager)this.getLayoutManager()).scrollToPositionWithOffset(position, 0);
            this.restoreAccessibilityFocus(this.mSelectedDay);
            if (this.pageListener != null) {
                this.pageListener.onPageChanged(position);
            }
        });
    }

    protected void setMonthDisplayed(MonthAdapter.CalendarDay date) {
        this.mCurrentMonthDisplayed = date.month;
    }

    public int getMostVisiblePosition() {
        return this.getChildAdapterPosition(this.getMostVisibleMonth());
    }

    @Nullable
    public MonthView getMostVisibleMonth() {
        View child;
        boolean verticalScroll = this.mController.getScrollOrientation() == DatePickerDialog.ScrollOrientation.VERTICAL;
        int maxSize = verticalScroll ? this.getHeight() : this.getWidth();
        int maxDisplayedSize = 0;
        int i = 0;
        int size = 0;
        MonthView mostVisibleMonth = null;
        while (size < maxSize && (child = this.getChildAt(i)) != null) {
            size = verticalScroll ? child.getBottom() : child.getRight();
            int endPosition = verticalScroll ? child.getTop() : child.getLeft();
            int displayedSize = Math.min(size, maxSize) - Math.max(0, endPosition);
            if (displayedSize > maxDisplayedSize) {
                mostVisibleMonth = (MonthView)child;
                maxDisplayedSize = displayedSize;
            }
            ++i;
        }
        return mostVisibleMonth;
    }

    public int getCount() {
        return this.mAdapter.getItemCount();
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    private MonthAdapter.CalendarDay findAccessibilityFocus() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            MonthAdapter.CalendarDay focus;
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || (focus = ((MonthView)child).getAccessibilityFocus()) == null) continue;
            if (Build.VERSION.SDK_INT == 17) {
                ((MonthView)child).clearAccessibilityFocus();
            }
            return focus;
        }
        return null;
    }

    private boolean restoreAccessibilityFocus(MonthAdapter.CalendarDay day) {
        if (day == null) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof MonthView) || !((MonthView)child).restoreAccessibilityFocus(day)) continue;
            return true;
        }
        return false;
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setItemCount(-1);
    }

    void accessibilityAnnouncePageChanged() {
        MonthView mv = this.getMostVisibleMonth();
        if (mv != null) {
            String monthYear = DayPickerView.getMonthAndYearString(mv.mMonth, mv.mYear, this.mController.getLocale());
            Utils.tryAccessibilityAnnounce((View)this, monthYear);
        } else {
            Log.w((String)"DayPickerView", (String)"Tried to announce before layout was initialized");
        }
    }

    private static String getMonthAndYearString(int month, int year, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, month);
        calendar.set(1, year);
        return new SimpleDateFormat("MMMM yyyy", locale).format(calendar.getTime());
    }

    public static interface OnPageListener {
        public void onPageChanged(int var1);
    }
}

