/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.spdt.skin.widget.attrs;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.api.R;
import com.unionyy.mobile.spdt.skin.widget.attrs.AttributeHelper;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0014J.\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u00072\b\b\u0001\u0010\u0018\u001a\u00020\u00072\b\b\u0001\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unionyy/mobile/spdt/skin/widget/attrs/SpdtTextAttrsHelper;", "Lcom/unionyy/mobile/spdt/skin/widget/attrs/AttributeHelper;", "view", "Landroid/widget/TextView;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/widget/TextView;Landroid/util/AttributeSet;I)V", "mDrawableLeft", "mDrawableRight", "mDrawableTop", "mDrawaleBottom", "mTextColor", "mTextColorHint", "applyCompoundDrawablesResource", "", "applySkin", "applyTextColorHintResource", "applyTextColorResource", "onLoadAttributes", "onSetCompundDrawableWithInstrinsicBounds", "left", "top", "right", "bottom", "onSetTextAttrsResource", "resId", "spdt-api_release"})
public final class SpdtTextAttrsHelper
extends AttributeHelper {
    @ColorRes
    private int mTextColor;
    @ColorRes
    private int mTextColorHint;
    private int mDrawableLeft;
    private int mDrawableRight;
    private int mDrawableTop;
    private int mDrawaleBottom;

    @Override
    protected void onLoadAttributes() {
        TypedArray $receiver;
        TypedArray a$iv;
        AttributeSet attr$iv;
        SpdtTextAttrsHelper this_$iv;
        SpdtTextAttrsHelper spdtTextAttrsHelper = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)R.styleable.SpdtTextAppearance, (String)"R.styleable.SpdtTextAppearance");
        int[] styleRes$iv = R.styleable.SpdtTextAppearance;
        AttributeSet attributeSet = AttributeHelper.access$getAttrs$p(this_$iv);
        if (attributeSet == null) {
        } else {
            attr$iv = attributeSet;
            a$iv = AttributeHelper.access$getView$p(this_$iv).getContext().obtainStyledAttributes(attr$iv, styleRes$iv, AttributeHelper.access$getDefStyleAttr$p(this_$iv), 0);
            try {
                TypedArray typedArray = a$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"a");
                $receiver = typedArray;
                this.mTextColor = $receiver.getResourceId(R.styleable.SpdtTextAppearance_android_textColor, 0);
                this.mTextColorHint = $receiver.getResourceId(R.styleable.SpdtTextAppearance_android_textColorHint, 0);
            }
            catch (Exception e$iv) {
                a$iv.recycle();
            }
        }
        this_$iv = this;
        Intrinsics.checkExpressionValueIsNotNull((Object)R.styleable.SpdtTextAttrsHelper, (String)"R.styleable.SpdtTextAttrsHelper");
        styleRes$iv = R.styleable.SpdtTextAttrsHelper;
        AttributeSet attributeSet2 = AttributeHelper.access$getAttrs$p(this_$iv);
        if (attributeSet2 == null) {
        } else {
            attr$iv = attributeSet2;
            a$iv = AttributeHelper.access$getView$p(this_$iv).getContext().obtainStyledAttributes(attr$iv, styleRes$iv, AttributeHelper.access$getDefStyleAttr$p(this_$iv), 0);
            try {
                TypedArray typedArray = a$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"a");
                $receiver = typedArray;
                this.mDrawableLeft = $receiver.getResourceId(R.styleable.SpdtTextAttrsHelper_android_drawableLeft, 0);
                this.mDrawableRight = $receiver.getResourceId(R.styleable.SpdtTextAttrsHelper_android_drawableRight, 0);
                this.mDrawableTop = $receiver.getResourceId(R.styleable.SpdtTextAttrsHelper_android_drawableTop, 0);
                this.mDrawaleBottom = $receiver.getResourceId(R.styleable.SpdtTextAttrsHelper_android_drawableBottom, 0);
            }
            catch (Exception e$iv) {
                a$iv.recycle();
            }
        }
    }

    public final void onSetTextAttrsResource(int resId) {
        TypedArray type = this.getView().getContext().obtainStyledAttributes(resId, R.styleable.SpdtTextAppearance);
        if (type.hasValue(R.styleable.SpdtTextAppearance_android_textColor)) {
            this.mTextColor = type.getResourceId(R.styleable.SpdtTextAppearance_android_textColor, 0);
        }
        if (type.hasValue(R.styleable.SpdtTextAppearance_android_textColorHint)) {
            this.mTextColorHint = type.getResourceId(R.styleable.SpdtTextAppearance_android_textColorHint, 0);
        }
        TypedArray typedArray = type;
        if (typedArray != null) {
            typedArray.recycle();
        }
        this.applyTextColorResource();
        this.applyTextColorHintResource();
    }

    public final void onSetCompundDrawableWithInstrinsicBounds(@DrawableRes int left, @DrawableRes int top, @DrawableRes int right, @DrawableRes int bottom) {
        this.mDrawableLeft = left;
        this.mDrawableRight = right;
        this.mDrawableTop = top;
        this.mDrawaleBottom = bottom;
        this.applyCompoundDrawablesResource();
    }

    @Override
    public void applySkin() {
        this.applyTextColorResource();
        this.applyTextColorHintResource();
        this.applyCompoundDrawablesResource();
    }

    private final void applyTextColorResource() {
        if (this.mTextColor != 0) {
            try {
                Context context = this.getView().getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
                ColorStateList color = Spdt.INSTANCE.getColorStateList(context, this.mTextColor);
                View view = this.getView();
                if (view == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
                }
                ((TextView)view).setTextColor(color);
            }
            catch (Exception e) {
                Log.e((String)"SpdtTextAttrsHelper", (String)("e: " + e.getMessage()));
            }
        }
    }

    private final void applyTextColorHintResource() {
        if (this.mTextColorHint != 0) {
            try {
                Context context = this.getView().getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
                ColorStateList color = Spdt.INSTANCE.getColorStateList(context, this.mTextColorHint);
                View view = this.getView();
                if (view == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
                }
                ((TextView)view).setHintTextColor(color);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void applyCompoundDrawablesResource() {
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        if (this.mDrawableLeft != 0) {
            Context context = this.getView().getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            drawableLeft = Spdt.INSTANCE.getDrawable(context, this.mDrawableLeft);
        }
        if (this.mDrawableTop != 0) {
            Context context = this.getView().getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            drawableTop = Spdt.INSTANCE.getDrawable(context, this.mDrawableTop);
        }
        if (this.mDrawableRight != 0) {
            Context context = this.getView().getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            drawableRight = Spdt.INSTANCE.getDrawable(context, this.mDrawableRight);
        }
        if (this.mDrawaleBottom != 0) {
            Context context = this.getView().getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            drawableBottom = Spdt.INSTANCE.getDrawable(context, this.mDrawaleBottom);
        }
        if (this.mDrawableLeft != 0 || this.mDrawableRight != 0 || this.mDrawableTop != 0 || this.mDrawaleBottom != 0) {
            View view = this.getView();
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            ((TextView)view).setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        }
    }

    public SpdtTextAttrsHelper(@NotNull TextView view, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super((View)view, attrs, defStyleAttr);
    }
}

