/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.util;

import android.graphics.PointF;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;

public class ScrollBoundaryUtil {
    public static boolean canRefresh(View targetView, MotionEvent event) {
        if (ScrollBoundaryUtil.canScrollUp(targetView)) {
            return false;
        }
        if (targetView instanceof ViewGroup && event != null) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = childCount; i > 0; --i) {
                View child = viewGroup.getChildAt(i - 1);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView(viewGroup, child, event.getX(), event.getY(), point)) continue;
                event = MotionEvent.obtain((MotionEvent)event);
                event.offsetLocation(point.x, point.y);
                return ScrollBoundaryUtil.canRefresh(child, event);
            }
        }
        return true;
    }

    public static boolean canLoadmore(View targetView, MotionEvent event) {
        if (!ScrollBoundaryUtil.canScrollDown(targetView) && ScrollBoundaryUtil.canScrollUp(targetView)) {
            return true;
        }
        if (targetView instanceof ViewGroup && event != null) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView(viewGroup, child, event.getX(), event.getY(), point)) continue;
                event = MotionEvent.obtain((MotionEvent)event);
                event.offsetLocation(point.x, point.y);
                return ScrollBoundaryUtil.canLoadmore(child, event);
            }
        }
        return false;
    }

    public static boolean canScrollDown(View targetView, MotionEvent event) {
        if (ScrollBoundaryUtil.canScrollDown(targetView)) {
            return true;
        }
        if (targetView instanceof ViewGroup && event != null) {
            ViewGroup viewGroup = (ViewGroup)targetView;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView(viewGroup, child, event.getX(), event.getY(), point)) continue;
                event = MotionEvent.obtain((MotionEvent)event);
                event.offsetLocation(point.x, point.y);
                return ScrollBoundaryUtil.canScrollDown(child, event);
            }
        }
        return false;
    }

    public static boolean canScrollUp(View targetView) {
        if (Build.VERSION.SDK_INT < 14) {
            if (targetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)targetView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return targetView.getScrollY() > 0;
        }
        return targetView.canScrollVertically(-1);
    }

    public static boolean canScrollDown(View targetView) {
        if (Build.VERSION.SDK_INT < 14) {
            if (targetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)targetView;
                return absListView.getChildCount() > 0 && (absListView.getLastVisiblePosition() < absListView.getChildCount() - 1 || absListView.getChildAt(absListView.getChildCount() - 1).getBottom() > absListView.getPaddingBottom());
            }
            return targetView.getScrollY() < 0;
        }
        return targetView.canScrollVertically(1);
    }

    public static boolean pointInView(View view, float localX, float localY, float slop) {
        float left = -slop;
        float top = -slop;
        float width = view.getWidth();
        float height = view.getHeight();
        return localX >= left && localY >= top && localX < width + slop && localY < height + slop;
    }

    public static boolean isTransformedTouchPointInView(ViewGroup group, View child, float x, float y, PointF outLocalPoint) {
        float[] point = new float[]{x, y};
        ScrollBoundaryUtil.transformPointToViewLocal(group, child, point);
        boolean isInView = ScrollBoundaryUtil.pointInView(child, point[0], point[1], 0.0f);
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(point[0] - x, point[1] - y);
        }
        return isInView;
    }

    public static void transformPointToViewLocal(ViewGroup group, View child, float[] point) {
        point[0] = point[0] + (float)(group.getScrollX() - child.getLeft());
        point[1] = point[1] + (float)(group.getScrollY() - child.getTop());
    }
}

