/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.internal.pathview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import com.scwang.smartrefresh.layout.internal.pathview.PathParser;
import java.util.ArrayList;
import java.util.List;

public class PathsDrawable
extends Drawable {
    protected Paint mPaint = new Paint();
    protected List<Path> mPaths;
    protected List<Integer> mColors;
    protected int mWidth = 1;
    protected int mHeight = 1;
    protected int mStartX = 0;
    protected int mStartY = 0;
    protected int mOrginWidth;
    protected int mOrginHeight;
    protected static final Region REGION = new Region();
    protected static final Region MAX_CLIP = new Region(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected List<Path> mOrginPaths;
    protected List<String> mOrginSvgs;
    private Bitmap mCachedBitmap;
    private boolean mCacheDirty;

    public PathsDrawable() {
        this.mPaint.setColor(-15614977);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    protected void onMeasure() {
        Integer top = null;
        Integer left = null;
        Integer right = null;
        Integer bottom = null;
        if (this.mPaths != null) {
            for (Path path : this.mPaths) {
                REGION.setPath(path, MAX_CLIP);
                Rect bounds = REGION.getBounds();
                top = Math.min(top == null ? bounds.top : top, bounds.top);
                left = Math.min(left == null ? bounds.left : left, bounds.left);
                right = Math.max(right == null ? bounds.right : right, bounds.right);
                bottom = Math.max(bottom == null ? bounds.bottom : bottom, bounds.bottom);
            }
        }
        this.mStartX = left == null ? 0 : left;
        this.mStartY = top == null ? 0 : top;
        this.mWidth = right == null ? 0 : right - this.mStartX;
        int n = this.mHeight = bottom == null ? 0 : bottom - this.mStartY;
        if (this.mOrginWidth == 0) {
            this.mOrginWidth = this.mWidth;
        }
        if (this.mOrginHeight == 0) {
            this.mOrginHeight = this.mHeight;
        }
        Rect bounds = this.getBounds();
        super.setBounds(bounds.left, bounds.top, bounds.left + this.mWidth, bounds.top + this.mHeight);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        if (this.mOrginPaths != null && this.mOrginPaths.size() > 0 && (width != this.mWidth || height != this.mHeight)) {
            float ratioWidth = 1.0f * (float)width / (float)this.mOrginWidth;
            float ratioHeight = 1.0f * (float)height / (float)this.mOrginHeight;
            this.mPaths = PathParser.transformScale(ratioWidth, ratioHeight, this.mOrginPaths, this.mOrginSvgs);
            this.onMeasure();
        } else {
            super.setBounds(left, top, right, bottom);
        }
    }

    public void setBounds(@NonNull Rect bounds) {
        this.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void parserPaths(String ... paths) {
        this.mOrginHeight = 0;
        this.mOrginWidth = 0;
        this.mOrginSvgs = new ArrayList<String>();
        this.mOrginPaths = new ArrayList<Path>();
        this.mPaths = this.mOrginPaths;
        for (String path : paths) {
            this.mOrginSvgs.add(path);
            this.mOrginPaths.add(PathParser.createPathFromPathData(path));
        }
        this.onMeasure();
    }

    public void parserColors(int ... colors) {
        this.mColors = new ArrayList<Integer>();
        for (int color : colors) {
            this.mColors.add(color);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        if (this.mPaint.getAlpha() == 255) {
            canvas.save();
            canvas.translate((float)(bounds.left - this.mStartX), (float)(bounds.top - this.mStartY));
            if (this.mPaths != null) {
                for (int i = 0; i < this.mPaths.size(); ++i) {
                    if (this.mColors != null && i < this.mColors.size()) {
                        this.mPaint.setColor(this.mColors.get(i).intValue());
                    }
                    canvas.drawPath(this.mPaths.get(i), this.mPaint);
                }
                this.mPaint.setAlpha(255);
            }
            canvas.restore();
        } else {
            this.createCachedBitmapIfNeeded(width, height);
            if (!this.canReuseCache()) {
                this.updateCachedBitmap(width, height);
                this.updateCacheStates();
            }
            canvas.drawBitmap(this.mCachedBitmap, (float)bounds.left, (float)bounds.top, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int width() {
        return this.getBounds().width();
    }

    public int height() {
        return this.getBounds().height();
    }

    public void setGeometricWidth(int width) {
        Rect bounds = this.getBounds();
        float rate = 1.0f * (float)width / (float)bounds.width();
        this.setBounds((int)((float)bounds.left * rate), (int)((float)bounds.top * rate), (int)((float)bounds.right * rate), (int)((float)bounds.bottom * rate));
    }

    public void setGeometricHeight(int height) {
        Rect bounds = this.getBounds();
        float rate = 1.0f * (float)height / (float)bounds.height();
        this.setBounds((int)((float)bounds.left * rate), (int)((float)bounds.top * rate), (int)((float)bounds.right * rate), (int)((float)bounds.bottom * rate));
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void updateCachedBitmap(int width, int height) {
        this.mCachedBitmap.eraseColor(0);
        Canvas tmpCanvas = new Canvas(this.mCachedBitmap);
        this.drawCachedBitmap(tmpCanvas);
    }

    private void drawCachedBitmap(Canvas canvas) {
        canvas.translate((float)(-this.mStartX), (float)(-this.mStartY));
        if (this.mPaths != null) {
            for (int i = 0; i < this.mPaths.size(); ++i) {
                if (this.mColors != null && i < this.mColors.size()) {
                    this.mPaint.setColor(this.mColors.get(i).intValue());
                }
                canvas.drawPath(this.mPaths.get(i), this.mPaint);
            }
        }
    }

    public void createCachedBitmapIfNeeded(int width, int height) {
        if (this.mCachedBitmap == null || !this.canReuseBitmap(width, height)) {
            this.mCachedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCacheDirty = true;
        }
    }

    public boolean canReuseBitmap(int width, int height) {
        return width == this.mCachedBitmap.getWidth() && height == this.mCachedBitmap.getHeight();
    }

    public boolean canReuseCache() {
        return !this.mCacheDirty;
    }

    public void updateCacheStates() {
        this.mCacheDirty = false;
    }
}

