/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.internal;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.animation.LinearInterpolator;

public class ProgressDrawable
extends Drawable
implements Animatable {
    private int mProgressDegree = 0;
    private ValueAnimator mValueAnimator;
    private Path mPath = new Path();
    private Paint mPaint = new Paint();

    public ProgressDrawable() {
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-5592406);
        this.setupAnimators();
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        canvas.save();
        canvas.rotate((float)this.mProgressDegree, (float)(width / 2), (float)(height / 2));
        int r = Math.max(1, width / 20);
        for (int i = 0; i < 12; ++i) {
            this.mPath.reset();
            this.mPath.addCircle((float)(width - r), (float)(height / 2), (float)r, Path.Direction.CW);
            this.mPath.addRect((float)(width - 5 * r), (float)(height / 2 - r), (float)(width - r), (float)(height / 2 + r), Path.Direction.CW);
            this.mPath.addCircle((float)(width - 5 * r), (float)(height / 2), (float)r, Path.Direction.CW);
            this.mPaint.setAlpha((i + 5) * 17);
            canvas.rotate(30.0f, (float)(width / 2), (float)(height / 2));
            canvas.drawPath(this.mPath, this.mPaint);
        }
        canvas.restore();
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    private void setupAnimators() {
        this.mValueAnimator = ValueAnimator.ofInt((int[])new int[]{30, 3600});
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                ProgressDrawable.this.mProgressDegree = 30 * (value / 30);
                ProgressDrawable.this.invalidateSelf();
            }
        });
        this.mValueAnimator.setDuration(10000L);
        this.mValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mValueAnimator.setRepeatCount(-1);
        this.mValueAnimator.setRepeatMode(1);
    }

    public void start() {
        if (!this.mValueAnimator.isRunning()) {
            this.mValueAnimator.start();
        }
    }

    public void stop() {
        if (this.mValueAnimator.isRunning()) {
            this.mValueAnimator.cancel();
        }
    }

    public boolean isRunning() {
        return this.mValueAnimator.isRunning();
    }

    public int width() {
        return this.getBounds().width();
    }

    public int height() {
        return this.getBounds().height();
    }
}

