/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.view.MotionEvent;
import android.view.View;
import com.scwang.smartrefresh.layout.api.RefreshScrollBoundary;
import com.scwang.smartrefresh.layout.util.ScrollBoundaryUtil;

public class RefreshScrollBoundaryAdapter
implements RefreshScrollBoundary {
    protected MotionEvent mActionEvent;
    protected RefreshScrollBoundary boundary;
    protected boolean mEnableLoadmoreWhenContentNotFull;

    void setRefreshScrollBoundary(RefreshScrollBoundary boundary) {
        this.boundary = boundary;
    }

    void setActionEvent(MotionEvent event) {
        this.mActionEvent = event;
    }

    @Override
    public boolean canRefresh(View content) {
        if (this.boundary != null) {
            return this.boundary.canRefresh(content);
        }
        return ScrollBoundaryUtil.canRefresh(content, this.mActionEvent);
    }

    @Override
    public boolean canLoadmore(View content) {
        if (this.boundary != null) {
            return this.boundary.canLoadmore(content);
        }
        if (this.mEnableLoadmoreWhenContentNotFull) {
            return !ScrollBoundaryUtil.canScrollDown(content, this.mActionEvent);
        }
        return ScrollBoundaryUtil.canLoadmore(content, this.mActionEvent);
    }

    public void setEnableLoadmoreWhenContentNotFull(boolean enable) {
        this.mEnableLoadmoreWhenContentNotFull = enable;
    }
}

