/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;

public class RefreshFooterWrapper
implements RefreshFooter {
    private static final String TAG_REFRESH_FOOTER_WRAPPER = "TAG_REFRESH_FOOTER_WRAPPER";
    private View mWrapperView;
    private SpinnerStyle mSpinnerStyle;

    public RefreshFooterWrapper(View wrapper) {
        this.mWrapperView = wrapper;
        this.mWrapperView.setTag(TAG_REFRESH_FOOTER_WRAPPER.hashCode(), (Object)TAG_REFRESH_FOOTER_WRAPPER);
    }

    public static boolean isTagedFooter(View view) {
        return TAG_REFRESH_FOOTER_WRAPPER.equals(view.getTag(TAG_REFRESH_FOOTER_WRAPPER.hashCode()));
    }

    @Override
    @NonNull
    public View getView() {
        return this.mWrapperView;
    }

    @Override
    public int onFinish(RefreshLayout layout2, boolean success) {
        return 0;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        if (this.mSpinnerStyle != null) {
            return this.mSpinnerStyle;
        }
        ViewGroup.LayoutParams params = this.mWrapperView.getLayoutParams();
        if (params instanceof SmartRefreshLayout.LayoutParams) {
            this.mSpinnerStyle = ((SmartRefreshLayout.LayoutParams)params).spinnerStyle;
            if (this.mSpinnerStyle != null) {
                return this.mSpinnerStyle;
            }
        }
        if (params != null && params.height == 0) {
            this.mSpinnerStyle = SpinnerStyle.Scale;
            return this.mSpinnerStyle;
        }
        this.mSpinnerStyle = SpinnerStyle.Translate;
        return this.mSpinnerStyle;
    }

    @Override
    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
        ViewGroup.LayoutParams params = this.mWrapperView.getLayoutParams();
        if (params instanceof SmartRefreshLayout.LayoutParams) {
            kernel.requestDrawBackgoundForFooter(((SmartRefreshLayout.LayoutParams)params).backgroundColor);
        }
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPullingUp(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onPullReleasing(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onStartAnimator(RefreshLayout layout2, int footerHeight, int extendHeight) {
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
    }

    @Override
    public boolean setLoadmoreFinished(boolean finished) {
        return false;
    }
}

