/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.animation.ValueAnimator;
import android.content.Context;
import android.database.DataSetObserver;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.PagerAdapterWrapper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.ListViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.Space;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.ScrollView;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshScrollBoundary;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.impl.RefreshScrollBoundaryAdapter;
import com.scwang.smartrefresh.layout.util.ScrollBoundaryUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;

public class RefreshContentWrapper
implements RefreshContent {
    protected static final String TAG_REFRESH_CONTENT_WRAPPER = "TAG_REFRESH_CONTENT_WRAPPER";
    private static final String TAG = "RefreshContentWrapper";
    protected int mHeaderHeight = Integer.MAX_VALUE;
    protected int mFooterHeight = this.mHeaderHeight - 1;
    protected View mContentView;
    protected View mRealContentView;
    protected View mScrollableView;
    protected View mFixedHeader;
    protected View mFixedFooter;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableLoadmore = true;
    protected MotionEvent mMotionEvent;
    protected RefreshScrollBoundaryAdapter mBoundaryAdapter = new RefreshScrollBoundaryAdapter();

    public RefreshContentWrapper(View view) {
        this.mContentView = this.mRealContentView = view;
        this.mContentView.setTag(TAG_REFRESH_CONTENT_WRAPPER.hashCode(), (Object)TAG_REFRESH_CONTENT_WRAPPER);
    }

    public RefreshContentWrapper(Context context) {
        this.mContentView = this.mRealContentView = new View(context);
        this.mContentView.setTag(TAG_REFRESH_CONTENT_WRAPPER.hashCode(), (Object)TAG_REFRESH_CONTENT_WRAPPER);
    }

    public static boolean isTagedContent(View view) {
        return TAG_REFRESH_CONTENT_WRAPPER.equals(view.getTag(TAG_REFRESH_CONTENT_WRAPPER.hashCode()));
    }

    protected static int measureViewHeight(View view) {
        ViewGroup.LayoutParams p = view.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int childHeightSpec = p.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)p.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(childWidthSpec, childHeightSpec);
        return view.getMeasuredHeight();
    }

    protected void findScrollableView(View content, RefreshKernel kernel) {
        this.mScrollableView = this.findScrollableViewInternal(content, true);
        try {
            if (this.mScrollableView instanceof ViewPager) {
                this.wrapperViewPager((ViewPager)this.mScrollableView);
            }
        }
        catch (Exception ignored) {
            Log.e((String)TAG, (String)ignored.getMessage());
        }
        if (this.mScrollableView instanceof NestedScrollingParent && !(this.mScrollableView instanceof NestedScrollingChild)) {
            this.mScrollableView = this.findScrollableViewInternal(this.mScrollableView, false);
        }
        if (this.mScrollableView == null) {
            this.mScrollableView = content;
        }
    }

    protected void wrapperViewPager(ViewPager viewPager) {
        this.wrapperViewPager(viewPager, null);
    }

    protected void wrapperViewPager(final ViewPager viewPager, final PagerPrimaryAdapter primaryAdapter) {
        viewPager.post(new Runnable(){
            int count = 0;
            PagerPrimaryAdapter mAdapter = primaryAdapter;

            @Override
            public void run() {
                ++this.count;
                PagerAdapter adapter = viewPager.getAdapter();
                if (adapter != null) {
                    if (adapter instanceof PagerPrimaryAdapter) {
                        if (adapter == primaryAdapter && this.count < 10) {
                            viewPager.postDelayed((Runnable)this, 500L);
                        }
                    } else {
                        if (this.mAdapter == null) {
                            this.mAdapter = new PagerPrimaryAdapter(adapter);
                        } else {
                            this.mAdapter.wrapper(adapter);
                        }
                        this.mAdapter.attachViewPager(viewPager);
                    }
                } else if (this.count < 10) {
                    viewPager.postDelayed((Runnable)this, 500L);
                }
            }
        });
    }

    protected View findScrollableViewInternal(View content, boolean selfable) {
        View scrollableView = null;
        LinkedBlockingQueue<View> views = new LinkedBlockingQueue<View>(Collections.singletonList(content));
        while (!views.isEmpty() && scrollableView == null) {
            View view = (View)views.poll();
            if (view == null) continue;
            if ((selfable || view != content) && (view instanceof AbsListView || view instanceof ScrollView || view instanceof ScrollingView || view instanceof NestedScrollingChild || view instanceof NestedScrollingParent || view instanceof WebView || view instanceof ViewPager)) {
                scrollableView = view;
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup group = (ViewGroup)view;
            for (int j = 0; j < group.getChildCount(); ++j) {
                views.add(group.getChildAt(j));
            }
        }
        return scrollableView;
    }

    @Override
    @NonNull
    public View getView() {
        return this.mContentView;
    }

    @Override
    public void moveSpinner(int spinner) {
        this.mRealContentView.setTranslationY((float)spinner);
        if (this.mFixedHeader != null) {
            this.mFixedHeader.setTranslationY((float)Math.max(0, spinner));
        }
        if (this.mFixedFooter != null) {
            this.mFixedFooter.setTranslationY((float)Math.min(0, spinner));
        }
    }

    @Override
    public boolean canRefresh() {
        return this.mEnableRefresh && this.mBoundaryAdapter.canRefresh(this.mContentView);
    }

    @Override
    public boolean canLoadmore() {
        return this.mEnableLoadmore && this.mBoundaryAdapter.canLoadmore(this.mContentView);
    }

    @Override
    public void measure(int widthSpec, int heightSpec) {
        this.mContentView.measure(widthSpec, heightSpec);
    }

    @Override
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mContentView.getLayoutParams();
    }

    @Override
    public int getMeasuredWidth() {
        return this.mContentView.getMeasuredWidth();
    }

    @Override
    public int getMeasuredHeight() {
        return this.mContentView.getMeasuredHeight();
    }

    @Override
    public void layout(int left, int top, int right, int bottom) {
        this.mContentView.layout(left, top, right, bottom);
    }

    @Override
    public View getScrollableView() {
        return this.mScrollableView;
    }

    @Override
    public void onActionDown(MotionEvent e) {
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)e);
        this.mMotionEvent.offsetLocation((float)(-this.mContentView.getLeft()), (float)(-this.mContentView.getTop()));
        this.mBoundaryAdapter.setActionEvent(this.mMotionEvent);
    }

    @Override
    public void onActionUpOrCancel() {
        this.mMotionEvent = null;
        this.mBoundaryAdapter.setActionEvent(null);
    }

    @Override
    public void setupComponent(RefreshKernel kernel, View fixedHeader, View fixedFooter) {
        Object component;
        this.findScrollableView(this.mContentView, kernel);
        try {
            if (this.mScrollableView instanceof RecyclerView) {
                component = new RecyclerViewScrollComponent(kernel);
                ((RecyclerViewScrollComponent)((Object)component)).attach((RecyclerView)this.mScrollableView);
            }
        }
        catch (Throwable ignored) {
            Log.e((String)TAG, (String)ignored.getMessage());
        }
        try {
            if (this.mScrollableView instanceof NestedScrollView) {
                component = new NestedScrollViewScrollComponent(kernel);
                ((NestedScrollViewScrollComponent)component).attach((NestedScrollView)this.mScrollableView);
            }
        }
        catch (Throwable ignored) {
            Log.e((String)TAG, (String)ignored.getMessage());
        }
        if (this.mScrollableView instanceof AbsListView) {
            component = new AbsListViewScrollComponent(kernel);
            ((AbsListViewScrollComponent)component).attach((AbsListView)this.mScrollableView);
        }
        if (fixedHeader != null || fixedFooter != null) {
            int index;
            ViewGroup parent;
            ViewGroup.LayoutParams lp;
            this.mFixedHeader = fixedHeader;
            this.mFixedFooter = fixedFooter;
            FrameLayout frameLayout = new FrameLayout(this.mContentView.getContext());
            kernel.getRefreshLayout().getLayout().removeView(this.mContentView);
            ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
            frameLayout.addView(this.mContentView, -1, -1);
            kernel.getRefreshLayout().getLayout().addView((View)frameLayout, layoutParams);
            this.mContentView = frameLayout;
            if (fixedHeader != null) {
                fixedHeader.setClickable(true);
                lp = fixedHeader.getLayoutParams();
                parent = (ViewGroup)fixedHeader.getParent();
                index = parent.indexOfChild(fixedHeader);
                parent.removeView(fixedHeader);
                lp.height = RefreshContentWrapper.measureViewHeight(fixedHeader);
                parent.addView((View)new Space(this.mContentView.getContext()), index, lp);
                frameLayout.addView(fixedHeader);
            }
            if (fixedFooter != null) {
                fixedFooter.setClickable(true);
                lp = fixedFooter.getLayoutParams();
                parent = (ViewGroup)fixedFooter.getParent();
                index = parent.indexOfChild(fixedFooter);
                parent.removeView(fixedFooter);
                FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(lp);
                lp.height = RefreshContentWrapper.measureViewHeight(fixedFooter);
                parent.addView((View)new Space(this.mContentView.getContext()), index, lp);
                flp.gravity = 80;
                frameLayout.addView(fixedFooter, (ViewGroup.LayoutParams)flp);
            }
        }
    }

    @Override
    public void onInitialHeaderAndFooter(int headerHeight, int footerHeight) {
        this.mHeaderHeight = headerHeight;
        this.mFooterHeight = footerHeight;
    }

    @Override
    public void setRefreshScrollBoundary(RefreshScrollBoundary boundary) {
        if (boundary instanceof RefreshScrollBoundaryAdapter) {
            this.mBoundaryAdapter = (RefreshScrollBoundaryAdapter)boundary;
        } else {
            this.mBoundaryAdapter.setRefreshScrollBoundary(boundary);
        }
    }

    @Override
    public void setEnableLoadmoreWhenContentNotFull(boolean enable) {
        this.mBoundaryAdapter.setEnableLoadmoreWhenContentNotFull(enable);
    }

    @Override
    public ValueAnimator.AnimatorUpdateListener onLoadingFinish(final RefreshKernel kernel, final int footerHeight, int startDelay, final int duration) {
        if (this.mScrollableView != null && kernel.getRefreshLayout().isEnableScrollContentWhenLoaded()) {
            if (!ScrollBoundaryUtil.canScrollDown(this.mScrollableView)) {
                return null;
            }
            if (this.mScrollableView instanceof AbsListView && !(this.mScrollableView instanceof ListView) && Build.VERSION.SDK_INT < 19) {
                if (startDelay > 0) {
                    kernel.getRefreshLayout().getLayout().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((AbsListView)RefreshContentWrapper.this.mScrollableView).smoothScrollBy(footerHeight, duration);
                        }
                    }, (long)startDelay);
                } else {
                    ((AbsListView)this.mScrollableView).smoothScrollBy(footerHeight, duration);
                }
                return null;
            }
            return new ValueAnimator.AnimatorUpdateListener(){
                int lastValue;
                {
                    this.lastValue = kernel.getSpinner();
                }

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (RefreshContentWrapper.this.mScrollableView instanceof ListView) {
                        ListViewCompat.scrollListBy((ListView)((ListView)RefreshContentWrapper.this.mScrollableView), (int)(value - this.lastValue));
                    } else {
                        RefreshContentWrapper.this.mScrollableView.scrollBy(0, value - this.lastValue);
                    }
                    this.lastValue = value;
                }
            };
        }
        return null;
    }

    protected class PagerPrimaryAdapter
    extends PagerAdapterWrapper {
        protected ViewPager mViewPager;

        PagerPrimaryAdapter(PagerAdapter wrapped) {
            super(wrapped);
        }

        void wrapper(PagerAdapter adapter) {
            this.wrapped = adapter;
        }

        @Override
        public void attachViewPager(ViewPager viewPager) {
            this.mViewPager = viewPager;
            super.attachViewPager(viewPager);
        }

        @Override
        public void setViewPagerObserver(DataSetObserver observer) {
            super.setViewPagerObserver(observer);
            if (observer == null) {
                RefreshContentWrapper.this.wrapperViewPager(this.mViewPager, this);
            }
        }

        @Override
        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            super.setPrimaryItem(container, position, object);
            if (object instanceof View) {
                RefreshContentWrapper.this.mScrollableView = (View)object;
            } else if (object instanceof Fragment) {
                RefreshContentWrapper.this.mScrollableView = ((Fragment)object).getView();
            }
            if (RefreshContentWrapper.this.mScrollableView != null) {
                RefreshContentWrapper.this.mScrollableView = RefreshContentWrapper.this.findScrollableViewInternal(RefreshContentWrapper.this.mScrollableView, true);
                if (RefreshContentWrapper.this.mScrollableView instanceof NestedScrollingParent && !(RefreshContentWrapper.this.mScrollableView instanceof NestedScrollingChild)) {
                    RefreshContentWrapper.this.mScrollableView = RefreshContentWrapper.this.findScrollableViewInternal(RefreshContentWrapper.this.mScrollableView, false);
                }
            }
        }
    }

    protected class RecyclerViewScrollComponent
    extends RecyclerView.OnScrollListener {
        RefreshKernel kernel;

        RecyclerViewScrollComponent(RefreshKernel kernel) {
            this.kernel = kernel;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (RefreshContentWrapper.this.mMotionEvent == null) {
                RefreshLayout layout2 = this.kernel.getRefreshLayout();
                if (dy < 0 && layout2.isEnableRefresh() && (layout2.isEnableOverScrollBounce() || layout2.isRefreshing()) && !ScrollBoundaryUtil.canScrollUp((View)recyclerView)) {
                    this.kernel.animSpinnerBounce(Math.min(-dy * 2, RefreshContentWrapper.this.mHeaderHeight));
                } else if (dy > 0 && layout2.isEnableLoadmore() && !ScrollBoundaryUtil.canScrollDown((View)recyclerView)) {
                    if (layout2.getState() == RefreshState.None && layout2.isEnableAutoLoadmore() && !layout2.isLoadmoreFinished()) {
                        layout2.autoLoadmore(0, 1.0f);
                    } else if (layout2.isEnableOverScrollBounce() || layout2.isLoading()) {
                        this.kernel.animSpinnerBounce(Math.max(-dy * 2, -RefreshContentWrapper.this.mFooterHeight));
                    }
                }
            }
        }

        void attach(RecyclerView recyclerView) {
            recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        }
    }

    protected class AbsListViewScrollComponent
    implements AbsListView.OnScrollListener {
        int scrollY;
        int scrollDy;
        int lastScrolly;
        int lastScrollDy;
        RefreshKernel kernel;
        SparseArray<ItemRecod> recordSp = new SparseArray(0);
        AbsListView.OnScrollListener mScrollListener;

        AbsListViewScrollComponent(RefreshKernel kernel) {
            this.kernel = kernel;
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (this.mScrollListener != null) {
                this.mScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (this.mScrollListener != null) {
                this.mScrollListener.onScroll(absListView, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            this.lastScrolly = this.scrollY;
            this.lastScrollDy = this.scrollDy;
            this.scrollY = this.getScrollY(absListView, firstVisibleItem);
            this.scrollDy = this.lastScrolly - this.scrollY;
            int dy = this.lastScrollDy + this.scrollDy;
            if (totalItemCount > 0 && RefreshContentWrapper.this.mMotionEvent == null) {
                int lastVisiblePosition;
                RefreshLayout layout2 = this.kernel.getRefreshLayout();
                if (dy > 0) {
                    if (firstVisibleItem == 0 && layout2.isEnableRefresh() && (layout2.isEnableOverScrollBounce() || layout2.isRefreshing()) && !ScrollBoundaryUtil.canScrollUp((View)absListView)) {
                        this.kernel.animSpinnerBounce(Math.min(dy, RefreshContentWrapper.this.mHeaderHeight));
                    }
                } else if (dy < 0 && (lastVisiblePosition = absListView.getLastVisiblePosition()) == totalItemCount - 1 && lastVisiblePosition > 0 && layout2.isEnableLoadmore() && !ScrollBoundaryUtil.canScrollDown((View)absListView)) {
                    if (layout2.getState() == RefreshState.None && !layout2.isLoadmoreFinished() && layout2.isEnableAutoLoadmore()) {
                        layout2.autoLoadmore(0, 1.0f);
                    } else if (layout2.isEnableOverScrollBounce() || layout2.isLoading()) {
                        this.kernel.animSpinnerBounce(Math.max(dy, -RefreshContentWrapper.this.mFooterHeight));
                    }
                }
            }
        }

        void attach(AbsListView listView) {
            Field[] declaredFields = AbsListView.class.getDeclaredFields();
            if (declaredFields != null) {
                for (Field field : declaredFields) {
                    if (!AbsListView.OnScrollListener.class.equals(field.getType())) continue;
                    try {
                        field.setAccessible(true);
                        Object listener = field.get(listView);
                        if (listener == null || listView.equals(listener)) continue;
                        this.mScrollListener = (AbsListView.OnScrollListener)listener;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            listView.setOnScrollListener((AbsListView.OnScrollListener)this);
        }

        protected int getScrollY(AbsListView view, int firstVisibleItem) {
            View firstView = view.getChildAt(0);
            if (null != firstView) {
                ItemRecod itemRecord = (ItemRecod)this.recordSp.get(firstVisibleItem);
                if (null == itemRecord) {
                    itemRecord = new ItemRecod();
                }
                itemRecord.height = firstView.getHeight();
                itemRecord.top = firstView.getTop();
                this.recordSp.append(firstVisibleItem, (Object)itemRecord);
                int height = 0;
                int lastheight = 0;
                for (int i = 0; i < firstVisibleItem; ++i) {
                    ItemRecod itemRecod = (ItemRecod)this.recordSp.get(i);
                    if (itemRecod != null) {
                        height += itemRecod.height;
                        lastheight = itemRecod.height;
                        continue;
                    }
                    height += lastheight;
                }
                ItemRecod itemRecod = (ItemRecod)this.recordSp.get(firstVisibleItem);
                if (null == itemRecod) {
                    itemRecod = new ItemRecod();
                }
                return height - itemRecod.top;
            }
            return 0;
        }

        class ItemRecod {
            int height = 0;
            int top = 0;

            ItemRecod() {
            }
        }
    }

    protected class NestedScrollViewScrollComponent
    implements NestedScrollView.OnScrollChangeListener {
        long lastTime = 0L;
        long lastTimeOld = 0L;
        int lastScrollY = 0;
        int lastOldScrollY = 0;
        RefreshKernel kernel;
        NestedScrollView.OnScrollChangeListener mScrollChangeListener;

        NestedScrollViewScrollComponent(RefreshKernel kernel) {
            this.kernel = kernel;
        }

        public void onScrollChange(NestedScrollView scrollView, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
            boolean overScroll;
            if (this.mScrollChangeListener != null) {
                this.mScrollChangeListener.onScrollChange(scrollView, scrollX, scrollY, oldScrollX, oldScrollY);
            }
            if (this.lastScrollY == scrollY && this.lastOldScrollY == oldScrollY) {
                return;
            }
            RefreshLayout layout2 = this.kernel.getRefreshLayout();
            boolean bl = overScroll = layout2.isEnableOverScrollBounce() || layout2.isRefreshing() || layout2.isLoading();
            if (scrollY <= 0 && oldScrollY > 0 && RefreshContentWrapper.this.mMotionEvent == null && this.lastTime - this.lastTimeOld > 1000L && overScroll && layout2.isEnableRefresh()) {
                int velocity = (this.lastOldScrollY - oldScrollY) * 16000 / (int)((float)(this.lastTime - this.lastTimeOld) / 1000.0f);
                this.kernel.animSpinnerBounce(Math.min(velocity, RefreshContentWrapper.this.mHeaderHeight));
            } else if (oldScrollY < scrollY && RefreshContentWrapper.this.mMotionEvent == null && layout2.isEnableLoadmore()) {
                if (!layout2.isLoadmoreFinished() && layout2.isEnableAutoLoadmore() && layout2.getState() == RefreshState.None && !ScrollBoundaryUtil.canScrollDown((View)scrollView)) {
                    this.kernel.getRefreshLayout().autoLoadmore(0, 1.0f);
                } else if (overScroll && this.lastTime - this.lastTimeOld > 1000L && !ScrollBoundaryUtil.canScrollDown(RefreshContentWrapper.this.mScrollableView)) {
                    int velocity = (this.lastOldScrollY - oldScrollY) * 16000 / (int)((float)(this.lastTime - this.lastTimeOld) / 1000.0f);
                    this.kernel.animSpinnerBounce(Math.max(velocity, -RefreshContentWrapper.this.mFooterHeight));
                }
            }
            this.lastScrollY = scrollY;
            this.lastOldScrollY = oldScrollY;
            this.lastTimeOld = this.lastTime;
            this.lastTime = System.nanoTime();
        }

        void attach(NestedScrollView scrollView) {
            Field[] declaredFields = NestedScrollView.class.getDeclaredFields();
            if (declaredFields != null) {
                for (Field field : declaredFields) {
                    if (!NestedScrollView.OnScrollChangeListener.class.equals(field.getType())) continue;
                    try {
                        field.setAccessible(true);
                        Object listener = field.get(scrollView);
                        if (listener == null || scrollView.equals(listener)) continue;
                        this.mScrollChangeListener = (NestedScrollView.OnScrollChangeListener)listener;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            scrollView.setOnScrollChangeListener((NestedScrollView.OnScrollChangeListener)this);
        }
    }
}

