/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header.bezierradar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class RoundDotView
extends View {
    private int num = 7;
    private Paint mPath = new Paint();
    private float mRadius;
    private float fraction;

    public RoundDotView(Context context) {
        super(context);
        this.mPath.setAntiAlias(true);
        this.mPath.setColor(-1);
        this.mRadius = DensityUtil.dp2px(7.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(RoundDotView.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), RoundDotView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    public void setDotColor(int color) {
        this.mPath.setColor(color);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        float wide = (float)(width / this.num) * this.fraction - (this.fraction > 1.0f ? (this.fraction - 1.0f) * (float)(width / this.num) / this.fraction : 0.0f);
        float high = (float)height - (this.fraction > 1.0f ? (this.fraction - 1.0f) * (float)height / 2.0f / this.fraction : 0.0f);
        for (int i = 0; i < this.num; ++i) {
            float index = 1.0f + (float)i - (1.0f + (float)this.num) / 2.0f;
            float alpha = 255.0f * (1.0f - 2.0f * (Math.abs(index) / (float)this.num));
            float x = DensityUtil.px2dp(height);
            this.mPath.setAlpha((int)((double)alpha * (1.0 - 1.0 / Math.pow((double)x / 800.0 + 1.0, 15.0))));
            float radius = this.mRadius * (1.0f - 1.0f / (x / 10.0f + 1.0f));
            canvas.drawCircle((float)(width / 2) - radius / 2.0f + wide * index, high / 2.0f, radius, this.mPath);
        }
    }

    public void setFraction(float fraction) {
        this.fraction = fraction;
    }
}

