/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header.bezierradar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;

public class RippleView
extends View {
    private int mRadius;
    private Paint mPaint = new Paint();
    private ValueAnimator mAnimator;

    public RippleView(Context context) {
        super(context);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(RippleView.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), RippleView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    public void setFrontColor(int color) {
        this.mPaint.setColor(color);
    }

    public void startReveal() {
        if (this.mAnimator == null) {
            int bigRadius = (int)Math.sqrt(Math.pow(this.getHeight(), 2.0) + Math.pow(this.getWidth(), 2.0));
            this.mAnimator = ValueAnimator.ofInt((int[])new int[]{0, bigRadius});
            this.mAnimator.setDuration(400L);
            this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    RippleView.this.mRadius = (Integer)animation.getAnimatedValue();
                    RippleView.this.invalidate();
                }
            });
            this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                }
            });
        }
        this.mAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.mRadius, this.mPaint);
    }
}

