/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;

public class YYHeader
extends RelativeLayout
implements RefreshHeader {
    private ImageView yyView;

    public YYHeader(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public YYHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public YYHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.yy_header, (ViewGroup)this);
        this.yyView = (ImageView)view.findViewById(R.id.yy_header_view);
        this.yyView.setImageResource(R.drawable.pulling_animation_list);
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Translate;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
    }

    @Override
    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onStartAnimator(RefreshLayout layout2, int height, int extendHeight) {
        ((AnimationDrawable)this.yyView.getDrawable()).start();
    }

    @Override
    public int onFinish(RefreshLayout layout2, boolean success) {
        ((AnimationDrawable)this.yyView.getDrawable()).stop();
        return 500;
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        switch (newState) {
            case None: 
            case PullDownToRefresh: {
                this.yyView.setImageResource(R.drawable.pulling_animation_list);
                ((AnimationDrawable)this.yyView.getDrawable()).start();
                break;
            }
            case Refreshing: {
                ((AnimationDrawable)this.yyView.getDrawable()).stop();
                this.yyView.setImageResource(R.drawable.loading_animation_list);
                break;
            }
            case ReleaseToRefresh: {
                this.yyView.setImageResource(R.drawable.pulling_animation_list);
                ((AnimationDrawable)this.yyView.getDrawable()).start();
                break;
            }
        }
    }

    @Override
    public void onPullingDown(float percent, int offset, int headerHeight, int extendHeight) {
    }

    @Override
    public void onReleasing(float percent, int offset, int headerHeight, int extendHeight) {
    }
}

