/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ClassicsHeader
extends RelativeLayout
implements RefreshHeader {
    public static String REFRESH_HEADER_PULLDOWN = "\u4e0b\u62c9\u53ef\u4ee5\u5237\u65b0";
    public static String REFRESH_HEADER_REFRESHING = "\u6b63\u5728\u5237\u65b0...";
    public static String REFRESH_HEADER_LOADING = "\u6b63\u5728\u52a0\u8f7d...";
    public static String REFRESH_HEADER_RELEASE = "\u91ca\u653e\u7acb\u5373\u5237\u65b0";
    public static String REFRESH_HEADER_FINISH = "\u5237\u65b0\u5b8c\u6210";
    public static String REFRESH_HEADER_FAILED = "\u5237\u65b0\u5931\u8d25";
    public static final String COMMONREF_NAME = "ClassicsHeader";
    protected String mKeyLastUpdateTime = "LAST_UPDATE_TIME";
    protected Date mLastTime;
    protected TextView mHeaderText;
    protected TextView mLastUpdateText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected PathsDrawable mArrowDrawable;
    protected ProgressDrawable mProgressDrawable;
    protected DateFormat mFormat = new SimpleDateFormat("\u4e0a\u6b21\u66f4\u65b0 M-d HH:mm", Locale.CHINA);
    protected SpinnerStyle mSpinnerStyle = SpinnerStyle.Translate;
    protected SharedPreferences mShared;
    protected RefreshKernel mRefreshKernel;
    protected int mBackgroundColor;

    public ClassicsHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public ClassicsHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public ClassicsHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public ClassicsHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        DensityUtil density = new DensityUtil();
        this.setMinimumHeight(density.dip2px(80.0f));
        LinearLayout layout2 = new LinearLayout(context);
        layout2.setId(16908312);
        layout2.setGravity(1);
        layout2.setOrientation(1);
        this.mHeaderText = new TextView(context);
        this.mHeaderText.setText((CharSequence)REFRESH_HEADER_PULLDOWN);
        this.mHeaderText.setTextColor(-10066330);
        this.mHeaderText.setTextSize(16.0f);
        this.mLastUpdateText = new TextView(context);
        this.mLastUpdateText.setTextColor(-8618884);
        this.mLastUpdateText.setTextSize(12.0f);
        this.mLastUpdateText.setVisibility(8);
        LinearLayout.LayoutParams lpHeaderText = new LinearLayout.LayoutParams(-2, -2);
        layout2.addView((View)this.mHeaderText, (ViewGroup.LayoutParams)lpHeaderText);
        LinearLayout.LayoutParams lpUpdateText = new LinearLayout.LayoutParams(-2, -2);
        layout2.addView((View)this.mLastUpdateText, (ViewGroup.LayoutParams)lpUpdateText);
        RelativeLayout.LayoutParams lpHeaderLayout = new RelativeLayout.LayoutParams(-2, -2);
        lpHeaderLayout.addRule(13);
        this.addView((View)layout2, (ViewGroup.LayoutParams)lpHeaderLayout);
        this.mProgressView = new ImageView(context);
        this.mProgressView.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        RelativeLayout.LayoutParams lpProgress = new RelativeLayout.LayoutParams(density.dip2px(20.0f), density.dip2px(20.0f));
        lpProgress.rightMargin = density.dip2px(20.0f);
        lpProgress.addRule(15);
        lpProgress.addRule(0, 16908312);
        this.addView((View)this.mProgressView, (ViewGroup.LayoutParams)lpProgress);
        this.mArrowView = new ImageView(context);
        this.addView((View)this.mArrowView, (ViewGroup.LayoutParams)lpProgress);
        if (this.isInEditMode()) {
            this.mArrowView.setVisibility(8);
            this.mHeaderText.setText((CharSequence)REFRESH_HEADER_REFRESHING);
        } else {
            this.mProgressView.setVisibility(8);
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsHeader);
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.ClassicsHeader_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.ClassicsHeader_srlArrowDrawable)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlArrowDrawable));
        } else {
            this.mArrowDrawable = new PathsDrawable();
            this.mArrowDrawable.parserColors(-10066330);
            this.mArrowDrawable.parserPaths("M20,12l-1.41,-1.41L13,16.17V4h-2v12.17l-5.58,-5.59L4,12l8,8 8,-8z");
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlProgressDrawable)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlProgressDrawable));
        } else {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        int primaryColor = ta.getColor(R.styleable.ClassicsHeader_srlPrimaryColor, 0);
        int accentColor = ta.getColor(R.styleable.ClassicsHeader_srlAccentColor, 0);
        if (primaryColor != 0) {
            if (accentColor != 0) {
                this.setPrimaryColors(primaryColor, accentColor);
            } else {
                this.setPrimaryColors(primaryColor);
            }
        } else if (accentColor != 0) {
            this.setPrimaryColors(0, accentColor);
        }
        ta.recycle();
        try {
            List fragments;
            FragmentManager manager;
            if (context instanceof FragmentActivity && (manager = ((FragmentActivity)context).getSupportFragmentManager()) != null && (fragments = manager.getFragments()) != null && fragments.size() > 0) {
                this.setLastUpdateTime(new Date());
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.mKeyLastUpdateTime = this.mKeyLastUpdateTime + context.getClass().getName();
        if (this.getContext() != null) {
            this.mShared = this.getContext().getSharedPreferences(COMMONREF_NAME, 0);
        }
        this.setLastUpdateTime(new Date(this.mShared.getLong(this.mKeyLastUpdateTime, System.currentTimeMillis())));
    }

    @Override
    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgoundForHeader(this.mBackgroundColor);
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPullingDown(float percent, int offset, int headHeight, int extendHeight) {
    }

    @Override
    public void onReleasing(float percent, int offset, int headHeight, int extendHeight) {
    }

    @Override
    public void onStartAnimator(RefreshLayout layout2, int headHeight, int extendHeight) {
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.start();
        } else {
            this.mProgressView.animate().rotation(36000.0f).setDuration(100000L);
        }
    }

    @Override
    public int onFinish(RefreshLayout layout2, boolean success) {
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.stop();
        } else {
            this.mProgressView.animate().rotation(0.0f).setDuration(300L);
        }
        this.mProgressView.setVisibility(8);
        if (success) {
            this.mHeaderText.setText((CharSequence)REFRESH_HEADER_FINISH);
            this.setLastUpdateTime(new Date());
        } else {
            this.mHeaderText.setText((CharSequence)REFRESH_HEADER_FAILED);
        }
        return 500;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 1) {
            if (!(this.getBackground() instanceof BitmapDrawable)) {
                this.mBackgroundColor = colors[0];
                this.setBackgroundColor(this.mBackgroundColor);
                if (this.mRefreshKernel != null) {
                    this.mRefreshKernel.requestDrawBackgoundForHeader(colors[0]);
                }
            }
            if (this.mArrowDrawable != null) {
                this.mArrowDrawable.parserColors(colors[1]);
            }
            this.mHeaderText.setTextColor(colors[1]);
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.setColor(colors[1]);
            }
            this.mLastUpdateText.setTextColor(colors[1] & 0xFFFFFF | 0x99000000);
        } else if (colors.length > 0) {
            if (!(this.getBackground() instanceof BitmapDrawable)) {
                this.mBackgroundColor = colors[0];
                this.setBackgroundColor(this.mBackgroundColor);
                if (this.mRefreshKernel != null) {
                    this.mRefreshKernel.requestDrawBackgoundForHeader(colors[0]);
                }
            }
            if (colors[0] == -1) {
                if (this.mArrowDrawable != null) {
                    this.mArrowDrawable.parserColors(-10066330);
                }
                this.mHeaderText.setTextColor(-10066330);
                if (this.mProgressDrawable != null) {
                    this.mProgressDrawable.setColor(-10066330);
                }
                this.mLastUpdateText.setTextColor(-1721342362);
            } else {
                if (this.mArrowDrawable != null) {
                    this.mArrowDrawable.parserColors(-1);
                }
                this.mHeaderText.setTextColor(-1);
                if (this.mProgressDrawable != null) {
                    this.mProgressDrawable.setColor(-1);
                }
                this.mLastUpdateText.setTextColor(-1426063361);
            }
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        return this.mSpinnerStyle;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        switch (newState) {
            case None: 
            case PullDownToRefresh: {
                this.mHeaderText.setText((CharSequence)REFRESH_HEADER_PULLDOWN);
                this.mArrowView.setVisibility(0);
                this.mProgressView.setVisibility(8);
                this.mArrowView.animate().rotation(0.0f);
                break;
            }
            case Refreshing: {
                this.mHeaderText.setText((CharSequence)REFRESH_HEADER_REFRESHING);
                this.mProgressView.setVisibility(0);
                this.mArrowView.setVisibility(8);
                break;
            }
            case ReleaseToRefresh: {
                this.mHeaderText.setText((CharSequence)REFRESH_HEADER_RELEASE);
                this.mArrowView.animate().rotation(180.0f);
                break;
            }
            case Loading: {
                this.mArrowView.setVisibility(8);
                this.mProgressView.setVisibility(8);
                this.mHeaderText.setText((CharSequence)REFRESH_HEADER_LOADING);
                break;
            }
        }
    }

    public ClassicsHeader setProgressBitmap(Bitmap bitmap) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsHeader setProgressDrawable(Drawable drawable2) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable2);
        return this;
    }

    public ClassicsHeader setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this;
    }

    public ClassicsHeader setArrowBitmap(Bitmap bitmap) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsHeader setArrowDrawable(Drawable drawable2) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable2);
        return this;
    }

    public ClassicsHeader setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this;
    }

    public ClassicsHeader setLastUpdateTime(Date time) {
        this.mLastTime = time;
        this.mLastUpdateText.setText((CharSequence)this.mFormat.format(time));
        if (this.mShared != null && !this.isInEditMode()) {
            this.mShared.edit().putLong(this.mKeyLastUpdateTime, time.getTime()).apply();
        }
        return this;
    }

    public ClassicsHeader setTimeFormat(DateFormat format) {
        this.mFormat = format;
        this.mLastUpdateText.setText((CharSequence)this.mFormat.format(this.mLastTime));
        return this;
    }

    public ClassicsHeader setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this;
    }

    public ClassicsHeader setAccentColor(int accentColor) {
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.parserColors(accentColor);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
        }
        this.mHeaderText.setTextColor(accentColor);
        this.mLastUpdateText.setTextColor(accentColor & 0xFFFFFF | 0x99000000);
        return this;
    }
}

