/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer.ballpulse;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BallPulseView
extends View {
    public static final int DEFAULT_SIZE = 50;
    private Paint mPaint;
    private int normalColor = -1118482;
    private int animatingColor = -8960;
    private float circleSpacing;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    private boolean mIsStarted = false;
    private ArrayList<ValueAnimator> mAnimators;
    private Map<ValueAnimator, ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new HashMap<ValueAnimator, ValueAnimator.AnimatorUpdateListener>();

    public BallPulseView(Context context) {
        this(context, null);
    }

    public BallPulseView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BallPulseView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.circleSpacing = DensityUtil.dp2px(4.0f);
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int defaultSize = DensityUtil.dp2px(50.0f);
        this.setMeasuredDimension(BallPulseView.resolveSize((int)defaultSize, (int)widthMeasureSpec), BallPulseView.resolveSize((int)defaultSize, (int)heightMeasureSpec));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimators != null) {
            for (int i = 0; i < this.mAnimators.size(); ++i) {
                this.mAnimators.get(i).cancel();
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        float radius = ((float)Math.min(this.getWidth(), this.getHeight()) - this.circleSpacing * 2.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + this.circleSpacing);
        float y = this.getHeight() / 2;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + this.circleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
            canvas.restore();
        }
    }

    private boolean isStarted() {
        return this.mIsStarted;
    }

    private void createAnimators() {
        this.mAnimators = new ArrayList();
        int[] delays = new int[]{120, 240, 360};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            scaleAnim.setDuration(750L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            this.mUpdateListeners.put(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((BallPulseView)BallPulseView.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallPulseView.this.postInvalidate();
                }
            });
            this.mAnimators.add(scaleAnim);
        }
    }

    public void setIndicatorColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setNormalColor(@ColorInt int color) {
        this.normalColor = color;
    }

    public void setAnimatingColor(@ColorInt int color) {
        this.animatingColor = color;
    }

    public void startAnim() {
        if (this.mAnimators == null) {
            this.createAnimators();
        }
        if (this.mAnimators == null) {
            return;
        }
        if (this.isStarted()) {
            return;
        }
        for (int i = 0; i < this.mAnimators.size(); ++i) {
            ValueAnimator animator = this.mAnimators.get(i);
            ValueAnimator.AnimatorUpdateListener updateListener = this.mUpdateListeners.get(animator);
            if (updateListener != null) {
                animator.addUpdateListener(updateListener);
            }
            animator.start();
        }
        this.mIsStarted = true;
        this.setIndicatorColor(this.animatingColor);
    }

    public void stopAnim() {
        if (this.mAnimators != null && this.mIsStarted) {
            this.mIsStarted = false;
            for (ValueAnimator animator : this.mAnimators) {
                if (animator == null) continue;
                animator.removeAllUpdateListeners();
                animator.end();
            }
            this.scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
        }
        this.setIndicatorColor(this.normalColor);
    }
}

