/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class ClassicsFooter
extends RelativeLayout
implements RefreshFooter {
    public static String REFRESH_FOOTER_PULLUP = "\u4e0a\u62c9\u52a0\u8f7d\u66f4\u591a";
    public static String REFRESH_FOOTER_RELEASE = "\u91ca\u653e\u7acb\u5373\u52a0\u8f7d";
    public static String REFRESH_HEADER_REFRESHING = "\u6b63\u5728\u5237\u65b0...";
    public static String REFRESH_FOOTER_LOADING = "\u6b63\u5728\u52a0\u8f7d...";
    public static String REFRESH_FOOTER_FINISH = "\u52a0\u8f7d\u5b8c\u6210";
    public static String REFRESH_FOOTER_FAILED = "\u52a0\u8f7d\u5931\u8d25";
    public static String REFRESH_FOOTER_ALLLOADED = "\u5168\u90e8\u52a0\u8f7d\u5b8c\u6210";
    protected TextView mBottomText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected PathsDrawable mArrowDrawable;
    protected ProgressDrawable mProgressDrawable;
    protected SpinnerStyle mSpinnerStyle = SpinnerStyle.Translate;
    protected RefreshKernel mRefreshKernel;
    protected int mBackgroundColor = 0;
    protected boolean mLoadmoreFinished = false;

    public ClassicsFooter(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public ClassicsFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public ClassicsFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        DensityUtil density = new DensityUtil();
        this.setMinimumHeight(density.dip2px(60.0f));
        this.mBottomText = new TextView(context);
        this.mBottomText.setId(16908312);
        this.mBottomText.setTextColor(-10066330);
        this.mBottomText.setTextSize(16.0f);
        this.mBottomText.setText((CharSequence)REFRESH_FOOTER_PULLUP);
        RelativeLayout.LayoutParams lpBottomText = new RelativeLayout.LayoutParams(-2, -2);
        lpBottomText.addRule(13);
        this.addView((View)this.mBottomText, (ViewGroup.LayoutParams)lpBottomText);
        this.mProgressView = new ImageView(context);
        this.mProgressView.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        RelativeLayout.LayoutParams lpPathView = new RelativeLayout.LayoutParams(density.dip2px(18.0f), density.dip2px(18.0f));
        lpPathView.rightMargin = density.dip2px(20.0f);
        lpPathView.addRule(15);
        lpPathView.addRule(0, 16908312);
        this.addView((View)this.mProgressView, (ViewGroup.LayoutParams)lpPathView);
        this.mArrowView = new ImageView(context);
        this.addView((View)this.mArrowView, (ViewGroup.LayoutParams)lpPathView);
        if (!this.isInEditMode()) {
            this.mProgressView.setVisibility(8);
        } else {
            this.mArrowView.setVisibility(8);
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsFooter);
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.ClassicsFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.ClassicsFooter_srlArrowDrawable)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsFooter_srlArrowDrawable));
        } else {
            this.mArrowDrawable = new PathsDrawable();
            this.mArrowDrawable.parserColors(-10066330);
            this.mArrowDrawable.parserPaths("M20,12l-1.41,-1.41L13,16.17V4h-2v12.17l-5.58,-5.59L4,12l8,8 8,-8z");
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlProgressDrawable)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsFooter_srlProgressDrawable));
        } else {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.ClassicsFooter_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.ClassicsFooter_srlAccentColor, 0));
        }
        ta.recycle();
    }

    @Override
    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgoundForFooter(this.mBackgroundColor);
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPullingUp(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onPullReleasing(float percent, int offset, int headHeight, int extendHeight) {
    }

    @Override
    public void onStartAnimator(RefreshLayout layout2, int headHeight, int extendHeight) {
        if (!this.mLoadmoreFinished) {
            this.mProgressView.setVisibility(0);
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.start();
            } else {
                this.mProgressView.animate().rotation(36000.0f).setDuration(100000L);
            }
        }
    }

    @Override
    public int onFinish(RefreshLayout layout2, boolean success) {
        if (!this.mLoadmoreFinished) {
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.stop();
            } else {
                this.mProgressView.animate().rotation(0.0f).setDuration(300L);
            }
            this.mProgressView.setVisibility(8);
            if (success) {
                this.mBottomText.setText((CharSequence)REFRESH_FOOTER_FINISH);
            } else {
                this.mBottomText.setText((CharSequence)REFRESH_FOOTER_FAILED);
            }
            return 500;
        }
        return 0;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
        if (this.mSpinnerStyle == SpinnerStyle.FixedBehind) {
            if (colors.length > 1) {
                this.mBackgroundColor = colors[0];
                this.setBackgroundColor(this.mBackgroundColor);
                if (this.mRefreshKernel != null) {
                    this.mRefreshKernel.requestDrawBackgoundForFooter(this.mBackgroundColor);
                }
                this.mBottomText.setTextColor(colors[1]);
                if (this.mProgressDrawable != null) {
                    this.mProgressDrawable.setColor(colors[1]);
                }
                if (this.mArrowDrawable != null) {
                    this.mArrowDrawable.parserColors(colors[1]);
                }
            } else if (colors.length > 0) {
                this.mBackgroundColor = colors[0];
                this.setBackgroundColor(this.mBackgroundColor);
                if (this.mRefreshKernel != null) {
                    this.mRefreshKernel.requestDrawBackgoundForFooter(this.mBackgroundColor);
                }
                if (colors[0] == -1) {
                    this.mBottomText.setTextColor(-10066330);
                    if (this.mProgressDrawable != null) {
                        this.mProgressDrawable.setColor(-10066330);
                    }
                    if (this.mArrowDrawable != null) {
                        this.mArrowDrawable.parserColors(-10066330);
                    }
                } else {
                    this.mBottomText.setTextColor(-1);
                    if (this.mProgressDrawable != null) {
                        this.mProgressDrawable.setColor(-1);
                    }
                    if (this.mArrowDrawable != null) {
                        this.mArrowDrawable.parserColors(-1);
                    }
                }
            }
        }
    }

    @Override
    public boolean setLoadmoreFinished(boolean finished) {
        if (this.mLoadmoreFinished != finished) {
            this.mLoadmoreFinished = finished;
            if (finished) {
                this.mBottomText.setText((CharSequence)REFRESH_FOOTER_ALLLOADED);
            } else {
                this.mBottomText.setText((CharSequence)REFRESH_FOOTER_PULLUP);
            }
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.stop();
            } else {
                this.mProgressView.animate().rotation(0.0f).setDuration(300L);
            }
            this.mProgressView.setVisibility(8);
            this.mArrowView.setVisibility(8);
        }
        return true;
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        return this.mSpinnerStyle;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        if (!this.mLoadmoreFinished) {
            switch (newState) {
                case None: {
                    this.mArrowView.setVisibility(0);
                }
                case PullToUpLoad: {
                    this.mBottomText.setText((CharSequence)REFRESH_FOOTER_PULLUP);
                    this.mArrowView.animate().rotation(180.0f);
                    break;
                }
                case Loading: {
                    this.mArrowView.setVisibility(8);
                    this.mBottomText.setText((CharSequence)REFRESH_FOOTER_LOADING);
                    break;
                }
                case ReleaseToLoad: {
                    this.mBottomText.setText((CharSequence)REFRESH_FOOTER_RELEASE);
                    this.mArrowView.animate().rotation(0.0f);
                    break;
                }
                case Refreshing: {
                    this.mBottomText.setText((CharSequence)REFRESH_HEADER_REFRESHING);
                    this.mProgressView.setVisibility(8);
                    this.mArrowView.setVisibility(8);
                    break;
                }
            }
        }
    }

    public ClassicsFooter setProgressBitmap(Bitmap bitmap) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsFooter setProgressDrawable(Drawable drawable2) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable2);
        return this;
    }

    public ClassicsFooter setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this;
    }

    public ClassicsFooter setArrowBitmap(Bitmap bitmap) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsFooter setArrowDrawable(Drawable drawable2) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable2);
        return this;
    }

    public ClassicsFooter setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this;
    }

    public ClassicsFooter setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this;
    }

    public ClassicsFooter setAccentColor(int accentColor) {
        this.mBottomText.setTextColor(accentColor);
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
        }
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.parserColors(accentColor);
        }
        return this;
    }

    public ClassicsFooter setPrimaryColor(int primaryColor) {
        this.mBackgroundColor = primaryColor;
        this.setBackgroundColor(this.mBackgroundColor);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestDrawBackgoundForFooter(this.mBackgroundColor);
        }
        return this;
    }
}

