/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.footer.ballpulse.BallPulseView;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class BallPulseFooter
extends ViewGroup
implements RefreshFooter {
    private BallPulseView mBallPulseView;
    private SpinnerStyle mSpinnerStyle = SpinnerStyle.Translate;

    public BallPulseFooter(@NonNull Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mBallPulseView = new BallPulseView(context);
        this.addView(this.mBallPulseView, -2, -2);
        this.setMinimumHeight(DensityUtil.dp2px(60.0f));
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BallPulseFooter);
        int primaryColor = ta.getColor(R.styleable.BallPulseFooter_srlPrimaryColor, 0);
        int accentColor = ta.getColor(R.styleable.BallPulseFooter_srlAccentColor, 0);
        if (primaryColor != 0) {
            this.mBallPulseView.setNormalColor(primaryColor);
        }
        if (accentColor != 0) {
            this.mBallPulseView.setAnimatingColor(accentColor);
        }
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.BallPulseFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)Integer.MIN_VALUE);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)Integer.MIN_VALUE);
        this.mBallPulseView.measure(widthSpec, heightSpec);
        this.setMeasuredDimension(BallPulseFooter.resolveSize((int)this.mBallPulseView.getMeasuredWidth(), (int)widthMeasureSpec), BallPulseFooter.resolveSize((int)this.mBallPulseView.getMeasuredHeight(), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int pwidth = this.getMeasuredWidth();
        int pheight = this.getMeasuredHeight();
        int cwidth = this.mBallPulseView.getMeasuredWidth();
        int cheight = this.mBallPulseView.getMeasuredHeight();
        int left = pwidth / 2 - cwidth / 2;
        int top = pheight / 2 - cheight / 2;
        this.mBallPulseView.layout(left, top, left + cwidth, top + cheight);
    }

    @Override
    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPullingUp(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onPullReleasing(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onStartAnimator(RefreshLayout layout2, int footerHeight, int extendHeight) {
        this.mBallPulseView.startAnim();
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
    }

    @Override
    public int onFinish(RefreshLayout layout2, boolean success) {
        this.mBallPulseView.stopAnim();
        return 0;
    }

    @Override
    public boolean setLoadmoreFinished(boolean finished) {
        return false;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 1) {
            this.mBallPulseView.setNormalColor(colors[1]);
            this.mBallPulseView.setAnimatingColor(colors[0]);
        } else if (colors.length > 0) {
            this.mBallPulseView.setNormalColor(ColorUtils.compositeColors((int)-1711276033, (int)colors[0]));
            this.mBallPulseView.setAnimatingColor(colors[0]);
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        return this.mSpinnerStyle;
    }

    public BallPulseFooter setSpinnerStyle(SpinnerStyle mSpinnerStyle) {
        this.mSpinnerStyle = mSpinnerStyle;
        return this;
    }
}

