/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ScrollView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.DefaultRefreshFooterCreater;
import com.scwang.smartrefresh.layout.api.DefaultRefreshHeaderCreater;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshScrollBoundary;
import com.scwang.smartrefresh.layout.constant.DimensionStatus;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.footer.BallPulseFooter;
import com.scwang.smartrefresh.layout.header.FalsifyHeader;
import com.scwang.smartrefresh.layout.header.YYHeader;
import com.scwang.smartrefresh.layout.impl.RefreshContentWrapper;
import com.scwang.smartrefresh.layout.impl.RefreshFooterWrapper;
import com.scwang.smartrefresh.layout.impl.RefreshHeaderWrapper;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import com.scwang.smartrefresh.layout.listener.OnMultiPurposeListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadmoreListener;
import com.scwang.smartrefresh.layout.util.DelayedRunable;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import com.scwang.smartrefresh.layout.util.ViscousFluidInterpolator;
import java.util.ArrayList;
import java.util.List;

public class SmartRefreshLayout
extends ViewGroup
implements RefreshLayout {
    private static final String TAG = "SmartRefreshLayout";
    protected int mTouchSlop;
    protected int mSpinner;
    protected int mLastSpinner;
    protected int mTouchSpinner;
    protected int mReboundDuration = 250;
    protected int mDroppingDuration = 1000;
    protected int mScreenHeightPixels;
    protected float mTouchX;
    protected float mTouchY;
    protected float mLastTouchX;
    protected float mLastTouchY;
    protected float mDragRate = 0.5f;
    protected boolean mIsBeingDragged;
    protected Interpolator mReboundInterpolator;
    protected View mFixedHeaderView;
    protected View mFixedFooterView;
    protected int mFixedHeaderViewId;
    protected int mFixedFooterViewId;
    protected int[] mPrimaryColors;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableLoadmore = false;
    protected boolean mEnableDrop = false;
    protected boolean mEnableHeaderTranslationContent = true;
    protected boolean mEnableFooterTranslationContent = true;
    protected boolean mEnablePreviewInEditMode = true;
    protected boolean mEnableOverScrollBounce = true;
    protected boolean mEnableAutoLoadmore = true;
    protected boolean mEnablePureScrollMode = false;
    protected boolean mEnableScrollContentWhenLoaded = true;
    protected boolean mEnableLoadmoreWhenContentNotFull = false;
    protected boolean mDisableContentWhenRefresh = false;
    protected boolean mDisableContentWhenLoading = false;
    protected boolean mLoadmoreFinished = false;
    protected boolean mManualLoadmore = false;
    protected boolean mManualNestedScrolling = false;
    protected OnRefreshListener mRefreshListener;
    protected OnLoadmoreListener mLoadmoreListener;
    protected OnMultiPurposeListener mOnMultiPurposeListener;
    protected RefreshScrollBoundary mRefreshScrollBoundary;
    protected int[] mParentScrollConsumed = new int[2];
    protected int[] mParentOffsetInWindow = new int[2];
    protected int mTotalUnconsumed;
    protected boolean mNestedScrollInProgress;
    protected NestedScrollingChildHelper mNestedScrollingChildHelper;
    protected NestedScrollingParentHelper mNestedScrollingParentHelper;
    protected int mHeaderHeight;
    protected DimensionStatus mHeaderHeightStatus = DimensionStatus.DefaultUnNotify;
    protected int mFooterHeight;
    protected DimensionStatus mFooterHeightStatus = DimensionStatus.DefaultUnNotify;
    protected int mHeaderExtendHeight;
    protected int mFooterExtendHeight;
    protected float mHeaderMaxDragRate = 2.0f;
    protected float mFooterMaxDragRate = 3.0f;
    protected RefreshHeader mRefreshHeader;
    protected RefreshContent mRefreshContent;
    protected RefreshFooter mRefreshFooter;
    protected Paint mPaint;
    protected Handler handler;
    protected RefreshKernel mKernel;
    protected List<DelayedRunable> mDelayedRunables;
    protected RefreshState mState = RefreshState.None;
    protected RefreshState mViceState = RefreshState.None;
    protected long mLastLoadingTime = 0L;
    protected long mLastRefreshingTime = 0L;
    protected int mHeaderBackgroundColor = 0;
    protected int mFooterBackgroundColor = 0;
    protected boolean mHeaderNeedTouchEventWhenRefreshing;
    protected boolean mFooterNeedTouchEventWhenRefreshing;
    protected static boolean sManualFooterCreater = false;
    protected static DefaultRefreshFooterCreater sFooterCreater = new DefaultRefreshFooterCreater(){

        @Override
        @NonNull
        public RefreshFooter createRefreshFooter(Context context, RefreshLayout layout2) {
            return new BallPulseFooter(context);
        }
    };
    protected static DefaultRefreshHeaderCreater sHeaderCreater = new DefaultRefreshHeaderCreater(){

        @Override
        @NonNull
        public RefreshHeader createRefreshHeader(Context context, RefreshLayout layout2) {
            return new YYHeader(context);
        }
    };
    MotionEvent mFalsifyEvent = null;
    protected ValueAnimator reboundAnimator;
    protected Animator.AnimatorListener reboundAnimatorEndListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            SmartRefreshLayout.this.reboundAnimator = null;
            if ((Integer)((ValueAnimator)animation).getAnimatedValue() == 0 && SmartRefreshLayout.this.mState != RefreshState.None && SmartRefreshLayout.this.mState != RefreshState.Refreshing && SmartRefreshLayout.this.mState != RefreshState.Loading) {
                SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
            }
        }
    };
    protected ValueAnimator.AnimatorUpdateListener reboundUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            SmartRefreshLayout.this.moveSpinner((Integer)animation.getAnimatedValue(), true);
        }
    };

    public SmartRefreshLayout(Context context) {
        super(context);
        this.initView(context, null);
    }

    public SmartRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public SmartRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.setClipToPadding(false);
        this.mScreenHeightPixels = context.getResources().getDisplayMetrics().heightPixels;
        this.mReboundInterpolator = new ViscousFluidInterpolator();
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        DensityUtil density = new DensityUtil();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SmartRefreshLayout);
        ViewCompat.setNestedScrollingEnabled((View)this, (boolean)ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableNestedScrolling, false));
        this.mDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlDragRate, this.mDragRate);
        this.mHeaderMaxDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlHeaderMaxDragRate, this.mHeaderMaxDragRate);
        this.mFooterMaxDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlFooterMaxDragRate, this.mFooterMaxDragRate);
        this.mEnableRefresh = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableRefresh, this.mEnableRefresh);
        this.mReboundDuration = ta.getInt(R.styleable.SmartRefreshLayout_srlReboundDuration, this.mReboundDuration);
        this.mEnableLoadmore = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableLoadmore, this.mEnableLoadmore);
        this.mEnableDrop = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableDrop, this.mEnableDrop);
        this.mHeaderHeight = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlHeaderHeight, density.dip2px(100.0f));
        this.mFooterHeight = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlFooterHeight, density.dip2px(60.0f));
        this.mDisableContentWhenRefresh = ta.getBoolean(R.styleable.SmartRefreshLayout_srlDisableContentWhenRefresh, this.mDisableContentWhenRefresh);
        this.mDisableContentWhenLoading = ta.getBoolean(R.styleable.SmartRefreshLayout_srlDisableContentWhenLoading, this.mDisableContentWhenLoading);
        this.mEnableHeaderTranslationContent = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableHeaderTranslationContent, this.mEnableHeaderTranslationContent);
        this.mEnableFooterTranslationContent = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableFooterTranslationContent, this.mEnableFooterTranslationContent);
        this.mEnablePreviewInEditMode = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnablePreviewInEditMode, this.mEnablePreviewInEditMode);
        this.mEnableAutoLoadmore = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableAutoLoadmore, this.mEnableAutoLoadmore);
        this.mEnableOverScrollBounce = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableAutoLoadmore, this.mEnableOverScrollBounce);
        this.mEnablePureScrollMode = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnablePureScrollMode, this.mEnablePureScrollMode);
        this.mEnableScrollContentWhenLoaded = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableScrollContentWhenLoaded, this.mEnableScrollContentWhenLoaded);
        this.mEnableLoadmoreWhenContentNotFull = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableLoadmoreWhenContentNotFull, this.mEnableLoadmoreWhenContentNotFull);
        this.mFixedHeaderViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFixedHeaderViewId, -1);
        this.mFixedFooterViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFixedFooterViewId, -1);
        this.mManualLoadmore = ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableLoadmore);
        this.mManualNestedScrolling = ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableNestedScrolling);
        this.mHeaderHeightStatus = ta.hasValue(R.styleable.SmartRefreshLayout_srlHeaderHeight) ? DimensionStatus.XmlLayoutUnNotify : this.mHeaderHeightStatus;
        this.mFooterHeightStatus = ta.hasValue(R.styleable.SmartRefreshLayout_srlFooterHeight) ? DimensionStatus.XmlLayoutUnNotify : this.mFooterHeightStatus;
        this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
        this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
        int accentColor = ta.getColor(R.styleable.SmartRefreshLayout_srlAccentColor, 0);
        int primaryColor = ta.getColor(R.styleable.SmartRefreshLayout_srlPrimaryColor, 0);
        if (primaryColor != 0) {
            this.mPrimaryColors = accentColor != 0 ? new int[]{primaryColor, accentColor} : new int[]{primaryColor};
        }
        ta.recycle();
    }

    protected void onFinishInflate() {
        View view;
        int i;
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count > 3) {
            throw new RuntimeException("\u6700\u591a\u53ea\u652f\u63013\u4e2a\u5b50View\uff0cMost only support three sub view");
        }
        if (this.mEnablePureScrollMode && count > 1) {
            throw new RuntimeException("PureScrollMode\u6a21\u5f0f\u53ea\u652f\u6301\u4e00\u4e2a\u5b50View\uff0cMost only support one sub view in PureScrollMode");
        }
        boolean[] uncertains = new boolean[count];
        for (i = 0; i < count; ++i) {
            view = this.getChildAt(i);
            if (view instanceof RefreshHeader && this.mRefreshHeader == null) {
                this.mRefreshHeader = (RefreshHeader)view;
                continue;
            }
            if (view instanceof RefreshFooter && this.mRefreshFooter == null) {
                this.mEnableLoadmore = this.mEnableLoadmore || !this.mManualLoadmore;
                this.mRefreshFooter = (RefreshFooter)view;
                continue;
            }
            if (this.mRefreshContent == null && (view instanceof AbsListView || view instanceof WebView || view instanceof ScrollView || view instanceof ScrollingView || view instanceof NestedScrollingChild || view instanceof NestedScrollingParent || view instanceof ViewPager)) {
                this.mRefreshContent = new RefreshContentWrapper(view);
                continue;
            }
            if (RefreshHeaderWrapper.isTagedHeader(view) && this.mRefreshHeader == null) {
                this.mRefreshHeader = new RefreshHeaderWrapper(view);
                continue;
            }
            if (RefreshFooterWrapper.isTagedFooter(view) && this.mRefreshFooter == null) {
                this.mRefreshFooter = new RefreshFooterWrapper(view);
                continue;
            }
            if (RefreshContentWrapper.isTagedContent(view) && this.mRefreshContent == null) {
                this.mRefreshContent = new RefreshContentWrapper(view);
                continue;
            }
            uncertains[i] = true;
        }
        for (i = 0; i < count; ++i) {
            if (!uncertains[i]) continue;
            view = this.getChildAt(i);
            if (count == 1 && this.mRefreshContent == null) {
                this.mRefreshContent = new RefreshContentWrapper(view);
                continue;
            }
            if (i == 0 && this.mRefreshHeader == null) {
                this.mRefreshHeader = new RefreshHeaderWrapper(view);
                continue;
            }
            if (count == 2 && this.mRefreshContent == null) {
                this.mRefreshContent = new RefreshContentWrapper(view);
                continue;
            }
            if (i == 2 && this.mRefreshFooter == null) {
                this.mEnableLoadmore = this.mEnableLoadmore || !this.mManualLoadmore;
                this.mRefreshFooter = new RefreshFooterWrapper(view);
                continue;
            }
            if (this.mRefreshContent != null) continue;
            this.mRefreshContent = new RefreshContentWrapper(view);
        }
        if (this.isInEditMode()) {
            if (this.mPrimaryColors != null) {
                if (this.mRefreshHeader != null) {
                    this.mRefreshHeader.setPrimaryColors(this.mPrimaryColors);
                }
                if (this.mRefreshFooter != null) {
                    this.mRefreshFooter.setPrimaryColors(this.mPrimaryColors);
                }
            }
            if (this.mRefreshContent != null) {
                this.bringChildToFront(this.mRefreshContent.getView());
            }
            if (this.mRefreshHeader != null && this.mRefreshHeader.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                this.bringChildToFront(this.mRefreshHeader.getView());
            }
            if (this.mRefreshFooter != null && this.mRefreshFooter.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                this.bringChildToFront(this.mRefreshFooter.getView());
            }
            if (this.mKernel == null) {
                this.mKernel = new RefreshKernelImpl();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        if (this.mKernel == null) {
            this.mKernel = new RefreshKernelImpl();
        }
        if (this.handler == null) {
            this.handler = new Handler();
        }
        if (this.mDelayedRunables != null) {
            for (DelayedRunable runable : this.mDelayedRunables) {
                this.handler.postDelayed((Runnable)runable, runable.delayMillis);
            }
            this.mDelayedRunables.clear();
            this.mDelayedRunables = null;
        }
        if (this.mRefreshContent == null && this.mRefreshHeader == null && this.mRefreshFooter == null) {
            this.onFinishInflate();
        }
        if (this.mRefreshContent == null) {
            int len = this.getChildCount();
            for (int i = 0; i < len; ++i) {
                View view = this.getChildAt(i);
                if (this.mRefreshHeader != null && view == this.mRefreshHeader.getView() || this.mRefreshFooter != null && view == this.mRefreshFooter.getView()) continue;
                this.mRefreshContent = new RefreshContentWrapper(view);
            }
            if (this.mRefreshContent == null) {
                this.mRefreshContent = new RefreshContentWrapper(this.getContext());
                this.mRefreshContent.getView().setLayoutParams((ViewGroup.LayoutParams)new LayoutParams(-1, -1));
            }
        }
        if (this.mFixedHeaderViewId > 0 && this.mFixedHeaderView == null) {
            this.mFixedHeaderView = this.findViewById(this.mFixedHeaderViewId);
        }
        if (this.mFixedFooterViewId > 0 && this.mFixedFooterView == null) {
            this.mFixedFooterView = this.findViewById(this.mFixedFooterViewId);
        }
        this.mRefreshContent.setRefreshScrollBoundary(this.mRefreshScrollBoundary);
        this.mRefreshContent.setEnableLoadmoreWhenContentNotFull(this.mEnableLoadmoreWhenContentNotFull || this.mEnablePureScrollMode);
        this.mRefreshContent.setupComponent(this.mKernel, this.mFixedHeaderView, this.mFixedFooterView);
        if (this.mRefreshHeader == null) {
            this.mRefreshHeader = this.mEnablePureScrollMode ? new FalsifyHeader(this.getContext()) : sHeaderCreater.createRefreshHeader(this.getContext(), this);
            if (!(this.mRefreshHeader.getView().getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
                if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale) {
                    this.addView(this.mRefreshHeader.getView(), -1, -1);
                } else {
                    this.addView(this.mRefreshHeader.getView(), -1, -2);
                }
            }
        }
        if (this.mRefreshFooter == null) {
            if (this.mEnablePureScrollMode) {
                this.mRefreshFooter = new RefreshFooterWrapper(new FalsifyHeader(this.getContext()));
                this.mEnableLoadmore = this.mEnableLoadmore || !this.mManualLoadmore;
            } else {
                this.mRefreshFooter = sFooterCreater.createRefreshFooter(this.getContext(), this);
                boolean bl = this.mEnableLoadmore = this.mEnableLoadmore || !this.mManualLoadmore && sManualFooterCreater;
            }
            if (!(this.mRefreshFooter.getView().getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
                if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale) {
                    this.addView(this.mRefreshFooter.getView(), -1, -1);
                } else {
                    this.addView(this.mRefreshFooter.getView(), -1, -2);
                }
            }
        }
        this.bringChildToFront(this.mRefreshContent.getView());
        if (this.mRefreshHeader.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
            this.bringChildToFront(this.mRefreshHeader.getView());
        }
        if (this.mRefreshFooter.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
            this.bringChildToFront(this.mRefreshFooter.getView());
        }
        if (this.mRefreshListener == null) {
            this.mRefreshListener = new OnRefreshListener(){

                @Override
                public void onRefresh(RefreshLayout refreshlayout) {
                    refreshlayout.finishRefresh(3000);
                }
            };
        }
        if (this.mLoadmoreListener == null) {
            this.mLoadmoreListener = new OnLoadmoreListener(){

                @Override
                public void onLoadmore(RefreshLayout refreshlayout) {
                    refreshlayout.finishLoadmore(2000);
                }
            };
        }
        if (this.mPrimaryColors != null) {
            this.mRefreshHeader.setPrimaryColors(this.mPrimaryColors);
            this.mRefreshFooter.setPrimaryColors(this.mPrimaryColors);
        }
        try {
            if (!this.mManualNestedScrolling && !this.isNestedScrollingEnabled() && this.getLayoutParams() instanceof CoordinatorLayout.LayoutParams) {
                this.setNestedScrollingEnabled(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int measuredHeight;
        int heightSpec;
        int widthSpec;
        LayoutParams lp;
        int measureHeight;
        int minimumHeight = 0;
        boolean isInEditMode = this.isInEditMode() && this.mEnablePreviewInEditMode;
        int n = measureHeight = this.mEnableDrop ? this.mScreenHeightPixels : this.mHeaderHeight;
        if (this.mRefreshHeader != null) {
            View headerView = this.mRefreshHeader.getView();
            lp = (LayoutParams)headerView.getLayoutParams();
            widthSpec = SmartRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(lp.leftMargin + lp.rightMargin), (int)lp.width);
            heightSpec = heightMeasureSpec;
            if (this.mHeaderHeightStatus.gteReplaceWith(DimensionStatus.XmlLayoutUnNotify)) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(measureHeight - lp.bottomMargin, 0), (int)0x40000000);
                headerView.measure(widthSpec, heightSpec);
            } else if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
                headerView.measure(widthSpec, heightSpec);
            } else if (lp.height > 0) {
                if (this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.XmlExact)) {
                    this.mHeaderHeightStatus = DimensionStatus.XmlExact;
                    this.mHeaderHeight = lp.height + lp.bottomMargin;
                    this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
                    this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, this.mHeaderExtendHeight);
                }
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000);
                headerView.measure(widthSpec, heightSpec);
            } else if (lp.height == -2) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(measureHeight - lp.bottomMargin, 0), (int)Integer.MIN_VALUE);
                headerView.measure(widthSpec, heightSpec);
                measuredHeight = headerView.getMeasuredHeight();
                if (measuredHeight > 0 && this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.XmlWrap)) {
                    this.mHeaderHeightStatus = DimensionStatus.XmlWrap;
                    this.mHeaderHeight = headerView.getMeasuredHeight() + lp.bottomMargin;
                    this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
                    this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, this.mHeaderExtendHeight);
                } else if (measuredHeight <= 0) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(measureHeight - lp.bottomMargin, 0), (int)0x40000000);
                    headerView.measure(widthSpec, heightSpec);
                }
            } else if (lp.height == -1) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(measureHeight - lp.bottomMargin, 0), (int)0x40000000);
                headerView.measure(widthSpec, heightSpec);
            } else {
                headerView.measure(widthSpec, heightSpec);
            }
            if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale && !isInEditMode) {
                height = Math.max(0, this.mSpinner);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(height - lp.bottomMargin, 0), (int)0x40000000);
                headerView.measure(widthSpec, heightSpec);
            }
            if (!this.mHeaderHeightStatus.notifyed) {
                this.mHeaderHeightStatus = this.mHeaderHeightStatus.notifyed();
                this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, this.mHeaderExtendHeight);
            }
            if (isInEditMode) {
                minimumHeight += headerView.getMeasuredHeight();
            }
        }
        if (this.mRefreshFooter != null) {
            View footerView = this.mRefreshFooter.getView();
            lp = (LayoutParams)footerView.getLayoutParams();
            widthSpec = SmartRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(lp.leftMargin + lp.rightMargin), (int)lp.width);
            heightSpec = heightMeasureSpec;
            if (this.mFooterHeightStatus.gteReplaceWith(DimensionStatus.XmlLayoutUnNotify)) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - lp.topMargin, 0), (int)0x40000000);
                footerView.measure(widthSpec, heightSpec);
            } else if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
                footerView.measure(widthSpec, heightSpec);
            } else if (lp.height > 0) {
                if (this.mFooterHeightStatus.canReplaceWith(DimensionStatus.XmlExact)) {
                    this.mFooterHeightStatus = DimensionStatus.XmlExact;
                    this.mFooterHeight = lp.height + lp.topMargin;
                    this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mFooterMaxDragRate - 1.0f), 0.0f);
                    this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, this.mFooterExtendHeight);
                }
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)(lp.height - lp.topMargin), (int)0x40000000);
                footerView.measure(widthSpec, heightSpec);
            } else if (lp.height == -2) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec) - lp.topMargin, 0), (int)Integer.MIN_VALUE);
                footerView.measure(widthSpec, heightSpec);
                measuredHeight = footerView.getMeasuredHeight();
                if (measuredHeight > 0 && this.mFooterHeightStatus.canReplaceWith(DimensionStatus.XmlWrap)) {
                    this.mFooterHeightStatus = DimensionStatus.XmlWrap;
                    this.mFooterHeight = footerView.getMeasuredHeight() + lp.topMargin;
                    this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mFooterMaxDragRate - 1.0f), 0.0f);
                    this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, this.mFooterExtendHeight);
                } else if (measuredHeight <= 0) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - lp.topMargin, 0), (int)0x40000000);
                    footerView.measure(widthSpec, heightSpec);
                }
            } else if (lp.height == -1) {
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - lp.topMargin, 0), (int)0x40000000);
                footerView.measure(widthSpec, heightSpec);
            } else {
                footerView.measure(widthSpec, heightSpec);
            }
            if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale && !isInEditMode) {
                height = Math.max(0, -this.mSpinner);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(height - lp.topMargin, 0), (int)0x40000000);
                footerView.measure(widthSpec, heightSpec);
            }
            if (!this.mFooterHeightStatus.notifyed) {
                this.mFooterHeightStatus = this.mFooterHeightStatus.notifyed();
                this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, this.mFooterExtendHeight);
            }
            if (isInEditMode) {
                minimumHeight += footerView.getMeasuredHeight();
            }
        }
        if (this.mRefreshContent != null) {
            LayoutParams lp2 = (LayoutParams)this.mRefreshContent.getLayoutParams();
            int widthSpec2 = SmartRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp2.leftMargin + lp2.rightMargin), (int)lp2.width);
            int heightSpec2 = SmartRefreshLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp2.topMargin + lp2.bottomMargin + (isInEditMode && this.mRefreshHeader != null && (this.mEnableHeaderTranslationContent || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) ? this.mHeaderHeight : 0) + (isInEditMode && this.mRefreshFooter != null && (this.mEnableFooterTranslationContent || this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) ? this.mFooterHeight : 0)), (int)lp2.height);
            this.mRefreshContent.measure(widthSpec2, heightSpec2);
            this.mRefreshContent.onInitialHeaderAndFooter(this.mHeaderHeight, this.mFooterHeight);
            minimumHeight += this.mRefreshContent.getMeasuredHeight();
        }
        this.setMeasuredDimension(SmartRefreshLayout.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), SmartRefreshLayout.resolveSize((int)minimumHeight, (int)heightMeasureSpec));
        this.mLastTouchX = this.getMeasuredWidth() / 2;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        boolean isInEditMode;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        boolean bl = isInEditMode = this.isInEditMode() && this.mEnablePreviewInEditMode;
        if (this.mRefreshContent != null) {
            LayoutParams lp = (LayoutParams)this.mRefreshContent.getLayoutParams();
            int left = paddingLeft + lp.leftMargin;
            int top = paddingTop + lp.topMargin;
            int right = left + this.mRefreshContent.getMeasuredWidth();
            int bottom = top + this.mRefreshContent.getMeasuredHeight();
            if (isInEditMode && this.mRefreshHeader != null && (this.mEnableHeaderTranslationContent || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind)) {
                top += this.mHeaderHeight;
                bottom += this.mHeaderHeight;
            }
            this.mRefreshContent.layout(left, top, right, bottom);
        }
        if (this.mRefreshHeader != null) {
            View headerView = this.mRefreshHeader.getView();
            LayoutParams lp = (LayoutParams)headerView.getLayoutParams();
            int left = lp.leftMargin;
            int top = lp.topMargin;
            int right = left + headerView.getMeasuredWidth();
            int bottom = top + headerView.getMeasuredHeight();
            if (!isInEditMode) {
                if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                    if (this.mEnableDrop) {
                        top = top - this.mScreenHeightPixels + Math.max(0, this.mSpinner);
                        bottom = top + this.mScreenHeightPixels;
                    } else {
                        top = top - this.mHeaderHeight + Math.max(0, this.mSpinner);
                        bottom = top + headerView.getMeasuredHeight();
                    }
                } else if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale) {
                    bottom = top + Math.max(Math.max(0, this.mSpinner) - lp.bottomMargin, 0);
                }
            }
            headerView.layout(left, top, right, bottom);
        }
        if (this.mRefreshFooter != null) {
            View footerView = this.mRefreshFooter.getView();
            LayoutParams lp = (LayoutParams)footerView.getLayoutParams();
            SpinnerStyle style = this.mRefreshFooter.getSpinnerStyle();
            int left = lp.leftMargin;
            int top = lp.topMargin + this.getMeasuredHeight();
            if (isInEditMode || style == SpinnerStyle.FixedFront || style == SpinnerStyle.FixedBehind) {
                top -= this.mFooterHeight;
            } else if (style == SpinnerStyle.Scale || style == SpinnerStyle.Translate) {
                top -= Math.max(Math.max(-this.mSpinner, 0) - lp.topMargin, 0);
            }
            int right = left + footerView.getMeasuredWidth();
            int bottom = top + footerView.getMeasuredHeight();
            footerView.layout(left, top, right, bottom);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean isInEditMode;
        boolean bl = isInEditMode = this.mEnablePreviewInEditMode && this.isInEditMode();
        if (this.mHeaderBackgroundColor != 0 && (this.mSpinner > 0 || isInEditMode)) {
            this.mPaint.setColor(this.mHeaderBackgroundColor);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), isInEditMode ? (float)this.mHeaderHeight : (float)this.mSpinner, this.mPaint);
        } else if (this.mFooterBackgroundColor != 0 && (this.mSpinner < 0 || isInEditMode)) {
            int height = this.getHeight();
            this.mPaint.setColor(this.mFooterBackgroundColor);
            canvas.drawRect(0.0f, (float)(height - (isInEditMode ? this.mFooterHeight : -this.mSpinner)), (float)this.getWidth(), (float)height, this.mPaint);
        }
        super.dispatchDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mSpinner = 0;
        this.notifyStateChanged(RefreshState.None);
        this.handler.removeCallbacksAndMessages(null);
        this.handler = null;
        this.mKernel = null;
        this.mRefreshHeader = null;
        this.mRefreshFooter = null;
        this.mRefreshContent = null;
        this.mFixedHeaderView = null;
        this.mFixedFooterView = null;
        this.mRefreshListener = null;
        this.mLoadmoreListener = null;
        this.mOnMultiPurposeListener = null;
        this.mRefreshScrollBoundary = null;
        this.mManualLoadmore = true;
        this.mManualNestedScrolling = true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return super.onInterceptTouchEvent(ev);
    }

    /*
     * Unable to fully structure code
     */
    public boolean dispatchTouchEvent(MotionEvent e) {
        action = MotionEventCompat.getActionMasked((MotionEvent)e);
        pointerUp = action == 6;
        skipIndex = pointerUp != false ? e.getActionIndex() : -1;
        sumX = 0.0f;
        sumY = 0.0f;
        count = e.getPointerCount();
        for (i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += e.getX(i);
            sumY += e.getY(i);
        }
        div = pointerUp != false ? count - 1 : count;
        touchX = sumX / (float)div;
        touchY = sumY / (float)div;
        if ((action == 6 || action == 5) && this.mIsBeingDragged) {
            this.mTouchY += touchY - this.mLastTouchY;
        }
        this.mLastTouchX = touchX;
        this.mLastTouchY = touchY;
        if (this.mRefreshContent != null) {
            switch (action) {
                case 0: {
                    this.mRefreshContent.onActionDown(e);
                    break;
                }
                case 1: 
                case 3: {
                    this.mRefreshContent.onActionUpOrCancel();
                    break;
                }
            }
        }
        if (this.reboundAnimator != null && this.interceptAnimator(action) == false || this.mState == RefreshState.Loading && this.mDisableContentWhenLoading != false || this.mState == RefreshState.Refreshing && this.mDisableContentWhenRefresh) {
            return false;
        }
        if (this.mNestedScrollInProgress) {
            totalUnconsumed = this.mTotalUnconsumed;
            ret = super.dispatchTouchEvent(e);
            if (action == 2 && totalUnconsumed == this.mTotalUnconsumed) {
                offsetX = (int)this.mLastTouchX;
                offsetMax = this.getWidth();
                percentX = this.mLastTouchX / (float)offsetMax;
                if (this.mSpinner > 0 && this.mRefreshHeader != null && this.mRefreshHeader.isSupportHorizontalDrag()) {
                    this.mRefreshHeader.onHorizontalDrag(percentX, offsetX, offsetMax);
                } else if (this.mSpinner < 0 && this.mRefreshFooter != null && this.mRefreshFooter.isSupportHorizontalDrag()) {
                    this.mRefreshFooter.onHorizontalDrag(percentX, offsetX, offsetMax);
                }
            }
            Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent] 1");
            return ret;
        }
        if (!this.isEnabled() || !this.mEnableRefresh && !this.mEnableLoadmore || this.mHeaderNeedTouchEventWhenRefreshing && (this.mState == RefreshState.Refreshing || this.mState == RefreshState.RefreshFinish) || this.mFooterNeedTouchEventWhenRefreshing && (this.mState == RefreshState.Loading || this.mState == RefreshState.LoadFinish)) {
            Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent] 2");
            return super.dispatchTouchEvent(e);
        }
        Log.d((String)"SmartRefreshLayout", (String)("[dispatchTouchEvent] action = " + action));
        switch (action) {
            case 0: {
                this.mTouchX = touchX;
                this.mTouchY = touchY;
                this.mLastTouchY = touchY;
                this.mLastSpinner = 0;
                this.mTouchSpinner = this.mSpinner;
                this.mIsBeingDragged = false;
                if (this.mState == RefreshState.Dropping || this.mState == RefreshState.ReleaseToDrop) {
                    return false;
                }
                super.dispatchTouchEvent(e);
                return true;
            }
            case 2: {
                dx = touchX - this.mTouchX;
                dy = touchY - this.mTouchY;
                this.mLastTouchY = touchY;
                if (this.mIsBeingDragged) ** GOTO lbl102
                if (!(Math.abs(dy) >= (float)this.mTouchSlop) || !(Math.abs(dx) < Math.abs(dy))) ** GOTO lbl99
                if (dy > 0.0f && (this.mSpinner < 0 || this.mEnableRefresh && this.mRefreshContent.canRefresh())) {
                    if (this.mSpinner < 0) {
                        this.setStatePullUpToLoad();
                    } else {
                        this.setStatePullDownToRefresh();
                    }
                    this.mIsBeingDragged = true;
                    this.mTouchY = touchY - (float)this.mTouchSlop;
                    dy = touchY - this.mTouchY;
                    Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 1 MotionEvent.ACTION_CANCEL");
                    super.dispatchTouchEvent(e);
                } else if (dy < 0.0f && (this.mSpinner > 0 || this.mEnableLoadmore && this.mRefreshContent.canLoadmore())) {
                    if (this.mSpinner > 0) {
                        this.setStatePullDownToRefresh();
                    } else {
                        this.setStatePullUpToLoad();
                    }
                    this.mIsBeingDragged = true;
                    this.mTouchY = touchY + (float)this.mTouchSlop;
                    dy = touchY - this.mTouchY;
                    Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 2 MotionEvent.ACTION_CANCEL");
                    e.setAction(3);
                    super.dispatchTouchEvent(e);
                } else {
                    Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 3 MotionEvent.ACTION_MOVE");
                    return super.dispatchTouchEvent(e);
lbl99:
                    // 1 sources

                    Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 4 MotionEvent.ACTION_MOVE");
                    return super.dispatchTouchEvent(e);
                }
lbl102:
                // 3 sources

                if (!this.mIsBeingDragged) break;
                spinner = dy + (float)this.mTouchSpinner;
                if (this.mRefreshContent != null && this.getViceState().isHeader() && (spinner < 0.0f || this.mLastSpinner < 0) || this.getViceState().isFooter() && (spinner > 0.0f || this.mLastSpinner > 0)) {
                    time = e.getEventTime();
                    if (this.mFalsifyEvent == null) {
                        this.mFalsifyEvent = MotionEvent.obtain((long)time, (long)time, (int)0, (float)(this.mTouchX + dx), (float)this.mTouchY, (int)0);
                        Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 5 MotionEvent.ACTION_DOWN");
                        super.dispatchTouchEvent(this.mFalsifyEvent);
                    }
                    em = MotionEvent.obtain((long)time, (long)time, (int)2, (float)(this.mTouchX + dx), (float)(this.mTouchY + spinner), (int)0);
                    Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 6 MotionEvent.ACTION_MOVE");
                    super.dispatchTouchEvent(em);
                    if (this.getViceState().isHeader() != false && spinner < 0.0f || this.getViceState().isFooter() && spinner > 0.0f) {
                        this.mLastSpinner = (int)spinner;
                        if (this.mSpinner != 0) {
                            this.moveSpinnerInfinitely(0.0f);
                        }
                        return true;
                    }
                    this.mLastSpinner = (int)spinner;
                    this.mFalsifyEvent = null;
                    ec = MotionEvent.obtain((long)time, (long)time, (int)3, (float)this.mTouchX, (float)(this.mTouchY + spinner), (int)0);
                    Log.d((String)"SmartRefreshLayout", (String)"[dispatchTouchEvent1] 7 MotionEvent.CANCEL");
                    super.dispatchTouchEvent(ec);
                }
                if (!this.getViceState().isDraging()) break;
                super.dispatchTouchEvent(e);
                this.moveSpinnerInfinitely(spinner);
                return true;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                if (this.mFalsifyEvent != null) {
                    this.mFalsifyEvent = null;
                    time = e.getEventTime();
                    ec = MotionEvent.obtain((long)time, (long)time, (int)(this.mSpinner == 0 ? 1 : 3), (float)this.mTouchX, (float)touchY, (int)0);
                    super.dispatchTouchEvent(ec);
                }
                if (!this.overSpinner()) break;
                return true;
            }
        }
        return super.dispatchTouchEvent(e);
    }

    protected boolean interceptAnimator(int action) {
        if (this.reboundAnimator != null && action == 0) {
            if (this.mState == RefreshState.PullDownCanceled || this.mState == RefreshState.RefreshFinish) {
                this.setStatePullDownToRefresh();
            } else if (this.mState == RefreshState.PullUpCanceled || this.mState == RefreshState.LoadFinish) {
                this.setStatePullUpToLoad();
            }
            this.reboundAnimator.cancel();
            this.reboundAnimator = null;
            return true;
        }
        return false;
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        View target = this.mRefreshContent.getScrollableView();
        if (!(Build.VERSION.SDK_INT < 21 && target instanceof AbsListView || target != null && !ViewCompat.isNestedScrollingEnabled((View)target))) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    protected void notifyStateChanged(RefreshState state) {
        RefreshState oldState = this.mState;
        if (oldState != state) {
            this.mState = state;
            this.mViceState = state;
            if (this.mRefreshFooter != null) {
                this.mRefreshFooter.onStateChanged(this, oldState, state);
            }
            if (this.mRefreshHeader != null) {
                this.mRefreshHeader.onStateChanged(this, oldState, state);
            }
            if (this.mOnMultiPurposeListener != null) {
                this.mOnMultiPurposeListener.onStateChanged(this, oldState, state);
            }
        }
    }

    protected void setStatePullUpToLoad() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.PullToUpLoad);
        } else {
            this.setViceState(RefreshState.PullToUpLoad);
        }
    }

    protected void setStateReleaseToLoad() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.ReleaseToLoad);
        } else {
            this.setViceState(RefreshState.ReleaseToLoad);
        }
    }

    protected void setStateReleaseToRefresh() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.ReleaseToRefresh);
        } else {
            this.setViceState(RefreshState.ReleaseToRefresh);
        }
    }

    protected void setStateReleaseToDrop() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.ReleaseToDrop);
        } else {
            this.setViceState(RefreshState.ReleaseToDrop);
        }
    }

    protected void setStateDropping() {
        this.animSpinnerWithDuration(this.mRefreshContent.getMeasuredHeight(), this.mDroppingDuration);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SmartRefreshLayout.this.notifyStateChanged(RefreshState.Dropping);
                SmartRefreshLayout.this.overSpinner();
            }
        }, (long)this.mDroppingDuration);
    }

    protected void setStatePullDownToRefresh() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.PullDownToRefresh);
        } else {
            this.setViceState(RefreshState.PullDownToRefresh);
        }
    }

    protected void setStatePullDownCanceled() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.PullDownCanceled);
            this.resetStatus();
        } else {
            this.setViceState(RefreshState.PullDownCanceled);
        }
    }

    protected void setStatePullUpCanceled() {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading) {
            this.notifyStateChanged(RefreshState.PullUpCanceled);
            this.resetStatus();
        } else {
            this.setViceState(RefreshState.PullUpCanceled);
        }
    }

    protected void setStateLodingFinish() {
        this.notifyStateChanged(RefreshState.LoadFinish);
    }

    protected void setStateRefresingFinish() {
        this.notifyStateChanged(RefreshState.RefreshFinish);
    }

    protected void setStateLoding() {
        this.mLastLoadingTime = System.currentTimeMillis();
        this.notifyStateChanged(RefreshState.Loading);
        this.animSpinner(-this.mFooterHeight);
        if (this.mLoadmoreListener != null) {
            this.mLoadmoreListener.onLoadmore(this);
        }
        if (this.mRefreshFooter != null) {
            this.mRefreshFooter.onStartAnimator(this, this.mFooterHeight, this.mFooterExtendHeight);
        }
        if (this.mOnMultiPurposeListener != null) {
            this.mOnMultiPurposeListener.onLoadmore(this);
            this.mOnMultiPurposeListener.onFooterStartAnimator(this.mRefreshFooter, this.mFooterHeight, this.mFooterExtendHeight);
        }
    }

    protected void setStateRefresing() {
        this.mLastRefreshingTime = System.currentTimeMillis();
        this.notifyStateChanged(RefreshState.Refreshing);
        this.animSpinner(this.mHeaderHeight);
        if (this.mRefreshListener != null) {
            this.mRefreshListener.onRefresh(this);
        }
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.onStartAnimator(this, this.mHeaderHeight, this.mHeaderExtendHeight);
        }
        if (this.mOnMultiPurposeListener != null) {
            this.mOnMultiPurposeListener.onRefresh(this);
            this.mOnMultiPurposeListener.onHeaderStartAnimator(this.mRefreshHeader, this.mHeaderHeight, this.mHeaderExtendHeight);
        }
    }

    protected void resetStatus() {
        if (this.mState != RefreshState.None && this.mSpinner == 0) {
            this.notifyStateChanged(RefreshState.None);
        }
        if (this.mSpinner != 0) {
            this.animSpinner(0);
        }
    }

    protected RefreshState getViceState() {
        return this.mState == RefreshState.Refreshing || this.mState == RefreshState.Loading || this.mState == RefreshState.Dropping ? this.mViceState : this.mState;
    }

    protected void setViceState(RefreshState state) {
        if ((this.mState == RefreshState.Refreshing || this.mState == RefreshState.Loading) && this.mViceState != state) {
            this.mViceState = state;
        }
    }

    protected ValueAnimator animSpinner(int endSpinner) {
        return this.animSpinner(endSpinner, 0);
    }

    protected ValueAnimator animSpinnerWithDuration(int endSpinner, int duration) {
        return this.animSpinner(endSpinner, 0, this.mReboundInterpolator, this.mDroppingDuration);
    }

    protected ValueAnimator animSpinner(int endSpinner, int startDelay) {
        return this.animSpinner(endSpinner, startDelay, this.mReboundInterpolator);
    }

    protected ValueAnimator animSpinner(int endSpinner, int startDelay, Interpolator interpolator) {
        return this.animSpinner(endSpinner, startDelay, interpolator, this.mReboundDuration);
    }

    protected ValueAnimator animSpinner(int endSpinner, int startDelay, Interpolator interpolator, int duration) {
        if (this.mSpinner != endSpinner) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{this.mSpinner, endSpinner});
            this.reboundAnimator.setDuration((long)duration);
            this.reboundAnimator.setInterpolator((TimeInterpolator)interpolator);
            this.reboundAnimator.addUpdateListener(this.reboundUpdateListener);
            this.reboundAnimator.addListener(this.reboundAnimatorEndListener);
            this.reboundAnimator.setStartDelay((long)startDelay);
            this.reboundAnimator.start();
        }
        return this.reboundAnimator;
    }

    protected ValueAnimator animSpinnerBounce(int bounceSpinner) {
        if (this.reboundAnimator == null) {
            this.mLastTouchX = this.getMeasuredWidth() / 2;
            if (this.mState == RefreshState.Refreshing && bounceSpinner > 0) {
                this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{this.mSpinner, Math.min(2 * bounceSpinner, this.mHeaderHeight)});
                this.reboundAnimator.addListener(this.reboundAnimatorEndListener);
            } else if (this.mState == RefreshState.Loading && bounceSpinner < 0) {
                this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{this.mSpinner, Math.max(2 * bounceSpinner, -this.mFooterHeight)});
                this.reboundAnimator.addListener(this.reboundAnimatorEndListener);
            } else if (this.mSpinner == 0 && this.mEnableOverScrollBounce) {
                if (bounceSpinner > 0) {
                    if (this.mState != RefreshState.Loading) {
                        this.setStatePullDownToRefresh();
                    }
                    this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{0, Math.min(bounceSpinner, this.mHeaderHeight + this.mHeaderExtendHeight)});
                } else {
                    if (this.mState != RefreshState.Refreshing) {
                        this.setStatePullUpToLoad();
                    }
                    this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{0, Math.max(bounceSpinner, -this.mFooterHeight - this.mFooterExtendHeight)});
                }
                this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, 0});
                        SmartRefreshLayout.this.reboundAnimator.setDuration((long)(SmartRefreshLayout.this.mReboundDuration * 2 / 3));
                        SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                        SmartRefreshLayout.this.reboundAnimator.addUpdateListener(SmartRefreshLayout.this.reboundUpdateListener);
                        SmartRefreshLayout.this.reboundAnimator.addListener(SmartRefreshLayout.this.reboundAnimatorEndListener);
                        SmartRefreshLayout.this.reboundAnimator.start();
                    }
                });
            }
            if (this.reboundAnimator != null) {
                this.reboundAnimator.setDuration((long)(this.mReboundDuration * 2 / 3));
                this.reboundAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.reboundAnimator.addUpdateListener(this.reboundUpdateListener);
                this.reboundAnimator.start();
            }
        }
        return this.reboundAnimator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean overSpinner() {
        if (this.mState == RefreshState.Loading) {
            if (this.mSpinner < -this.mFooterHeight) {
                this.mTotalUnconsumed = -this.mFooterHeight;
                this.animSpinner(-this.mFooterHeight);
                return true;
            } else {
                if (this.mSpinner <= 0) return false;
                this.mTotalUnconsumed = 0;
                this.animSpinner(0);
            }
            return true;
        } else if (this.mState == RefreshState.Refreshing) {
            if (this.mSpinner > this.mHeaderHeight) {
                this.mTotalUnconsumed = this.mHeaderHeight;
                this.animSpinner(this.mHeaderHeight);
                return true;
            } else {
                if (this.mSpinner >= 0) return false;
                this.mTotalUnconsumed = 0;
                this.animSpinner(0);
            }
            return true;
        } else {
            if (this.mState == RefreshState.Dropping) {
                this.animSpinner(0, this.mDroppingDuration, this.mReboundInterpolator, 1);
                return false;
            }
            if (this.mState == RefreshState.PullDownToRefresh || this.mEnablePureScrollMode && this.mState == RefreshState.ReleaseToRefresh) {
                this.setStatePullDownCanceled();
                return true;
            } else if (this.mState == RefreshState.PullToUpLoad || this.mEnablePureScrollMode && this.mState == RefreshState.ReleaseToLoad) {
                this.setStatePullUpCanceled();
                return true;
            } else if (this.mState == RefreshState.ReleaseToRefresh) {
                this.setStateRefresing();
                return true;
            } else if (this.mState == RefreshState.ReleaseToLoad) {
                this.setStateLoding();
                return true;
            } else if (this.mState == RefreshState.ReleaseToDrop) {
                this.setStateDropping();
                return true;
            } else {
                if (this.mSpinner == 0) return false;
                this.animSpinner(0);
            }
        }
        return true;
    }

    protected void moveSpinnerInfinitely(float dy) {
        if (this.mState == RefreshState.Refreshing && dy >= 0.0f) {
            if (dy < (float)this.mHeaderHeight) {
                this.moveSpinner((int)dy, false);
            } else {
                double m = this.mHeaderExtendHeight;
                double h = Math.max(this.mScreenHeightPixels * 4 / 3, this.getHeight()) - this.mHeaderHeight;
                double x = Math.max(0.0f, (dy - (float)this.mHeaderHeight) * this.mDragRate);
                double y = Math.min(m * (1.0 - Math.pow(100.0, -x / h)), x);
                this.moveSpinner((int)y + this.mHeaderHeight, false);
            }
        } else if (this.mState == RefreshState.Loading && dy < 0.0f) {
            if (dy > (float)(-this.mFooterHeight)) {
                this.moveSpinner((int)dy, false);
            } else {
                double m = this.mFooterExtendHeight;
                double h = Math.max(this.mScreenHeightPixels * 4 / 3, this.getHeight()) - this.mFooterHeight;
                double x = -Math.min(0.0f, (dy + (float)this.mHeaderHeight) * this.mDragRate);
                double y = -Math.min(m * (1.0 - Math.pow(100.0, -x / h)), x);
                this.moveSpinner((int)y - this.mFooterHeight, false);
            }
        } else if (dy >= 0.0f) {
            double m = this.mHeaderExtendHeight + this.mHeaderHeight;
            double h = Math.max(this.mScreenHeightPixels / 2, this.getHeight());
            double x = Math.max(0.0f, dy * this.mDragRate);
            double y = Math.min(m * (1.0 - Math.pow(100.0, -x / h)), x);
            this.moveSpinner((int)y, false);
        } else {
            double m = this.mFooterExtendHeight + this.mFooterHeight;
            double h = Math.max(this.mScreenHeightPixels / 2, this.getHeight());
            double x = -Math.min(0.0f, dy * this.mDragRate);
            double y = -Math.min(m * (1.0 - Math.pow(100.0, -x / h)), x);
            this.moveSpinner((int)y, false);
        }
    }

    protected void moveSpinner(int spinner, boolean isAnimator) {
        float percentX;
        int offsetMax;
        int offsetX;
        float percent;
        int extendHeight;
        int offset;
        if (!(this.mSpinner != spinner || this.mRefreshHeader != null && this.mRefreshHeader.isSupportHorizontalDrag() || this.mRefreshFooter != null && this.mRefreshFooter.isSupportHorizontalDrag())) {
            return;
        }
        int oldSpinner = this.mSpinner;
        this.mSpinner = spinner;
        if (!isAnimator && this.getViceState().isDraging()) {
            if (this.mSpinner > this.mHeaderHeight * 2) {
                this.setStateReleaseToDrop();
            } else if (this.mSpinner > this.mHeaderHeight) {
                this.setStateReleaseToRefresh();
            } else if (-this.mSpinner > this.mFooterHeight && !this.mLoadmoreFinished) {
                this.setStateReleaseToLoad();
            } else if (this.mSpinner < 0 && !this.mLoadmoreFinished) {
                this.setStatePullUpToLoad();
            } else if (this.mSpinner > 0) {
                this.setStatePullDownToRefresh();
            }
        }
        if (this.mRefreshContent != null) {
            if (spinner > 0) {
                if (this.mEnableHeaderTranslationContent || this.mRefreshHeader == null || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                    this.mRefreshContent.moveSpinner(spinner);
                    if (this.mHeaderBackgroundColor != 0) {
                        this.invalidate();
                    }
                }
            } else if (this.mEnableFooterTranslationContent || this.mRefreshFooter == null || this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                this.mRefreshContent.moveSpinner(spinner);
                if (this.mHeaderBackgroundColor != 0) {
                    this.invalidate();
                }
            }
        }
        if ((spinner >= 0 || oldSpinner > 0) && this.mRefreshHeader != null) {
            spinner = Math.max(spinner, 0);
            if ((this.mEnableRefresh || this.mState == RefreshState.RefreshFinish && isAnimator) && oldSpinner != this.mSpinner && (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate)) {
                this.mRefreshHeader.getView().requestLayout();
            }
            offset = spinner;
            int headerHeight = this.mHeaderHeight;
            extendHeight = this.mHeaderExtendHeight;
            percent = 1.0f * (float)spinner / (float)this.mHeaderHeight;
            if (isAnimator) {
                this.mRefreshHeader.onReleasing(percent, offset, headerHeight, extendHeight);
                if (this.mOnMultiPurposeListener != null) {
                    this.mOnMultiPurposeListener.onHeaderReleasing(this.mRefreshHeader, percent, offset, headerHeight, extendHeight);
                }
            } else {
                if (this.mRefreshHeader.isSupportHorizontalDrag()) {
                    offsetX = (int)this.mLastTouchX;
                    offsetMax = this.getWidth();
                    percentX = this.mLastTouchX / (float)offsetMax;
                    this.mRefreshHeader.onHorizontalDrag(percentX, offsetX, offsetMax);
                }
                this.mRefreshHeader.onPullingDown(percent, offset, headerHeight, extendHeight);
                if (this.mOnMultiPurposeListener != null) {
                    this.mOnMultiPurposeListener.onHeaderPulling(this.mRefreshHeader, percent, offset, headerHeight, extendHeight);
                }
            }
        }
        if ((spinner <= 0 || oldSpinner < 0) && this.mRefreshFooter != null) {
            spinner = Math.min(spinner, 0);
            if ((this.mEnableLoadmore || this.mState == RefreshState.LoadFinish && isAnimator) && oldSpinner != this.mSpinner && (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale || this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate)) {
                this.mRefreshFooter.getView().requestLayout();
            }
            offset = -spinner;
            int footerHeight = this.mFooterHeight;
            extendHeight = this.mFooterExtendHeight;
            percent = (float)(-spinner) * 1.0f / (float)this.mFooterHeight;
            if (isAnimator) {
                this.mRefreshFooter.onPullReleasing(percent, offset, footerHeight, extendHeight);
                if (this.mOnMultiPurposeListener != null) {
                    this.mOnMultiPurposeListener.onFooterReleasing(this.mRefreshFooter, percent, offset, footerHeight, extendHeight);
                }
            } else {
                if (this.mRefreshFooter.isSupportHorizontalDrag()) {
                    offsetX = (int)this.mLastTouchX;
                    offsetMax = this.getWidth();
                    percentX = this.mLastTouchX / (float)offsetMax;
                    this.mRefreshFooter.onHorizontalDrag(percentX, offsetX, offsetMax);
                }
                this.mRefreshFooter.onPullingUp(percent, offset, footerHeight, extendHeight);
                if (this.mOnMultiPurposeListener != null) {
                    this.mOnMultiPurposeListener.onFooterPulling(this.mRefreshFooter, percent, offset, footerHeight, extendHeight);
                }
            }
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean accepted = this.isEnabled() && this.isNestedScrollingEnabled() && (nestedScrollAxes & 2) != 0;
        accepted = accepted && (this.mEnableRefresh || this.mEnableLoadmore);
        return accepted;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
        this.mTotalUnconsumed = 0;
        this.mTouchSpinner = this.mSpinner;
        this.mNestedScrollInProgress = true;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        Log.d((String)TAG, (String)"[onNestedPreScroll]");
        if (this.mState == RefreshState.Refreshing || this.mState == RefreshState.Loading) {
            int[] parentConsumed = this.mParentScrollConsumed;
            if (this.dispatchNestedPreScroll(dx, dy, parentConsumed, null)) {
                dy -= parentConsumed[1];
            }
            if (this.mState == RefreshState.Refreshing && (dy * this.mTotalUnconsumed > 0 || this.mTouchSpinner > 0)) {
                consumed[1] = 0;
                if (Math.abs(dy) > Math.abs(this.mTotalUnconsumed)) {
                    consumed[1] = consumed[1] + this.mTotalUnconsumed;
                    this.mTotalUnconsumed = 0;
                    dy -= this.mTotalUnconsumed;
                    if (this.mTouchSpinner <= 0) {
                        this.moveSpinnerInfinitely(0.0f);
                    }
                } else {
                    this.mTotalUnconsumed -= dy;
                    consumed[1] = consumed[1] + dy;
                    dy = 0;
                    this.moveSpinnerInfinitely(this.mTotalUnconsumed + this.mTouchSpinner);
                }
                if (dy > 0 && this.mTouchSpinner > 0) {
                    if (dy > this.mTouchSpinner) {
                        consumed[1] = consumed[1] + this.mTouchSpinner;
                        this.mTouchSpinner = 0;
                    } else {
                        this.mTouchSpinner -= dy;
                        consumed[1] = consumed[1] + dy;
                    }
                    this.moveSpinnerInfinitely(this.mTouchSpinner);
                }
            } else if (this.mState == RefreshState.Loading && (dy * this.mTotalUnconsumed > 0 || this.mTouchSpinner < 0)) {
                consumed[1] = 0;
                if (Math.abs(dy) > Math.abs(this.mTotalUnconsumed)) {
                    consumed[1] = consumed[1] + this.mTotalUnconsumed;
                    this.mTotalUnconsumed = 0;
                    dy -= this.mTotalUnconsumed;
                    if (this.mTouchSpinner >= 0) {
                        this.moveSpinnerInfinitely(0.0f);
                    }
                } else {
                    this.mTotalUnconsumed -= dy;
                    consumed[1] = consumed[1] + dy;
                    dy = 0;
                    this.moveSpinnerInfinitely(this.mTotalUnconsumed + this.mTouchSpinner);
                }
                if (dy < 0 && this.mTouchSpinner < 0) {
                    if (dy < this.mTouchSpinner) {
                        consumed[1] = consumed[1] + this.mTouchSpinner;
                        this.mTouchSpinner = 0;
                    } else {
                        this.mTouchSpinner -= dy;
                        consumed[1] = consumed[1] + dy;
                    }
                    this.moveSpinnerInfinitely(this.mTouchSpinner);
                }
            }
        } else {
            if (this.mEnableRefresh && dy > 0 && this.mTotalUnconsumed > 0) {
                if (dy > this.mTotalUnconsumed) {
                    consumed[1] = dy - this.mTotalUnconsumed;
                    this.mTotalUnconsumed = 0;
                } else {
                    this.mTotalUnconsumed -= dy;
                    consumed[1] = dy;
                }
                this.moveSpinnerInfinitely(this.mTotalUnconsumed);
            } else if (this.mEnableLoadmore && dy < 0 && this.mTotalUnconsumed < 0) {
                if (dy < this.mTotalUnconsumed) {
                    consumed[1] = dy - this.mTotalUnconsumed;
                    this.mTotalUnconsumed = 0;
                } else {
                    this.mTotalUnconsumed -= dy;
                    consumed[1] = dy;
                }
                this.moveSpinnerInfinitely(this.mTotalUnconsumed);
            }
            int[] parentConsumed = this.mParentScrollConsumed;
            if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed, null)) {
                consumed[0] = consumed[0] + parentConsumed[0];
                consumed[1] = consumed[1] + parentConsumed[1];
            }
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        this.mTotalUnconsumed = 0;
        this.overSpinner();
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (this.mState == RefreshState.Refreshing || this.mState == RefreshState.Loading) {
            if (this.mEnableRefresh && dy < 0 && (this.mRefreshContent == null || this.mRefreshContent.canRefresh())) {
                this.mTotalUnconsumed += Math.abs(dy);
                this.moveSpinnerInfinitely(this.mTotalUnconsumed + this.mTouchSpinner);
            } else if (this.mEnableLoadmore && dy > 0 && (this.mRefreshContent == null || this.mRefreshContent.canLoadmore())) {
                this.mTotalUnconsumed -= Math.abs(dy);
                this.moveSpinnerInfinitely(this.mTotalUnconsumed + this.mTouchSpinner);
            }
        } else if (this.mEnableRefresh && dy < 0 && (this.mRefreshContent == null || this.mRefreshContent.canRefresh())) {
            if (this.mState == RefreshState.None) {
                this.setStatePullDownToRefresh();
            }
            this.mTotalUnconsumed += Math.abs(dy);
            this.moveSpinnerInfinitely(this.mTotalUnconsumed);
        } else if (this.mEnableLoadmore && dy > 0 && (this.mRefreshContent == null || this.mRefreshContent.canLoadmore())) {
            if (this.mState == RefreshState.None && !this.mLoadmoreFinished) {
                this.setStatePullUpToLoad();
            }
            this.mTotalUnconsumed -= Math.abs(dy);
            this.moveSpinnerInfinitely(this.mTotalUnconsumed);
        }
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.reboundAnimator != null || this.mState == RefreshState.ReleaseToRefresh || this.mState == RefreshState.ReleaseToLoad || this.mState == RefreshState.PullDownToRefresh && this.mSpinner > 0 || this.mState == RefreshState.PullToUpLoad && this.mSpinner > 0 || this.mState == RefreshState.Refreshing && this.mSpinner != 0 || this.mState == RefreshState.Loading && this.mSpinner != 0 || this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mManualNestedScrolling = true;
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    @Override
    public SmartRefreshLayout setFooterHeight(float heightDp) {
        return this.setFooterHeightPx(DensityUtil.dp2px(heightDp));
    }

    @Override
    public SmartRefreshLayout setFooterHeightPx(int heightPx) {
        if (this.mFooterHeightStatus.canReplaceWith(DimensionStatus.CodeExact)) {
            this.mFooterHeight = heightPx;
            this.mFooterExtendHeight = (int)Math.max((float)heightPx * (this.mFooterMaxDragRate - 1.0f), 0.0f);
            this.mFooterHeightStatus = DimensionStatus.CodeExactUnNotify;
            if (this.mRefreshFooter != null) {
                this.mRefreshFooter.getView().requestLayout();
            }
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setHeaderHeight(float heightDp) {
        return this.setHeaderHeightPx(DensityUtil.dp2px(heightDp));
    }

    @Override
    public SmartRefreshLayout setHeaderHeightPx(int heightPx) {
        if (this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.CodeExact)) {
            this.mHeaderHeight = heightPx;
            this.mHeaderExtendHeight = (int)Math.max((float)heightPx * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
            this.mHeaderHeightStatus = DimensionStatus.CodeExactUnNotify;
            if (this.mRefreshHeader != null) {
                this.mRefreshHeader.getView().requestLayout();
            }
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setDragRate(float rate) {
        this.mDragRate = rate;
        return this;
    }

    @Override
    public SmartRefreshLayout setHeaderMaxDragRate(float rate) {
        this.mHeaderMaxDragRate = rate;
        this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
        if (this.mRefreshHeader != null && this.mKernel != null) {
            this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, this.mHeaderExtendHeight);
        } else {
            this.mHeaderHeightStatus = this.mHeaderHeightStatus.unNotify();
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setFooterMaxDragRate(float rate) {
        this.mFooterMaxDragRate = rate;
        this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mFooterMaxDragRate - 1.0f), 0.0f);
        if (this.mRefreshFooter != null && this.mKernel != null) {
            this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, this.mFooterExtendHeight);
        } else {
            this.mFooterHeightStatus = this.mFooterHeightStatus.unNotify();
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setReboundInterpolator(Interpolator interpolator) {
        this.mReboundInterpolator = interpolator;
        return this;
    }

    @Override
    public SmartRefreshLayout setReboundDuration(int duration) {
        this.mReboundDuration = duration;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableLoadmore(boolean enable) {
        this.mManualLoadmore = true;
        this.mEnableLoadmore = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableRefresh(boolean enable) {
        this.mEnableRefresh = enable;
        return this;
    }

    @Override
    public RefreshLayout setEnableDrop(boolean enable) {
        this.mEnableDrop = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableHeaderTranslationContent(boolean enable) {
        this.mEnableHeaderTranslationContent = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableFooterTranslationContent(boolean enable) {
        this.mEnableFooterTranslationContent = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setDisableContentWhenRefresh(boolean disable) {
        this.mDisableContentWhenRefresh = disable;
        return this;
    }

    @Override
    public SmartRefreshLayout setDisableContentWhenLoading(boolean disable) {
        this.mDisableContentWhenLoading = disable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableAutoLoadmore(boolean enable) {
        this.mEnableAutoLoadmore = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableOverScrollBounce(boolean enable) {
        this.mEnableOverScrollBounce = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnablePureScrollMode(boolean enable) {
        this.mEnablePureScrollMode = enable;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setEnableLoadmoreWhenContentNotFull(enable || this.mEnableLoadmoreWhenContentNotFull);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableScrollContentWhenLoaded(boolean enable) {
        this.mEnableScrollContentWhenLoaded = enable;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableLoadmoreWhenContentNotFull(boolean enable) {
        this.mEnableLoadmoreWhenContentNotFull = enable;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setEnableLoadmoreWhenContentNotFull(enable || this.mEnablePureScrollMode);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setRefreshHeader(RefreshHeader header) {
        if (header != null) {
            if (this.mRefreshHeader != null) {
                this.removeView(this.mRefreshHeader.getView());
            }
            this.mRefreshHeader = header;
            this.mHeaderHeightStatus = this.mHeaderHeightStatus.unNotify();
            this.addView(this.mRefreshHeader.getView());
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setRefreshHeader(RefreshHeader header, int width, int height) {
        if (header != null) {
            if (this.mRefreshHeader != null) {
                this.removeView(this.mRefreshHeader.getView());
            }
            this.mRefreshHeader = header;
            this.mHeaderHeightStatus = this.mHeaderHeightStatus.unNotify();
            this.addView(this.mRefreshHeader.getView(), width, height);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setRefreshFooter(RefreshFooter footer) {
        if (footer != null) {
            if (this.mRefreshFooter != null) {
                this.removeView(this.mRefreshFooter.getView());
            }
            this.mRefreshFooter = footer;
            this.mFooterHeightStatus = this.mFooterHeightStatus.unNotify();
            this.mEnableLoadmore = !this.mManualLoadmore || this.mEnableLoadmore;
            this.addView(this.mRefreshFooter.getView());
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setRefreshFooter(RefreshFooter footer, int width, int height) {
        if (footer != null) {
            if (this.mRefreshFooter != null) {
                this.removeView(this.mRefreshFooter.getView());
            }
            this.mRefreshFooter = footer;
            this.mFooterHeightStatus = this.mFooterHeightStatus.unNotify();
            this.mEnableLoadmore = !this.mManualLoadmore || this.mEnableLoadmore;
            this.addView(this.mRefreshFooter.getView(), width, height);
        }
        return this;
    }

    @Override
    @Nullable
    public RefreshFooter getRefreshFooter() {
        return this.mRefreshFooter;
    }

    @Override
    @Nullable
    public RefreshHeader getRefreshHeader() {
        return this.mRefreshHeader;
    }

    @Override
    public RefreshState getState() {
        return this.mState;
    }

    @Override
    public SmartRefreshLayout getLayout() {
        return this;
    }

    @Override
    public SmartRefreshLayout setOnRefreshListener(OnRefreshListener listener) {
        this.mRefreshListener = listener;
        return this;
    }

    @Override
    public SmartRefreshLayout setOnLoadmoreListener(OnLoadmoreListener listener) {
        this.mLoadmoreListener = listener;
        this.mEnableLoadmore = this.mEnableLoadmore || !this.mManualLoadmore && listener != null;
        return this;
    }

    @Override
    public SmartRefreshLayout setOnRefreshLoadmoreListener(OnRefreshLoadmoreListener listener) {
        this.mRefreshListener = listener;
        this.mLoadmoreListener = listener;
        this.mEnableLoadmore = this.mEnableLoadmore || !this.mManualLoadmore && listener != null;
        return this;
    }

    @Override
    public SmartRefreshLayout setOnMultiPurposeListener(OnMultiPurposeListener listener) {
        this.mOnMultiPurposeListener = listener;
        return this;
    }

    @Override
    public SmartRefreshLayout setPrimaryColorsId(int ... primaryColorId) {
        int[] colors = new int[primaryColorId.length];
        for (int i = 0; i < primaryColorId.length; ++i) {
            colors[i] = ContextCompat.getColor((Context)this.getContext(), (int)primaryColorId[i]);
        }
        this.setPrimaryColors(colors);
        return this;
    }

    @Override
    public SmartRefreshLayout setPrimaryColors(int ... colors) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setPrimaryColors(colors);
        }
        if (this.mRefreshFooter != null) {
            this.mRefreshFooter.setPrimaryColors(colors);
        }
        this.mPrimaryColors = colors;
        return this;
    }

    @Override
    public RefreshLayout setRefreshScrollBoundary(RefreshScrollBoundary boundary) {
        this.mRefreshScrollBoundary = boundary;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setRefreshScrollBoundary(boundary);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setLoadmoreFinished(boolean finished) {
        this.mLoadmoreFinished = finished;
        if (this.mRefreshFooter != null) {
            this.mRefreshFooter.setLoadmoreFinished(finished);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout finishRefresh() {
        long passTime = System.currentTimeMillis() - this.mLastRefreshingTime;
        return this.finishRefresh(Math.max(0, 1000 - (int)passTime));
    }

    @Override
    public SmartRefreshLayout finishLoadmore() {
        long passTime = System.currentTimeMillis() - this.mLastLoadingTime;
        return this.finishLoadmore(Math.max(0, 1000 - (int)passTime));
    }

    @Override
    public SmartRefreshLayout finishRefresh(int delayed) {
        return this.finishRefresh(delayed, true);
    }

    @Override
    public SmartRefreshLayout finishRefresh(boolean success) {
        long passTime = System.currentTimeMillis() - this.mLastRefreshingTime;
        return this.finishRefresh(Math.max(0, 1000 - (int)passTime), success);
    }

    @Override
    public SmartRefreshLayout finishRefresh(int delayed, final boolean success) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SmartRefreshLayout.this.mState == RefreshState.Refreshing) {
                    if (SmartRefreshLayout.this.mRefreshHeader != null) {
                        int startDelay = SmartRefreshLayout.this.mRefreshHeader.onFinish(SmartRefreshLayout.this, success);
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.RefreshFinish);
                        if (SmartRefreshLayout.this.mOnMultiPurposeListener != null) {
                            SmartRefreshLayout.this.mOnMultiPurposeListener.onHeaderFinish(SmartRefreshLayout.this.mRefreshHeader, success);
                        }
                        if (startDelay < Integer.MAX_VALUE) {
                            if (SmartRefreshLayout.this.mSpinner == 0) {
                                SmartRefreshLayout.this.resetStatus();
                            } else {
                                SmartRefreshLayout.this.animSpinner(0, startDelay);
                            }
                        }
                    } else {
                        SmartRefreshLayout.this.resetStatus();
                    }
                }
            }
        }, delayed);
        return this;
    }

    @Override
    public SmartRefreshLayout finishLoadmore(int delayed) {
        return this.finishLoadmore(delayed, true);
    }

    @Override
    public SmartRefreshLayout finishLoadmore(boolean success) {
        long passTime = System.currentTimeMillis() - this.mLastLoadingTime;
        return this.finishLoadmore(Math.max(0, 1000 - (int)passTime), success);
    }

    @Override
    public SmartRefreshLayout finishLoadmore(int delayed, final boolean success) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SmartRefreshLayout.this.mState == RefreshState.Loading) {
                    if (SmartRefreshLayout.this.mRefreshFooter != null && SmartRefreshLayout.this.mKernel != null && SmartRefreshLayout.this.mRefreshContent != null) {
                        int startDelay = SmartRefreshLayout.this.mRefreshFooter.onFinish(SmartRefreshLayout.this, success);
                        if (startDelay == Integer.MAX_VALUE) {
                            return;
                        }
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.LoadFinish);
                        ValueAnimator.AnimatorUpdateListener updateListener = SmartRefreshLayout.this.mRefreshContent.onLoadingFinish(SmartRefreshLayout.this.mKernel, SmartRefreshLayout.this.mFooterHeight, startDelay, SmartRefreshLayout.this.mReboundDuration);
                        if (SmartRefreshLayout.this.mOnMultiPurposeListener != null) {
                            SmartRefreshLayout.this.mOnMultiPurposeListener.onFooterFinish(SmartRefreshLayout.this.mRefreshFooter, success);
                        }
                        if (SmartRefreshLayout.this.mSpinner == 0) {
                            SmartRefreshLayout.this.resetStatus();
                        } else {
                            ValueAnimator valueAnimator = SmartRefreshLayout.this.animSpinner(0, startDelay);
                            if (updateListener != null && valueAnimator != null) {
                                valueAnimator.addUpdateListener(updateListener);
                            }
                        }
                    } else {
                        SmartRefreshLayout.this.resetStatus();
                    }
                }
            }
        }, delayed);
        return this;
    }

    @Override
    public boolean isRefreshing() {
        return this.mState == RefreshState.Refreshing;
    }

    @Override
    public boolean isLoading() {
        return this.mState == RefreshState.Loading;
    }

    @Override
    public boolean autoRefresh() {
        return this.autoRefresh(400);
    }

    @Override
    public boolean autoRefresh(int delayed) {
        return this.autoRefresh(delayed, 1.0f * (float)(this.mHeaderHeight + this.mHeaderExtendHeight / 2) / (float)this.mHeaderHeight);
    }

    @Override
    public boolean autoRefresh(int delayed, final float dragrate) {
        if (this.mState == RefreshState.None && this.mEnableRefresh) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, (int)((float)SmartRefreshLayout.this.mHeaderHeight * dragrate)});
                    SmartRefreshLayout.this.reboundAnimator.setDuration((long)SmartRefreshLayout.this.mReboundDuration);
                    SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                    SmartRefreshLayout.this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            SmartRefreshLayout.this.moveSpinner((Integer)animation.getAnimatedValue(), false);
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animation) {
                            SmartRefreshLayout.this.mLastTouchX = SmartRefreshLayout.this.getMeasuredWidth() / 2;
                            SmartRefreshLayout.this.setStatePullDownToRefresh();
                        }

                        public void onAnimationEnd(Animator animation) {
                            SmartRefreshLayout.this.reboundAnimator = null;
                            if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToRefresh) {
                                SmartRefreshLayout.this.setStateReleaseToRefresh();
                            }
                            SmartRefreshLayout.this.overSpinner();
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.start();
                }
            };
            if (delayed > 0) {
                this.reboundAnimator = new ValueAnimator();
                this.postDelayed(runnable, delayed);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean autoDrop() {
        return this.autoDrop(500);
    }

    @Override
    public boolean autoDrop(int delayed) {
        return this.autoDrop(delayed, 1.0f * (float)(this.mHeaderHeight + this.mHeaderExtendHeight / 2) / (float)this.mHeaderHeight);
    }

    @Override
    public boolean autoDrop(int delayed, float dragrate) {
        if (this.mState == RefreshState.None && this.mEnableRefresh) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (SmartRefreshLayout.this.mState != RefreshState.Dropping) {
                        SmartRefreshLayout.this.setStateReleaseToDrop();
                    }
                    SmartRefreshLayout.this.overSpinner();
                }
            }, delayed);
            return true;
        }
        return false;
    }

    @Override
    public boolean autoLoadmore() {
        return this.autoLoadmore(0);
    }

    @Override
    public boolean autoLoadmore(int delayed) {
        return this.autoLoadmore(delayed, 1.0f * (float)(this.mFooterHeight + this.mFooterExtendHeight / 2) / (float)this.mFooterHeight);
    }

    @Override
    public boolean autoLoadmore(int delayed, final float dragrate) {
        if (this.mState == RefreshState.None && this.mEnableLoadmore && !this.mLoadmoreFinished) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, -((int)((float)SmartRefreshLayout.this.mFooterHeight * dragrate))});
                    SmartRefreshLayout.this.reboundAnimator.setDuration((long)SmartRefreshLayout.this.mReboundDuration);
                    SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                    SmartRefreshLayout.this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            SmartRefreshLayout.this.moveSpinner((Integer)animation.getAnimatedValue(), false);
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animation) {
                            SmartRefreshLayout.this.mLastTouchX = SmartRefreshLayout.this.getMeasuredWidth() / 2;
                            SmartRefreshLayout.this.setStatePullUpToLoad();
                        }

                        public void onAnimationEnd(Animator animation) {
                            SmartRefreshLayout.this.reboundAnimator = null;
                            if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToLoad) {
                                SmartRefreshLayout.this.setStateReleaseToLoad();
                            }
                            SmartRefreshLayout.this.overSpinner();
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.start();
                }
            };
            if (delayed > 0) {
                this.reboundAnimator = new ValueAnimator();
                this.postDelayed(runnable, delayed);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnableLoadmore() {
        return this.mEnableLoadmore;
    }

    @Override
    public boolean isLoadmoreFinished() {
        return this.mLoadmoreFinished;
    }

    @Override
    public boolean isEnableAutoLoadmore() {
        return this.mEnableAutoLoadmore;
    }

    @Override
    public boolean isEnableRefresh() {
        return this.mEnableRefresh;
    }

    @Override
    public boolean isEnableOverScrollBounce() {
        return this.mEnableOverScrollBounce;
    }

    @Override
    public boolean isEnablePureScrollMode() {
        return this.mEnablePureScrollMode;
    }

    @Override
    public boolean isEnableScrollContentWhenLoaded() {
        return this.mEnableScrollContentWhenLoaded;
    }

    public static void setDefaultRefreshHeaderCreater(@NonNull DefaultRefreshHeaderCreater creater) {
        sHeaderCreater = creater;
    }

    public static void setDefaultRefreshFooterCreater(@NonNull DefaultRefreshFooterCreater creater) {
        sFooterCreater = creater;
        sManualFooterCreater = true;
    }

    public boolean post(Runnable action) {
        if (this.handler == null) {
            this.mDelayedRunables = this.mDelayedRunables == null ? new ArrayList() : this.mDelayedRunables;
            this.mDelayedRunables.add(new DelayedRunable(action));
            return false;
        }
        return this.handler.post((Runnable)new DelayedRunable(action));
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        if (this.handler == null) {
            this.mDelayedRunables = this.mDelayedRunables == null ? new ArrayList() : this.mDelayedRunables;
            this.mDelayedRunables.add(new DelayedRunable(action, delayMillis));
            return false;
        }
        return this.handler.postDelayed((Runnable)new DelayedRunable(action), delayMillis);
    }

    protected class RefreshKernelImpl
    implements RefreshKernel {
        protected RefreshKernelImpl() {
        }

        @Override
        @NonNull
        public RefreshLayout getRefreshLayout() {
            return SmartRefreshLayout.this;
        }

        @Override
        @NonNull
        public RefreshContent getRefreshContent() {
            return SmartRefreshLayout.this.mRefreshContent;
        }

        @Override
        public RefreshKernel setStatePullUpToLoad() {
            SmartRefreshLayout.this.setStatePullUpToLoad();
            return this;
        }

        @Override
        public RefreshKernel setStateReleaseToLoad() {
            SmartRefreshLayout.this.setStateReleaseToLoad();
            return this;
        }

        @Override
        public RefreshKernel setStateReleaseToRefresh() {
            SmartRefreshLayout.this.setStateReleaseToRefresh();
            return this;
        }

        public RefreshKernel setStateReleaseToDrop() {
            SmartRefreshLayout.this.setStateReleaseToDrop();
            return this;
        }

        public RefreshKernel setStateDropping() {
            SmartRefreshLayout.this.setStateDropping();
            return this;
        }

        @Override
        public RefreshKernel setStatePullDownToRefresh() {
            SmartRefreshLayout.this.setStatePullDownToRefresh();
            return this;
        }

        @Override
        public RefreshKernel setStatePullDownCanceled() {
            SmartRefreshLayout.this.setStatePullDownCanceled();
            return this;
        }

        @Override
        public RefreshKernel setStatePullUpCanceled() {
            SmartRefreshLayout.this.setStatePullUpCanceled();
            return this;
        }

        @Override
        public RefreshKernel setStateLoding() {
            SmartRefreshLayout.this.setStateLoding();
            return this;
        }

        @Override
        public RefreshKernel setStateRefresing() {
            SmartRefreshLayout.this.setStateRefresing();
            return this;
        }

        @Override
        public RefreshKernel setStateLodingFinish() {
            SmartRefreshLayout.this.setStateLodingFinish();
            return this;
        }

        @Override
        public RefreshKernel setStateRefresingFinish() {
            SmartRefreshLayout.this.setStateRefresingFinish();
            return this;
        }

        @Override
        public RefreshKernel resetStatus() {
            SmartRefreshLayout.this.resetStatus();
            return this;
        }

        @Override
        public RefreshKernel overSpinner() {
            SmartRefreshLayout.this.overSpinner();
            return this;
        }

        @Override
        public RefreshKernel moveSpinnerInfinitely(float dy) {
            SmartRefreshLayout.this.moveSpinnerInfinitely(dy);
            return this;
        }

        @Override
        public RefreshKernel moveSpinner(int spinner, boolean isAnimator) {
            SmartRefreshLayout.this.moveSpinner(spinner, isAnimator);
            return this;
        }

        @Override
        public RefreshKernel animSpinner(int endSpinner) {
            SmartRefreshLayout.this.animSpinner(endSpinner);
            return this;
        }

        @Override
        public RefreshKernel animSpinnerBounce(int bounceSpinner) {
            SmartRefreshLayout.this.animSpinnerBounce(bounceSpinner);
            return this;
        }

        @Override
        public int getSpinner() {
            return SmartRefreshLayout.this.mSpinner;
        }

        @Override
        public RefreshKernel requestDrawBackgoundForHeader(int backgroundColor) {
            if (SmartRefreshLayout.this.mPaint == null && backgroundColor != 0) {
                SmartRefreshLayout.this.mPaint = new Paint();
            }
            SmartRefreshLayout.this.mHeaderBackgroundColor = backgroundColor;
            return this;
        }

        @Override
        public RefreshKernel requestDrawBackgoundForFooter(int backgroundColor) {
            if (SmartRefreshLayout.this.mPaint == null && backgroundColor != 0) {
                SmartRefreshLayout.this.mPaint = new Paint();
            }
            SmartRefreshLayout.this.mFooterBackgroundColor = backgroundColor;
            return this;
        }

        @Override
        public RefreshKernel requestHeaderNeedTouchEventWhenRefreshing(boolean request) {
            SmartRefreshLayout.this.mHeaderNeedTouchEventWhenRefreshing = request;
            return this;
        }

        @Override
        public RefreshKernel requestFooterNeedTouchEventWhenLoading(boolean request) {
            SmartRefreshLayout.this.mFooterNeedTouchEventWhenRefreshing = request;
            return this;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int backgroundColor = 0;
        public SpinnerStyle spinnerStyle = null;

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SmartRefreshLayout_Layout);
            this.backgroundColor = ta.getColor(R.styleable.SmartRefreshLayout_Layout_srlBackgroundColor, this.backgroundColor);
            if (ta.hasValue(R.styleable.SmartRefreshLayout_Layout_srlSpinnerStyle)) {
                this.spinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.SmartRefreshLayout_Layout_srlSpinnerStyle, SpinnerStyle.Translate.ordinal())];
            }
            ta.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

