/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.utils;

import com.yy.mobile.logs.MLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class SHAUtils {
    private static final String feq = "SHAUtils";

    private static String fer(String string2, String string3) {
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            return null;
        }
        String string4 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string3);
            messageDigest.update(string2.getBytes("UTF-8"));
            string4 = SHAUtils.feu(messageDigest.digest());
        }
        catch (Exception exception) {
            MLog.eb.ei(feq, "digest error! " + exception.toString(), new Object[0]);
        }
        return string4;
    }

    public static String eko(String string2) throws IOException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        File file = new File(string2);
        return SHAUtils.ekp(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ekp(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        String string2 = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(mappedByteBuffer);
            string2 = SHAUtils.fes(messageDigest.digest());
        }
        catch (Exception exception) {
            MLog.eb.ei(feq, "digest error! " + exception.toString(), new Object[0]);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                MLog.eb.ei(feq, exception.getLocalizedMessage(), new Object[0]);
            }
        }
        return string2;
    }

    private static String fes(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return SHAUtils.fet(byArray, 0, byArray.length);
    }

    private static String fet(byte[] byArray, int n, int n2) {
        if (byArray == null || n < 0 || n2 < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            String string2 = Integer.toHexString(0xFF & byArray[i]);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String ekq(String string2) {
        return SHAUtils.fer(string2, "SHA-1");
    }

    public static String ekr(String string2) {
        return SHAUtils.fer(string2, "SHA-256");
    }

    public static String eks(String string2) {
        return SHAUtils.fer(string2, "SHA-384");
    }

    public static String ekt(String string2) {
        return SHAUtils.fer(string2, "SHA-512");
    }

    public static String eku(String string2, String string3) {
        return SHAUtils.fer(string2, string3);
    }

    private static String feu(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(0xFF & byArray[i]);
            if (string2.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static boolean ekv(String string2, String string3) {
        try {
            String string4 = SHAUtils.ekw(string2);
            return string4.equals(string3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String ekw(String string2) throws Exception {
        byte[] byArray = SHAUtils.ekx(string2, "SHA1");
        String string3 = "";
        for (int i = 0; i < byArray.length; ++i) {
            string3 = string3 + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string3;
    }

    public static byte[] ekx(String string2, String string3) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string2);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance(string3);
        do {
            if ((n = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
            messageDigest.update(byArray, 0, n);
        } while (n != -1);
        ((InputStream)fileInputStream).close();
        return messageDigest.digest();
    }
}

