/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.smartrefreshlayout.util;

import android.graphics.Color;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;

public final class ColorUtils {
    private static final double ezs = 95.047;
    private static final double ezt = 100.0;
    private static final double ezu = 108.883;
    private static final double ezv = 0.008856;
    private static final double ezw = 903.3;
    private static final int ezx = 10;
    private static final int ezy = 1;
    private static final ThreadLocal<double[]> ezz = new ThreadLocal();

    private ColorUtils() {
    }

    public static int eec(@ColorInt int n, @ColorInt int n2) {
        int n3 = Color.alpha((int)n2);
        int n4 = Color.alpha((int)n);
        int n5 = ColorUtils.faa(n4, n3);
        int n6 = ColorUtils.fab(Color.red((int)n), n4, Color.red((int)n2), n3, n5);
        int n7 = ColorUtils.fab(Color.green((int)n), n4, Color.green((int)n2), n3, n5);
        int n8 = ColorUtils.fab(Color.blue((int)n), n4, Color.blue((int)n2), n3, n5);
        return Color.argb((int)n5, (int)n6, (int)n7, (int)n8);
    }

    private static int faa(int n, int n2) {
        return 255 - (255 - n2) * (255 - n) / 255;
    }

    private static int fab(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 0) {
            return 0;
        }
        return (255 * n * n2 + n3 * n4 * (255 - n2)) / (n5 * 255);
    }

    @FloatRange(from=0.0, to=1.0)
    public static double eed(@ColorInt int n) {
        double[] dArray = ColorUtils.faf();
        ColorUtils.eem(n, dArray);
        return dArray[1] / 100.0;
    }

    public static double eee(@ColorInt int n, @ColorInt int n2) {
        if (Color.alpha((int)n2) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(n2));
        }
        if (Color.alpha((int)n) < 255) {
            n = ColorUtils.eec(n, n2);
        }
        double d = ColorUtils.eed(n) + 0.05;
        double d2 = ColorUtils.eed(n2) + 0.05;
        return Math.max(d, d2) / Math.min(d, d2);
    }

    public static int eef(@ColorInt int n, @ColorInt int n2, float f) {
        if (Color.alpha((int)n2) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(n2));
        }
        int n3 = ColorUtils.eej(n, 255);
        double d = ColorUtils.eee(n3, n2);
        if (d < (double)f) {
            return -1;
        }
        int n4 = 0;
        int n5 = 255;
        for (int i = 0; i <= 10 && n5 - n4 > 1; ++i) {
            int n6 = (n4 + n5) / 2;
            n3 = ColorUtils.eej(n, n6);
            d = ColorUtils.eee(n3, n2);
            if (d < (double)f) {
                n4 = n6;
                continue;
            }
            n5 = n6;
        }
        return n5;
    }

    public static void eeg(@IntRange(from=0L, to=255L) int n, @IntRange(from=0L, to=255L) int n2, @IntRange(from=0L, to=255L) int n3, @NonNull float[] fArray) {
        float f;
        float f2;
        float f3 = (float)n / 255.0f;
        float f4 = (float)n2 / 255.0f;
        float f5 = (float)n3 / 255.0f;
        float f6 = Math.max(f3, Math.max(f4, f5));
        float f7 = Math.min(f3, Math.min(f4, f5));
        float f8 = f6 - f7;
        float f9 = (f6 + f7) / 2.0f;
        if (f6 == f7) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            f = f6 == f3 ? (f4 - f5) / f8 % 6.0f : (f6 == f4 ? (f5 - f3) / f8 + 2.0f : (f3 - f4) / f8 + 4.0f);
            f2 = f8 / (1.0f - Math.abs(2.0f * f9 - 1.0f));
        }
        f = f * 60.0f % 360.0f;
        if (f < 0.0f) {
            f += 360.0f;
        }
        fArray[0] = ColorUtils.fac(f, 0.0f, 360.0f);
        fArray[1] = ColorUtils.fac(f2, 0.0f, 1.0f);
        fArray[2] = ColorUtils.fac(f9, 0.0f, 1.0f);
    }

    public static void eeh(@ColorInt int n, @NonNull float[] fArray) {
        ColorUtils.eeg(Color.red((int)n), Color.green((int)n), Color.blue((int)n), fArray);
    }

    @ColorInt
    public static int eei(@NonNull float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = (1.0f - Math.abs(2.0f * f3 - 1.0f)) * f2;
        float f5 = f3 - 0.5f * f4;
        float f6 = f4 * (1.0f - Math.abs(f / 60.0f % 2.0f - 1.0f));
        int n = (int)f / 60;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n2 = Math.round(255.0f * (f4 + f5));
                n3 = Math.round(255.0f * (f6 + f5));
                n4 = Math.round(255.0f * f5);
                break;
            }
            case 1: {
                n2 = Math.round(255.0f * (f6 + f5));
                n3 = Math.round(255.0f * (f4 + f5));
                n4 = Math.round(255.0f * f5);
                break;
            }
            case 2: {
                n2 = Math.round(255.0f * f5);
                n3 = Math.round(255.0f * (f4 + f5));
                n4 = Math.round(255.0f * (f6 + f5));
                break;
            }
            case 3: {
                n2 = Math.round(255.0f * f5);
                n3 = Math.round(255.0f * (f6 + f5));
                n4 = Math.round(255.0f * (f4 + f5));
                break;
            }
            case 4: {
                n2 = Math.round(255.0f * (f6 + f5));
                n3 = Math.round(255.0f * f5);
                n4 = Math.round(255.0f * (f4 + f5));
                break;
            }
            case 5: 
            case 6: {
                n2 = Math.round(255.0f * (f4 + f5));
                n3 = Math.round(255.0f * f5);
                n4 = Math.round(255.0f * (f6 + f5));
                break;
            }
        }
        n2 = ColorUtils.fad(n2, 0, 255);
        n3 = ColorUtils.fad(n3, 0, 255);
        n4 = ColorUtils.fad(n4, 0, 255);
        return Color.rgb((int)n2, (int)n3, (int)n4);
    }

    @ColorInt
    public static int eej(@ColorInt int n, @IntRange(from=0L, to=255L) int n2) {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return n & 0xFFFFFF | n2 << 24;
    }

    public static void eek(@ColorInt int n, @NonNull double[] dArray) {
        ColorUtils.eel(Color.red((int)n), Color.green((int)n), Color.blue((int)n), dArray);
    }

    public static void eel(@IntRange(from=0L, to=255L) int n, @IntRange(from=0L, to=255L) int n2, @IntRange(from=0L, to=255L) int n3, @NonNull double[] dArray) {
        ColorUtils.een(n, n2, n3, dArray);
        ColorUtils.eeo(dArray[0], dArray[1], dArray[2], dArray);
    }

    public static void eem(@ColorInt int n, @NonNull double[] dArray) {
        ColorUtils.een(Color.red((int)n), Color.green((int)n), Color.blue((int)n), dArray);
    }

    public static void een(@IntRange(from=0L, to=255L) int n, @IntRange(from=0L, to=255L) int n2, @IntRange(from=0L, to=255L) int n3, @NonNull double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("outXyz must have a length of 3.");
        }
        double d = (double)n / 255.0;
        d = d < 0.04045 ? d / 12.92 : Math.pow((d + 0.055) / 1.055, 2.4);
        double d2 = (double)n2 / 255.0;
        d2 = d2 < 0.04045 ? d2 / 12.92 : Math.pow((d2 + 0.055) / 1.055, 2.4);
        double d3 = (double)n3 / 255.0;
        d3 = d3 < 0.04045 ? d3 / 12.92 : Math.pow((d3 + 0.055) / 1.055, 2.4);
        dArray[0] = 100.0 * (d * 0.4124 + d2 * 0.3576 + d3 * 0.1805);
        dArray[1] = 100.0 * (d * 0.2126 + d2 * 0.7152 + d3 * 0.0722);
        dArray[2] = 100.0 * (d * 0.0193 + d2 * 0.1192 + d3 * 0.9505);
    }

    public static void eeo(@FloatRange(from=0.0, to=95.047) double d, @FloatRange(from=0.0, to=100.0) double d2, @FloatRange(from=0.0, to=108.883) double d3, @NonNull double[] dArray) {
        if (dArray.length != 3) {
            throw new IllegalArgumentException("outLab must have a length of 3.");
        }
        d = ColorUtils.fae(d / 95.047);
        d2 = ColorUtils.fae(d2 / 100.0);
        d3 = ColorUtils.fae(d3 / 108.883);
        dArray[0] = Math.max(0.0, 116.0 * d2 - 16.0);
        dArray[1] = 500.0 * (d - d2);
        dArray[2] = 200.0 * (d2 - d3);
    }

    public static void eep(@FloatRange(from=0.0, to=100.0) double d, @FloatRange(from=-128.0, to=127.0) double d2, @FloatRange(from=-128.0, to=127.0) double d3, @NonNull double[] dArray) {
        double d4 = (d + 16.0) / 116.0;
        double d5 = d2 / 500.0 + d4;
        double d6 = d4 - d3 / 200.0;
        double d7 = Math.pow(d5, 3.0);
        double d8 = d7 > 0.008856 ? d7 : (116.0 * d5 - 16.0) / 903.3;
        double d9 = d > 7.9996247999999985 ? Math.pow(d4, 3.0) : d / 903.3;
        d7 = Math.pow(d6, 3.0);
        double d10 = d7 > 0.008856 ? d7 : (116.0 * d6 - 16.0) / 903.3;
        dArray[0] = d8 * 95.047;
        dArray[1] = d9 * 100.0;
        dArray[2] = d10 * 108.883;
    }

    @ColorInt
    public static int eeq(@FloatRange(from=0.0, to=95.047) double d, @FloatRange(from=0.0, to=100.0) double d2, @FloatRange(from=0.0, to=108.883) double d3) {
        double d4 = (d * 3.2406 + d2 * -1.5372 + d3 * -0.4986) / 100.0;
        double d5 = (d * -0.9689 + d2 * 1.8758 + d3 * 0.0415) / 100.0;
        double d6 = (d * 0.0557 + d2 * -0.204 + d3 * 1.057) / 100.0;
        d4 = d4 > 0.0031308 ? 1.055 * Math.pow(d4, 0.4166666666666667) - 0.055 : 12.92 * d4;
        d5 = d5 > 0.0031308 ? 1.055 * Math.pow(d5, 0.4166666666666667) - 0.055 : 12.92 * d5;
        d6 = d6 > 0.0031308 ? 1.055 * Math.pow(d6, 0.4166666666666667) - 0.055 : 12.92 * d6;
        return Color.rgb((int)ColorUtils.fad((int)Math.round(d4 * 255.0), 0, 255), (int)ColorUtils.fad((int)Math.round(d5 * 255.0), 0, 255), (int)ColorUtils.fad((int)Math.round(d6 * 255.0), 0, 255));
    }

    @ColorInt
    public static int eer(@FloatRange(from=0.0, to=100.0) double d, @FloatRange(from=-128.0, to=127.0) double d2, @FloatRange(from=-128.0, to=127.0) double d3) {
        double[] dArray = ColorUtils.faf();
        ColorUtils.eep(d, d2, d3, dArray);
        return ColorUtils.eeq(dArray[0], dArray[1], dArray[2]);
    }

    public static double ees(@NonNull double[] dArray, @NonNull double[] dArray2) {
        return Math.sqrt(Math.pow(dArray[0] - dArray2[0], 2.0) + Math.pow(dArray[1] - dArray2[1], 2.0) + Math.pow(dArray[2] - dArray2[2], 2.0));
    }

    private static float fac(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    private static int fad(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    private static double fae(double d) {
        return d > 0.008856 ? Math.pow(d, 0.3333333333333333) : (903.3 * d + 16.0) / 116.0;
    }

    @ColorInt
    public static int eet(@ColorInt int n, @ColorInt int n2, @FloatRange(from=0.0, to=1.0) float f) {
        float f2 = 1.0f - f;
        float f3 = (float)Color.alpha((int)n) * f2 + (float)Color.alpha((int)n2) * f;
        float f4 = (float)Color.red((int)n) * f2 + (float)Color.red((int)n2) * f;
        float f5 = (float)Color.green((int)n) * f2 + (float)Color.green((int)n2) * f;
        float f6 = (float)Color.blue((int)n) * f2 + (float)Color.blue((int)n2) * f;
        return Color.argb((int)((int)f3), (int)((int)f4), (int)((int)f5), (int)((int)f6));
    }

    public static void eeu(@NonNull float[] fArray, @NonNull float[] fArray2, @FloatRange(from=0.0, to=1.0) float f, @NonNull float[] fArray3) {
        if (fArray3.length != 3) {
            throw new IllegalArgumentException("result must have a length of 3.");
        }
        float f2 = 1.0f - f;
        fArray3[0] = ColorUtils.eew(fArray[0], fArray2[0], f);
        fArray3[1] = fArray[1] * f2 + fArray2[1] * f;
        fArray3[2] = fArray[2] * f2 + fArray2[2] * f;
    }

    public static void eev(@NonNull double[] dArray, @NonNull double[] dArray2, @FloatRange(from=0.0, to=1.0) double d, @NonNull double[] dArray3) {
        if (dArray3.length != 3) {
            throw new IllegalArgumentException("outResult must have a length of 3.");
        }
        double d2 = 1.0 - d;
        dArray3[0] = dArray[0] * d2 + dArray2[0] * d;
        dArray3[1] = dArray[1] * d2 + dArray2[1] * d;
        dArray3[2] = dArray[2] * d2 + dArray2[2] * d;
    }

    @VisibleForTesting
    static float eew(float f, float f2, float f3) {
        if (Math.abs(f2 - f) > 180.0f) {
            if (f2 > f) {
                f += 360.0f;
            } else {
                f2 += 360.0f;
            }
        }
        return (f + (f2 - f) * f3) % 360.0f;
    }

    private static double[] faf() {
        double[] dArray = ezz.get();
        if (dArray == null) {
            dArray = new double[3];
            ezz.set(dArray);
        }
        return dArray;
    }
}

