/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.smartrefreshlayout.internal.pathview;

import android.graphics.Matrix;
import android.graphics.Path;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

class PathParser {
    PathParser() {
    }

    static float[] ecg(float[] fArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = fArray.length;
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        float[] fArray2 = new float[n4];
        System.arraycopy(fArray, n, fArray2, 0, n5);
        return fArray2;
    }

    public static List<Path> ech(float f, float f2, List<Path> list, List<String> list2) {
        Matrix matrix = new Matrix();
        matrix.setScale(f, f2);
        ArrayList<Path> arrayList = new ArrayList<Path>();
        if (Build.VERSION.SDK_INT > 16) {
            for (Path path : list) {
                Path path2 = new Path();
                path.transform(matrix, path2);
                arrayList.add(path2);
            }
        } else {
            for (String string2 : list2) {
                Path path = new Path();
                PathDataNode[] pathDataNodeArray = PathParser.ecj(string2);
                PathParser.ezf(f, f2, pathDataNodeArray);
                PathDataNode.eco(pathDataNodeArray, path);
                arrayList.add(path);
            }
        }
        return arrayList;
    }

    private static void ezf(float f, float f2, PathDataNode[] pathDataNodeArray) {
        for (int i = 0; i < pathDataNodeArray.length; ++i) {
            PathParser.ezg(f, f2, pathDataNodeArray[i].ecm, pathDataNodeArray[i].ecn);
        }
    }

    private static void ezg(float f, float f2, char c, float[] fArray) {
        int n = 2;
        switch (c) {
            case 'Z': 
            case 'z': {
                break;
            }
            case 'L': 
            case 'M': 
            case 'T': 
            case 'l': 
            case 'm': 
            case 't': {
                n = 2;
                break;
            }
            case 'H': 
            case 'V': 
            case 'h': 
            case 'v': {
                n = 1;
                break;
            }
            case 'C': 
            case 'c': {
                n = 6;
                break;
            }
            case 'Q': 
            case 'S': 
            case 'q': 
            case 's': {
                n = 4;
                break;
            }
            case 'A': 
            case 'a': {
                n = 7;
                break;
            }
        }
        block16: for (int i = 0; i < fArray.length; i += n) {
            switch (c) {
                case 'L': 
                case 'M': 
                case 'T': 
                case 'l': 
                case 'm': 
                case 't': {
                    int n2 = i;
                    fArray[n2] = fArray[n2] * f;
                    int n3 = i + 1;
                    fArray[n3] = fArray[n3] * f2;
                    continue block16;
                }
                case 'H': 
                case 'h': {
                    int n4 = i;
                    fArray[n4] = fArray[n4] * f;
                    continue block16;
                }
                case 'V': 
                case 'v': {
                    int n5 = i;
                    fArray[n5] = fArray[n5] * f2;
                    continue block16;
                }
                case 'C': 
                case 'c': {
                    int n6 = i;
                    fArray[n6] = fArray[n6] * f;
                    int n7 = i + 1;
                    fArray[n7] = fArray[n7] * f2;
                    int n8 = i + 2;
                    fArray[n8] = fArray[n8] * f;
                    int n9 = i + 3;
                    fArray[n9] = fArray[n9] * f2;
                    int n10 = i + 4;
                    fArray[n10] = fArray[n10] * f;
                    int n11 = i + 5;
                    fArray[n11] = fArray[n11] * f2;
                    continue block16;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    int n12 = i;
                    fArray[n12] = fArray[n12] * f;
                    int n13 = i + 1;
                    fArray[n13] = fArray[n13] * f2;
                    int n14 = i + 2;
                    fArray[n14] = fArray[n14] * f;
                    int n15 = i + 3;
                    fArray[n15] = fArray[n15] * f2;
                }
                case 'A': 
                case 'a': {
                    int n16 = i;
                    fArray[n16] = fArray[n16] * f;
                    int n17 = i + 1;
                    fArray[n17] = fArray[n17] * f2;
                    int n18 = i + 5;
                    fArray[n18] = fArray[n18] * f;
                    int n19 = i + 6;
                    fArray[n19] = fArray[n19] * f2;
                    continue block16;
                }
            }
        }
    }

    public static Path eci(String string2) {
        Path path = new Path();
        PathDataNode[] pathDataNodeArray = PathParser.ecj(string2);
        if (pathDataNodeArray != null) {
            try {
                PathDataNode.eco(pathDataNodeArray, path);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Error in parsing " + string2, runtimeException);
            }
            return path;
        }
        return null;
    }

    public static PathDataNode[] ecj(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = 0;
        int n2 = 1;
        ArrayList<PathDataNode> arrayList = new ArrayList<PathDataNode>();
        while (n2 < string2.length()) {
            String string3 = string2.substring(n, n2 = PathParser.ezh(string2, n2)).trim();
            if (string3.length() > 0) {
                float[] fArray = PathParser.ezj(string3);
                PathParser.ezi(arrayList, string3.charAt(0), fArray);
            }
            n = n2++;
        }
        if (n2 - n == 1 && n < string2.length()) {
            PathParser.ezi(arrayList, string2.charAt(n), new float[0]);
        }
        return arrayList.toArray(new PathDataNode[arrayList.size()]);
    }

    private static int ezh(String string2, int n) {
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return n;
            }
            ++n;
        }
        return n;
    }

    private static void ezi(ArrayList<PathDataNode> arrayList, char c, float[] fArray) {
        arrayList.add(new PathDataNode(c, fArray));
    }

    private static float[] ezj(String string2) {
        if (string2.charAt(0) == 'z' | string2.charAt(0) == 'Z') {
            return new float[0];
        }
        try {
            float[] fArray = new float[string2.length()];
            int n = 0;
            int n2 = 1;
            int n3 = 0;
            ExtractFloatResult extractFloatResult = new ExtractFloatResult();
            int n4 = string2.length();
            while (n2 < n4) {
                PathParser.ezk(string2, n2, extractFloatResult);
                n3 = extractFloatResult.eck;
                if (n2 < n3) {
                    fArray[n++] = Float.parseFloat(string2.substring(n2, n3));
                }
                if (extractFloatResult.ecl) {
                    n2 = n3;
                    continue;
                }
                n2 = n3 + 1;
            }
            return PathParser.ecg(fArray, 0, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("error in parsing \"" + string2 + "\"", numberFormatException);
        }
    }

    private static void ezk(String string2, int n, ExtractFloatResult extractFloatResult) {
        int n2;
        boolean bl = false;
        extractFloatResult.ecl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = n; n2 < string2.length(); ++n2) {
            boolean bl4 = bl3;
            bl3 = false;
            char c = string2.charAt(n2);
            switch (c) {
                case ' ': 
                case ',': {
                    bl = true;
                    break;
                }
                case '-': {
                    if (n2 == n || bl4) break;
                    bl = true;
                    extractFloatResult.ecl = true;
                    break;
                }
                case '.': {
                    if (!bl2) {
                        bl2 = true;
                        break;
                    }
                    bl = true;
                    extractFloatResult.ecl = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    bl3 = true;
                    break;
                }
            }
            if (bl) break;
        }
        extractFloatResult.eck = n2;
    }

    public static class PathDataNode {
        char ecm;
        float[] ecn;

        PathDataNode(char c, float[] fArray) {
            this.ecm = c;
            this.ecn = fArray;
        }

        PathDataNode(PathDataNode pathDataNode) {
            this.ecm = pathDataNode.ecm;
            this.ecn = PathParser.ecg(pathDataNode.ecn, 0, pathDataNode.ecn.length);
        }

        public static void eco(PathDataNode[] pathDataNodeArray, Path path) {
            float[] fArray = new float[6];
            char c = 'm';
            for (int i = 0; i < pathDataNodeArray.length; ++i) {
                PathDataNode.ezl(path, fArray, c, pathDataNodeArray[i].ecm, pathDataNodeArray[i].ecn);
                c = pathDataNodeArray[i].ecm;
            }
        }

        public void ecp(PathDataNode pathDataNode, PathDataNode pathDataNode2, float f) {
            for (int i = 0; i < pathDataNode.ecn.length; ++i) {
                this.ecn[i] = pathDataNode.ecn[i] * (1.0f - f) + pathDataNode2.ecn[i] * f;
            }
        }

        private static void ezl(Path path, float[] fArray, char c, char c2, float[] fArray2) {
            int n = 2;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray[3];
            float f5 = fArray[4];
            float f6 = fArray[5];
            switch (c2) {
                case 'Z': 
                case 'z': {
                    path.close();
                    f = f5;
                    f2 = f6;
                    f3 = f5;
                    f4 = f6;
                    path.moveTo(f, f2);
                    break;
                }
                case 'L': 
                case 'M': 
                case 'T': 
                case 'l': 
                case 'm': 
                case 't': {
                    n = 2;
                    break;
                }
                case 'H': 
                case 'V': 
                case 'h': 
                case 'v': {
                    n = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    n = 6;
                    break;
                }
                case 'Q': 
                case 'S': 
                case 'q': 
                case 's': {
                    n = 4;
                    break;
                }
                case 'A': 
                case 'a': {
                    n = 7;
                    break;
                }
            }
            for (int i = 0; i < fArray2.length; i += n) {
                switch (c2) {
                    case 'm': {
                        f += fArray2[i + 0];
                        f2 += fArray2[i + 1];
                        if (i > 0) {
                            path.rLineTo(fArray2[i + 0], fArray2[i + 1]);
                            break;
                        }
                        path.rMoveTo(fArray2[i + 0], fArray2[i + 1]);
                        f5 = f;
                        f6 = f2;
                        break;
                    }
                    case 'M': {
                        f = fArray2[i + 0];
                        f2 = fArray2[i + 1];
                        if (i > 0) {
                            path.lineTo(fArray2[i + 0], fArray2[i + 1]);
                            break;
                        }
                        path.moveTo(fArray2[i + 0], fArray2[i + 1]);
                        f5 = f;
                        f6 = f2;
                        break;
                    }
                    case 'l': {
                        path.rLineTo(fArray2[i + 0], fArray2[i + 1]);
                        f += fArray2[i + 0];
                        f2 += fArray2[i + 1];
                        break;
                    }
                    case 'L': {
                        path.lineTo(fArray2[i + 0], fArray2[i + 1]);
                        f = fArray2[i + 0];
                        f2 = fArray2[i + 1];
                        break;
                    }
                    case 'h': {
                        path.rLineTo(fArray2[i + 0], 0.0f);
                        f += fArray2[i + 0];
                        break;
                    }
                    case 'H': {
                        path.lineTo(fArray2[i + 0], f2);
                        f = fArray2[i + 0];
                        break;
                    }
                    case 'v': {
                        path.rLineTo(0.0f, fArray2[i + 0]);
                        f2 += fArray2[i + 0];
                        break;
                    }
                    case 'V': {
                        path.lineTo(f, fArray2[i + 0]);
                        f2 = fArray2[i + 0];
                        break;
                    }
                    case 'c': {
                        path.rCubicTo(fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3], fArray2[i + 4], fArray2[i + 5]);
                        f3 = f + fArray2[i + 2];
                        f4 = f2 + fArray2[i + 3];
                        f += fArray2[i + 4];
                        f2 += fArray2[i + 5];
                        break;
                    }
                    case 'C': {
                        path.cubicTo(fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3], fArray2[i + 4], fArray2[i + 5]);
                        f = fArray2[i + 4];
                        f2 = fArray2[i + 5];
                        f3 = fArray2[i + 2];
                        f4 = fArray2[i + 3];
                        break;
                    }
                    case 's': {
                        float f7 = 0.0f;
                        float f8 = 0.0f;
                        if (c == 'c' || c == 's' || c == 'C' || c == 'S') {
                            f7 = f - f3;
                            f8 = f2 - f4;
                        }
                        path.rCubicTo(f7, f8, fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3]);
                        f3 = f + fArray2[i + 0];
                        f4 = f2 + fArray2[i + 1];
                        f += fArray2[i + 2];
                        f2 += fArray2[i + 3];
                        break;
                    }
                    case 'S': {
                        float f7 = f;
                        float f8 = f2;
                        if (c == 'c' || c == 's' || c == 'C' || c == 'S') {
                            f7 = 2.0f * f - f3;
                            f8 = 2.0f * f2 - f4;
                        }
                        path.cubicTo(f7, f8, fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3]);
                        f3 = fArray2[i + 0];
                        f4 = fArray2[i + 1];
                        f = fArray2[i + 2];
                        f2 = fArray2[i + 3];
                        break;
                    }
                    case 'q': {
                        path.rQuadTo(fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3]);
                        f3 = f + fArray2[i + 0];
                        f4 = f2 + fArray2[i + 1];
                        f += fArray2[i + 2];
                        f2 += fArray2[i + 3];
                        break;
                    }
                    case 'Q': {
                        path.quadTo(fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3]);
                        f3 = fArray2[i + 0];
                        f4 = fArray2[i + 1];
                        f = fArray2[i + 2];
                        f2 = fArray2[i + 3];
                        break;
                    }
                    case 't': {
                        float f7 = 0.0f;
                        float f8 = 0.0f;
                        if (c == 'q' || c == 't' || c == 'Q' || c == 'T') {
                            f7 = f - f3;
                            f8 = f2 - f4;
                        }
                        path.rQuadTo(f7, f8, fArray2[i + 0], fArray2[i + 1]);
                        f3 = f + f7;
                        f4 = f2 + f8;
                        f += fArray2[i + 0];
                        f2 += fArray2[i + 1];
                        break;
                    }
                    case 'T': {
                        float f7 = f;
                        float f8 = f2;
                        if (c == 'q' || c == 't' || c == 'Q' || c == 'T') {
                            f7 = 2.0f * f - f3;
                            f8 = 2.0f * f2 - f4;
                        }
                        path.quadTo(f7, f8, fArray2[i + 0], fArray2[i + 1]);
                        f3 = f7;
                        f4 = f8;
                        f = fArray2[i + 0];
                        f2 = fArray2[i + 1];
                        break;
                    }
                    case 'a': {
                        PathDataNode.ezm(path, f, f2, fArray2[i + 5] + f, fArray2[i + 6] + f2, fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3] != 0.0f, fArray2[i + 4] != 0.0f);
                        f3 = f += fArray2[i + 5];
                        f4 = f2 += fArray2[i + 6];
                        break;
                    }
                    case 'A': {
                        PathDataNode.ezm(path, f, f2, fArray2[i + 5], fArray2[i + 6], fArray2[i + 0], fArray2[i + 1], fArray2[i + 2], fArray2[i + 3] != 0.0f, fArray2[i + 4] != 0.0f);
                        f = fArray2[i + 5];
                        f2 = fArray2[i + 6];
                        f3 = f;
                        f4 = f2;
                        break;
                    }
                }
                c = c2;
            }
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray[3] = f4;
            fArray[4] = f5;
            fArray[5] = f6;
        }

        private static void ezm(Path path, float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, boolean bl2) {
            double d;
            double d2;
            double d3 = Math.toRadians(f7);
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            double d6 = ((double)f * d4 + (double)f2 * d5) / (double)f5;
            double d7 = ((double)(-f) * d5 + (double)f2 * d4) / (double)f6;
            double d8 = ((double)f3 * d4 + (double)f4 * d5) / (double)f5;
            double d9 = ((double)(-f3) * d5 + (double)f4 * d4) / (double)f6;
            double d10 = d6 - d8;
            double d11 = d7 - d9;
            double d12 = (d6 + d8) / 2.0;
            double d13 = (d7 + d9) / 2.0;
            double d14 = d10 * d10 + d11 * d11;
            if (d14 == 0.0) {
                Log.w((String)"PathParser", (String)" Points are coincident");
                return;
            }
            double d15 = 1.0 / d14 - 0.25;
            if (d15 < 0.0) {
                Log.w((String)"PathParser", (String)("Points are too far apart " + d14));
                float f8 = (float)(Math.sqrt(d14) / 1.99999);
                PathDataNode.ezm(path, f, f2, f3, f4, f5 * f8, f6 * f8, f7, bl, bl2);
                return;
            }
            double d16 = Math.sqrt(d15);
            double d17 = d16 * d10;
            double d18 = d16 * d11;
            if (bl == bl2) {
                d2 = d12 - d18;
                d = d13 + d17;
            } else {
                d2 = d12 + d18;
                d = d13 - d17;
            }
            double d19 = Math.atan2(d7 - d, d6 - d2);
            double d20 = Math.atan2(d9 - d, d8 - d2);
            double d21 = d20 - d19;
            if (bl2 != d21 >= 0.0) {
                d21 = d21 > 0.0 ? (d21 -= Math.PI * 2) : (d21 += Math.PI * 2);
            }
            double d22 = d2 *= (double)f5;
            d2 = d2 * d4 - (d *= (double)f6) * d5;
            d = d22 * d5 + d * d4;
            PathDataNode.ezn(path, d2, d, f5, f6, f, f2, d3, d19, d21);
        }

        private static void ezn(Path path, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            int n = (int)Math.ceil(Math.abs(d9 * 4.0 / Math.PI));
            double d10 = d8;
            double d11 = Math.cos(d7);
            double d12 = Math.sin(d7);
            double d13 = Math.cos(d10);
            double d14 = Math.sin(d10);
            double d15 = -d3 * d11 * d14 - d4 * d12 * d13;
            double d16 = -d3 * d12 * d14 + d4 * d11 * d13;
            double d17 = d9 / (double)n;
            for (int i = 0; i < n; ++i) {
                double d18 = d10 + d17;
                double d19 = Math.sin(d18);
                double d20 = Math.cos(d18);
                double d21 = d + d3 * d11 * d20 - d4 * d12 * d19;
                double d22 = d2 + d3 * d12 * d20 + d4 * d11 * d19;
                double d23 = -d3 * d11 * d19 - d4 * d12 * d20;
                double d24 = -d3 * d12 * d19 + d4 * d11 * d20;
                double d25 = Math.tan((d18 - d10) / 2.0);
                double d26 = Math.sin(d18 - d10) * (Math.sqrt(4.0 + 3.0 * d25 * d25) - 1.0) / 3.0;
                double d27 = d5 + d26 * d15;
                double d28 = d6 + d26 * d16;
                double d29 = d21 - d26 * d23;
                double d30 = d22 - d26 * d24;
                path.rLineTo(0.0f, 0.0f);
                path.cubicTo((float)d27, (float)d28, (float)d29, (float)d30, (float)d21, (float)d22);
                d10 = d18;
                d5 = d21;
                d6 = d22;
                d15 = d23;
                d16 = d24;
            }
        }
    }

    private static class ExtractFloatResult {
        int eck;
        boolean ecl;

        ExtractFloatResult() {
        }
    }
}

