/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.smartrefreshlayout.header.bezierradar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;

public class WaveView
extends View {
    private int eyn;
    private int eyo;
    private Path eyp;
    private Paint eyq;
    private int eyr = -1;

    public WaveView(Context context) {
        this(context, null, 0);
    }

    public WaveView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WaveView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.eys();
    }

    private void eys() {
        this.eyp = new Path();
        this.eyq = new Paint();
        this.eyq.setColor(-14736346);
        this.eyq.setAntiAlias(true);
    }

    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(WaveView.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n), WaveView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n2));
    }

    public void setWaveColor(int n) {
        this.eyq.setColor(n);
    }

    public int getHeadHeight() {
        return this.eyo;
    }

    public void setHeadHeight(int n) {
        this.eyo = n;
    }

    public int getWaveHeight() {
        return this.eyn;
    }

    public void setWaveHeight(int n) {
        this.eyn = n;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = this.getWidth();
        this.eyp.reset();
        this.eyp.lineTo(0.0f, (float)this.eyo);
        this.eyp.quadTo(this.eyr >= 0 ? (float)this.eyr : (float)(n / 2), (float)(this.eyo + this.eyn), (float)n, (float)this.eyo);
        this.eyp.lineTo((float)n, 0.0f);
        canvas.drawPath(this.eyp, this.eyq);
    }

    public void setWaveOffsetX(int n) {
        this.eyr = n;
    }
}

