/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.smartrefreshlayout.header;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshHeader;
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshKernel;
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshLayout;
import com.yy.mobile.ui.widget.smartrefreshlayout.constant.RefreshState;
import com.yy.mobile.ui.widget.smartrefreshlayout.constant.SpinnerStyle;
import com.yy.mobile.ui.widget.smartrefreshlayout.header.bezierradar.RippleView;
import com.yy.mobile.ui.widget.smartrefreshlayout.header.bezierradar.RoundDotView;
import com.yy.mobile.ui.widget.smartrefreshlayout.header.bezierradar.RoundProgressView;
import com.yy.mobile.ui.widget.smartrefreshlayout.header.bezierradar.WaveView;
import com.yy.mobile.utils.DensityUtil;

public class BezierRadarHeader
extends FrameLayout
implements RefreshHeader {
    private WaveView exo;
    private RippleView exp;
    private RoundDotView exq;
    private RoundProgressView exr;
    private boolean exs = false;

    public BezierRadarHeader(Context context) {
        this(context, null);
    }

    public BezierRadarHeader(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BezierRadarHeader(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.ext(context, attributeSet, n);
    }

    private void ext(Context context, AttributeSet attributeSet, int n) {
        this.setMinimumHeight(DensityUtil.ejb(100.0f));
        this.exo = new WaveView(this.getContext());
        this.exp = new RippleView(this.getContext());
        this.exq = new RoundDotView(this.getContext());
        this.exr = new RoundProgressView(this.getContext());
        if (this.isInEditMode()) {
            this.addView(this.exo, -1, -1);
            this.addView(this.exr, -1, -1);
            this.exo.setHeadHeight(1000);
        } else {
            this.addView(this.exo, -1, -1);
            this.addView(this.exq, -1, -1);
            this.addView(this.exr, -1, -1);
            this.addView(this.exp, -1, -1);
            this.exr.setScaleX(0.0f);
            this.exr.setScaleY(0.0f);
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.BezierRadarHeader);
        this.exs = typedArray.getBoolean(R.styleable.BezierRadarHeader_srlEnableHorizontalDrag, this.exs);
        int n2 = typedArray.getColor(R.styleable.BezierRadarHeader_srlPrimaryColor, 0);
        int n3 = typedArray.getColor(R.styleable.BezierRadarHeader_srlAccentColor, 0);
        if (n2 != 0) {
            this.dxn(n2);
        }
        if (n3 != 0) {
            this.dxo(n2);
        }
        typedArray.recycle();
    }

    public BezierRadarHeader dxn(int n) {
        this.exo.setWaveColor(n);
        this.exr.setBackColor(n);
        return this;
    }

    public BezierRadarHeader dxo(int n) {
        this.exq.setDotColor(n);
        this.exp.setFrontColor(n);
        this.exr.setFrontColor(n);
        return this;
    }

    public BezierRadarHeader dxp(int n) {
        this.dxn(ContextCompat.getColor((Context)this.getContext(), (int)n));
        return this;
    }

    public BezierRadarHeader dxq(int n) {
        this.dxo(ContextCompat.getColor((Context)this.getContext(), (int)n));
        return this;
    }

    public BezierRadarHeader dxr(boolean bl) {
        this.exs = bl;
        if (!bl) {
            this.exo.setWaveOffsetX(-1);
        }
        return this;
    }

    @Override
    public void setPrimaryColors(int ... nArray) {
        if (nArray.length > 0) {
            this.dxn(nArray[0]);
        }
        if (nArray.length > 1) {
            this.dxo(nArray[1]);
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }

    @Override
    public void dvy(RefreshKernel refreshKernel, int n, int n2) {
    }

    @Override
    public boolean dwc() {
        return this.exs;
    }

    @Override
    public void dvz(float f, int n, int n2) {
        this.exo.setWaveOffsetX(n);
        this.exo.invalidate();
    }

    @Override
    public void dvw(float f, int n, int n2, int n3) {
        this.exo.setHeadHeight(Math.min(n2, n));
        this.exo.setWaveHeight((int)(1.9f * (float)Math.max(0, n - n2)));
        this.exq.setFraction(f);
    }

    @Override
    public void dvx(float f, int n, int n2, int n3) {
        this.dvw(f, n, n2, n3);
    }

    @Override
    public void dwa(final RefreshLayout refreshLayout, int n, int n2) {
        this.exo.setHeadHeight(n);
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.exo.getWaveHeight(), 0, -((int)((double)this.exo.getWaveHeight() * 0.8)), 0, -((int)((float)this.exo.getWaveHeight() * 0.4f)), 0});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                BezierRadarHeader.this.exo.setWaveHeight((Integer)valueAnimator.getAnimatedValue() / 2);
                BezierRadarHeader.this.exo.invalidate();
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.setDuration(800L);
        valueAnimator.start();
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        valueAnimator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                super.onAnimationEnd(animator);
                BezierRadarHeader.this.exq.setVisibility(4);
                BezierRadarHeader.this.exr.animate().scaleX(1.0f);
                BezierRadarHeader.this.exr.animate().scaleY(1.0f);
                refreshLayout.getLayout().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BezierRadarHeader.this.exr.dzl();
                    }
                }, 200L);
            }
        });
        valueAnimator2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator2.setDuration(300L);
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                BezierRadarHeader.this.exq.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        valueAnimator2.start();
    }

    @Override
    public int dwb(RefreshLayout refreshLayout, boolean bl) {
        this.exr.dzm();
        this.exr.animate().scaleX(0.0f);
        this.exr.animate().scaleY(0.0f);
        this.exp.setVisibility(0);
        this.exp.dzh();
        return 400;
    }

    @Override
    public void dwf(RefreshLayout refreshLayout, RefreshState refreshState, RefreshState refreshState2) {
        switch (refreshState2) {
            case None: {
                this.exp.setVisibility(8);
                this.exq.setAlpha(1.0f);
                this.exq.setVisibility(0);
                break;
            }
            case PullDownToRefresh: {
                this.exr.setScaleX(0.0f);
                this.exr.setScaleY(0.0f);
                break;
            }
            case PullToUpLoad: {
                break;
            }
            case Refreshing: {
                break;
            }
            case Loading: {
                break;
            }
        }
    }
}

