/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.yy.mobile.logs.MLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.utils.ImageHelper;

public class CircleCompatImageView
extends ImageView {
    private static final String ete = "CircleImageView";
    private static final ImageView.ScaleType etf = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config etg = Bitmap.Config.ARGB_8888;
    private static final int eth = 1;
    private static final int eti = 0;
    private static final int etj = -16777216;
    private final RectF etk = new RectF();
    private final RectF etl = new RectF();
    private final Matrix etm = new Matrix();
    private final Paint etn = new Paint();
    private final Paint eto = new Paint();
    public PaintFlagsDrawFilter dht = new PaintFlagsDrawFilter(0, 3);
    private int etp = -16777216;
    private int etq = 0;
    private Bitmap etr;
    private BitmapShader ets;
    private int ett;
    private int etu;
    private float etv;
    private float etw;
    private boolean etx;
    private boolean ety;

    public CircleCompatImageView(Context context) {
        super(context);
        this.etx = true;
        if (this.ety) {
            this.eua();
            this.ety = false;
        }
    }

    public CircleCompatImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 0);
        this.etx = true;
        if (this.ety) {
            this.eua();
            this.ety = false;
        }
    }

    public CircleCompatImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        super.setScaleType(etf);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CircleImageView, n, 0);
        this.etq = typedArray.getDimensionPixelSize(R.styleable.CircleImageView_border_width, 0);
        this.etp = typedArray.getColor(R.styleable.CircleImageView_border_color, -16777216);
        typedArray.recycle();
        this.etx = true;
        if (this.ety) {
            this.eua();
            this.ety = false;
        }
    }

    public ImageView.ScaleType getScaleType() {
        return etf;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != etf) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    protected void onDraw(Canvas canvas) {
        try {
            if (this.getDrawable() == null) {
                return;
            }
            canvas.setDrawFilter((DrawFilter)this.dht);
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.etv, this.etn);
            if (this.etq != 0) {
                canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.etw, this.eto);
            }
        }
        catch (Throwable throwable) {
            MLog.eb.ei(ete, throwable.getLocalizedMessage(), new Object[0]);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.eua();
    }

    public int getBorderColor() {
        return this.etp;
    }

    public void setBorderColor(int n) {
        if (n == this.etp) {
            return;
        }
        this.etp = n;
        this.eto.setColor(this.etp);
        this.invalidate();
    }

    public int getBorderWidth() {
        return this.etq;
    }

    public void setBorderWidth(int n) {
        if (n == this.etq) {
            return;
        }
        this.etq = n;
        this.eua();
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        this.etr = bitmap;
        this.eua();
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.etr = this.etz(drawable2);
        this.eua();
    }

    public void setImageResource(int n) {
        super.setImageResource(n);
        this.etr = this.etz(this.getDrawable());
        this.eua();
    }

    private Bitmap etz(Drawable drawable2) {
        Drawable drawable3;
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = ImageHelper.ejq.ejr(drawable2);
        if (bitmap != null) {
            return bitmap;
        }
        if (drawable2 instanceof TransitionDrawable) {
            try {
                drawable3 = ((TransitionDrawable)drawable2).getDrawable(1);
                if (drawable3 instanceof BitmapDrawable) {
                    return ((BitmapDrawable)drawable3).getBitmap();
                }
                bitmap = ImageHelper.ejq.ejr(drawable3);
                if (bitmap != null) {
                    return bitmap;
                }
            }
            catch (Exception exception) {
                MLog.eb.ej(ete, "Get TransitionDrawable error.", exception, new Object[0]);
            }
        }
        try {
            bitmap = drawable2 instanceof ColorDrawable ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)etg) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)etg);
            drawable3 = new Canvas(bitmap);
            drawable2.setBounds(0, 0, drawable3.getWidth(), drawable3.getHeight());
            drawable2.draw((Canvas)drawable3);
            return bitmap;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    private void eua() {
        if (!this.etx) {
            this.ety = true;
            return;
        }
        if (this.etr == null) {
            return;
        }
        this.ets = new BitmapShader(this.etr, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.etn.setAntiAlias(true);
        this.etn.setShader((Shader)this.ets);
        this.eto.setStyle(Paint.Style.STROKE);
        this.eto.setAntiAlias(true);
        this.eto.setColor(this.etp);
        this.eto.setStrokeWidth((float)this.etq);
        this.etu = this.etr.getHeight();
        this.ett = this.etr.getWidth();
        this.etl.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.etw = Math.min((this.etl.height() - (float)this.etq) / 2.0f, (this.etl.width() - (float)this.etq) / 2.0f);
        this.etk.set((float)this.etq, (float)this.etq, this.etl.width() - (float)this.etq, this.etl.height() - (float)this.etq);
        this.etv = Math.min(this.etk.height() / 2.0f, this.etk.width() / 2.0f);
        this.eub();
        this.invalidate();
    }

    private void eub() {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.etm.set(null);
        if ((float)this.ett * this.etk.height() > this.etk.width() * (float)this.etu) {
            f = this.etk.height() / (float)this.etu;
            f2 = (this.etk.width() - (float)this.ett * f) * 0.5f;
        } else {
            f = this.etk.width() / (float)this.ett;
            f3 = (this.etk.height() - (float)this.etu * f) * 0.5f;
        }
        this.etm.setScale(f, f);
        this.etm.postTranslate((float)((int)(f2 + 0.5f) + this.etq), (float)((int)(f3 + 0.5f) + this.etq));
        this.ets.setLocalMatrix(this.etm);
    }
}

