package com.yy.mobile.utils

import android.content.Context
import android.graphics.Paint
import android.graphics.Rect
import android.graphics.Typeface
import android.text.TextUtils
import android.view.View
import android.widget.RelativeLayout
import android.widget.TextView
import com.yy.mobile.plugin.pluginunionhomepage.R

/**
 * Created by PYF on 2019/2/28
 * 持续抄袭
 */

object TextViewUtil {
    fun getTextWidth(str: String, size: Int): Float {
        val paint = Paint()
        paint.textSize = size.toFloat()
        return paint.measureText(str)
    }

    fun getTextRect(str: String, size: Int): Rect {
        val paint = Paint()
        val rect = Rect()
        paint.textSize = size.toFloat()
        paint.getTextBounds(str, 0, str.length, rect)
        //        int w = rect.width();
        //        int h = rect.height();
        return rect
    }

    fun setLiveTagFromTagStyle(mContext: Context, liveTag: TextView?, tagStyle: Int, tag: String) {
        if (liveTag != null) {
            if (TextUtils.isEmpty(tag)) {
                liveTag.visibility = View.GONE
                return
            }
            when (tagStyle) {
                0 -> liveTag.visibility = View.GONE
                else -> {
                    setLiveTagTextInternal(mContext, liveTag, tagStyle, tag, R.drawable.hp_home_btn_tag)
                    liveTag.setTextColor(mContext.resources.getColor(R.color.hp_color_white))
                    liveTag.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null)
                }
            }
        }
    }

    private fun setLiveTagTextInternal(mContext: Context, liveTag: TextView, tagStyle: Int, tag: String, backgroundId: Int) {
        liveTag.visibility = View.VISIBLE
        liveTag.text = tag
        liveTag.setBackgroundResource(backgroundId)
        liveTag.setTypeface(Typeface.DEFAULT, Typeface.NORMAL)
        liveTag.textSize = 12f
        var compoundDrawablePadding = DensityUtil.dp2px(2f)
        if (tagStyle == 4) {
            compoundDrawablePadding = DensityUtil.dp2px(4f)
        }
        liveTag.compoundDrawablePadding = compoundDrawablePadding
        val leftPx = mContext.resources.getDimension(R.dimen.hp_home_living_tag_left).toInt()
        val rightPx = mContext.resources.getDimension(R.dimen.hp_home_living_tag_right).toInt()
        liveTag.setPadding(leftPx, 0, rightPx, 0)
        val lp = liveTag.layoutParams as RelativeLayout.LayoutParams
        lp.setMargins(0, DensityUtil.dp2px(5f), 0, 0)
    }
}