package com.yy.mobile.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;


import com.yy.mobile.logs.MLog;

import java.io.File;
import java.util.HashMap;

/**
 * Created by lulong on 2017/11/28.
 * Email:lulong@yy.com
 */
public class SharedPreferencesUtils {
    private static final HashMap<String, SharedPreferences> sSharedPrefs = new HashMap<String, SharedPreferences>();

    private static volatile File sSharedPrefDir = null;

    private static SharedPreferences mDefaultPrf;
    private static final String DEFAULT_PRF_NAME = "default";

    private static File getSharedPrefsFile(Context context, String name) {
        if (sSharedPrefDir != null) {
            return new File(sSharedPrefDir, name + ".xml");
        }
        ApplicationInfo info = context.getApplicationContext() == null ?
                context.getApplicationInfo() : context.getApplicationContext().getApplicationInfo();
        File dir = new File(info.dataDir);
        MLog.INSTANCE.info("SharedPreferencesUtils", dir.toString());
        File sharedPrefDir = new File(dir, "/shared_prefs");
        if (!sharedPrefDir.exists()) {
            if (sharedPrefDir.mkdir()) {
                sSharedPrefDir = sharedPrefDir;
            }
        } else {
            sSharedPrefDir = sharedPrefDir;
        }

        return new File(sharedPrefDir, name + ".xml");
    }

    public static SharedPreferences getDefaultPrf(Context appContext) {
        if (mDefaultPrf == null) {
            synchronized (SharedPreferencesUtils.class) {
                if (mDefaultPrf == null) {
                    mDefaultPrf = getSharedPreferences(appContext, DEFAULT_PRF_NAME, Context.MODE_PRIVATE);
                }
            }
        }

        return mDefaultPrf;
    }

    public static SharedPreferences getSharedPreferences(final Context context, final String name, final int mode) {
        SharedPreferences sp;
        synchronized (sSharedPrefs) {
            sp = sSharedPrefs.get(name);
            if (sp == null) {
                // File prefsFile = getSharedPrefsFile(context, name);
                // sp = new SharedPreferencesImpl(prefsFile, mode);
                sp = context.getSharedPreferences(name, mode);
                sSharedPrefs.put(name, sp);
                return sp;
            }
        }

        return sp;
    }

}
