package com.yy.mobile.utils

import android.app.Activity
import android.content.Context
import android.content.res.Resources
import android.graphics.Point
import android.graphics.Rect
import android.os.Build
import android.view.WindowManager
import com.yy.mobile.logs.MLog

/**
 * Created by PYF on 2019/2/28
 * 屏幕信息获取通用类
 */

object ScreenUtil {
    private var mStatusBarHeight: Int = 0

    fun getStatusBarHeight(context: Context?): Int {
        try {
            if (mStatusBarHeight == 0) {
                var result = 0
                val resourceId = Resources.getSystem().getIdentifier("status_bar_height", "dimen", "android")
                if (resourceId > 0) {
                    result = Resources.getSystem().getDimensionPixelSize(resourceId)
                }
                mStatusBarHeight = result
                return mStatusBarHeight
            }
        } catch (e: Throwable) {
            //miui 不走寻常路，拿系统属性值，尽可能地try-catch，各大厂商别具一格。
            MLog.error("ScreenUtil", "挂了 getStatusBarHeight$e")
            mStatusBarHeight = getStatusBarHeightInner(context as? Activity)
        }
        return mStatusBarHeight
    }

    /**
     * 获取状态栏高度
     *
     * @param activity
     * @return
     */
    private fun getStatusBarHeightInner(activity: Activity?): Int {
        if (activity == null) {
            return 0
        }
        return try {
            val c = Class.forName("com.android.internal.R\$dimen")
            val obj = c.newInstance()
            val field = c.getField("status_bar_height")
            val x = Integer.parseInt(field.get(obj).toString())
            activity.resources.getDimensionPixelSize(x)
        } catch (e: Exception) {
            val rect = Rect()
            activity.window.decorView.getWindowVisibleDisplayFrame(rect)
            rect.top
        }
    }

    fun getScreenWidth(context: Context): Int {
        return getScreenSize(context, null).x
    }

    fun getScreenHeight(context: Context): Int {
        return getScreenSize(context, null).y
    }

    private fun getScreenSize(context: Context, outSize: Point?): Point {
        val wm = context
                .getSystemService(Context.WINDOW_SERVICE) as WindowManager
        val ret = outSize ?: Point()
        val defaultDisplay = wm.defaultDisplay
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret)
        } else {
            ret.x = defaultDisplay.width
            ret.y = defaultDisplay.height
        }
        return ret
    }
}