package com.yy.mobile.utils

import com.yy.mobile.logs.MLog
import io.reactivex.disposables.Disposable
import io.reactivex.functions.Consumer

/**
 * Created by PYF on 2019/3/1
 * 抄袭
 */

object RxUtils {

    fun dispose(disposable: Disposable?) {
        disposable?.let {
            if (!it.isDisposed) {
                it.dispose()
            }
        }
    }

    fun errorConsumer(tag: String): Consumer<in Throwable> {
        return errorConsumer(tag, null)
    }

    fun errorConsumer(tag: String, msg: String?): Consumer<in Throwable> {
        return Consumer { t -> MLog.error(tag, msg + ", throwable = ${t?.localizedMessage}") }
    }
}