package com.yy.mobile.utils

import android.content.Context
import android.net.ConnectivityManager
import android.os.Build
import android.telephony.TelephonyManager
import com.yy.hiidostatis.api.HiidoSDK
import com.yy.mobile.constant.LivingCoreConstant

/**
 * Created by PYF on 2019/3/7
 * 请求参数补全
 */

object RequestParamsUtil {

    fun paramMap(loadType: String?, pageNo: Int?): Map<String, String> {
        val map = HashMap<String, String>()
        map["os"] = "android"
        map["osVersion"] = Build.VERSION.RELEASE
        map["yyVersion"] = "0.0.0"
        map["model"] = Build.MODEL
        map["ispType"] = getIspType().toString() //待修改
        map["netType"] = getNetType() //待修改
        map["channel"] = "official"
        map["uid"] = LoginUtil.getUid()
        map["imei"] = getImei()
        map["sdkVersion"] = "0.0.0"
        map["mac"] = HiidoSDK.instance().getMac(ContextHolder.instance.getContext())
        map["hdid"] = HiidoSDK.instance().getHdid(ContextHolder.instance.getContext())
        map["pagesize"] = "20"
        if (loadType != null && loadType.isNotEmpty()) {
            map["loadType"] = loadType
        }
        if (pageNo != null && pageNo > 0) {
            map["page"] = pageNo.toString()
        }
        //location 相关参数没传
        return map
    }

    private fun getImei(): String {
        val deviceId = HiidoSDK.instance().getDeviceId(ContextHolder.instance.getContext())
        if (deviceId?.isEmpty() == true) {
            return ""
        }
        if (deviceId == null) {
            return ""
        }
        return SHAUtils.getSHA256(deviceId)
    }


    private fun getSimOperator(c: Context): String {
        val tm = c.getSystemService(Context.TELEPHONY_SERVICE) as TelephonyManager
        return tm.simOperator
    }

    @Volatile
    private var sSimOperator: String? = null

    fun getOperator(c: Context): String {
        if (StringUtil.isEmptyString(sSimOperator)) {
            sSimOperator = getSimOperator(c)
        }

        val sim = sSimOperator
        if (FP.empty(sim))
            return LivingCoreConstant.UNKNOWN
        return if (sim!!.startsWith("46003") || sim.startsWith("46005")) {
            LivingCoreConstant.CTL
        } else if (sim.startsWith("46001") || sim.startsWith("46006")) {
            LivingCoreConstant.UNICOM
        } else if (sim.startsWith("46000") || sim.startsWith("46002")
            || sim.startsWith("46007") || sim.startsWith("46020")) {
            LivingCoreConstant.CMCC
        } else {
            LivingCoreConstant.UNKNOWN
        }
    }

    /**
     * 获取运营商字段
     *
     * @return
     */
    fun getIspType(): Int {
        val isp = getOperator(ContextHolder.instance.getContext()!!)
        var ispType = 4
        if (isp == LivingCoreConstant.CMCC) {
            ispType = 1
        } else if (isp == LivingCoreConstant.UNICOM) {
            ispType = 2
        } else if (isp == LivingCoreConstant.CTL) {
            ispType = 3
        }
        return ispType
    }

    fun getNetType(): String {
        val manager = ContextHolder.instance.getContext()?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val wifiNetworkInfo = manager.getNetworkInfo(ConnectivityManager.TYPE_WIFI)
        if (wifiNetworkInfo.isConnected) {
            return "2"
        } else {
            return "1"
        }
    }
}