package com.yy.mobile.utils

import android.graphics.Bitmap
import android.graphics.drawable.BitmapDrawable
import android.graphics.drawable.Drawable
import com.bumptech.glide.load.resource.gif.GifDrawable

/**
 * Created by PYF on 2019/2/28
 * 一些需要用的ImageLoader接口转移
 */
object ImageHelper {

    /**
     * @Description 获取Drawable的bitmap，比如一些特殊视图CircleImageView，需要获取Bitmap进行处理
     */
    fun getBitmapFromCustomDrawable(drawable: Drawable?): Bitmap? {
        if (drawable != null) {
            if (drawable is BitmapDrawable) {
                return drawable.bitmap
            } else if (drawable is GifDrawable) {
                return drawable.firstFrame
            }
        }
        return null
    }
}