package com.yy.mobile.utils

import android.os.Handler
import android.os.Looper
import android.os.Message
import com.yy.mobile.logs.MLog


/**
 * Created by PYF on 2019/2/28
 * 能打印异常日志的Handler
 */

open class DispatchHandler : Handler {
    companion object {
        const val TAG = "DispatchHandler"
    }

    constructor(): super()
    constructor(looper: Looper): super(looper)
    constructor(looper: Looper, callback: Callback): super(looper, callback)
    constructor(callback: Callback): super(callback)

    override fun dispatchMessage(msg: Message?) {
        try {
            super.dispatchMessage(msg)
        } catch (e: Exception) {
            MLog.error(TAG, "the exception = ${e.localizedMessage}")
        } catch (error: Error) {
            MLog.error(TAG, "the error = ${error.localizedMessage}")
        }
    }
}