package com.yy.mobile.utils

import android.app.Application
import android.content.Context
import com.yy.mobile.logs.MLog


/**
 * Created by PYF on 2019/3/1
 * 迫于无奈
 */

class ContextHolder private constructor(){
    private val self = this

    var applicationContext: Context? = null

    /* Public Methods */

    /**
     * 初始化context，如果由于不同机型导致反射获取context失败可以在Application调用此方法
     * @param context
     */
    fun init(context: Context) {
        applicationContext = context
    }

    fun getContext(): Context? {
        if (applicationContext == null) {
            try {
                val application = Class.forName("android.app.ActivityThread")
                        .getMethod("currentApplication").invoke(null, null as Array<Any>?) as Application
                if (application != null) {
                    applicationContext = application
                    return application
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }

            try {
                val application = Class.forName("android.app.AppGlobals")
                        .getMethod("getInitialApplication").invoke(null, null as Array<Any>?) as Application
                if (application != null) {
                    applicationContext = application
                    return application
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }

            MLog.error("ContextHolder","ContextHolder is not initialed, it is recommend to init with application context.")
        }
        return applicationContext
    }

    companion object {
        val instance: ContextHolder by lazy { ContextHolder() }

        fun isDebuggable(): Boolean {
            return true
        }
    }
}