package com.yy.mobile.ui.widget.titlebar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.yy.mobile.logs.MLog;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.utils.ScreenUtil;

/**
 * Created by xujiexing on 14-6-5.
 */
public class TitleBar extends RelativeLayout {
    private int mLeftLayout;
    protected View mLeftView;
    private int mRightLayout;
    protected View mRightView;
    private int mCenterLayout;
    protected View mCenterView;
    protected View mCenterViewOnclick;
    private int mBottomLayout;
    protected View mBottomView;
    protected int mBg;
    private Context mContext;
    private LayoutInflater mInflater;
    private String TAG = "TitleBar";

    /**
     * true:则TitleBar会把layout_height的值给content。TitleBar的高度=content+状态栏的高度
     */
    private boolean considerStatusBar = true;
    private boolean isInsetAdded;
    private View vInset;
    private LayoutParams layoutParams;
    private static final int V_INSET_ID = "v_title_inset".hashCode();


    public TitleBar(Context context) {
        this(context, null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        try {
            init(context, attrs, defStyle);
        } catch (Throwable throwable) {
            MLog.INSTANCE.error(TAG, "zy TitleBar error == " + throwable);
        }
        initView();
    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    private void initView() {
        vInset = new View(getContext());
        vInset.setId(V_INSET_ID);
        layoutParams = new LayoutParams(AdvancedRadioGroup.LayoutParams.MATCH_PARENT, ScreenUtil.INSTANCE.getStatusBarHeight(getContext()));
    }

    @TargetApi(Build.VERSION_CODES.KITKAT)
    private void fitStatusBar() {
        if (!isInsetAdded && considerStatusBar && needHandleStatusBar()) {
            isInsetAdded = true;
            removeView(vInset);
            View contentView = findViewById(R.id.v_title_content);
            addView(vInset, layoutParams);
            LayoutParams lp1 = (LayoutParams) contentView.getLayoutParams();
            lp1.height = getLayoutParams().height;
            lp1.addRule(RelativeLayout.BELOW, V_INSET_ID);
            getLayoutParams().height += layoutParams.height;
        }
    }

    private boolean needHandleStatusBar() {
        return false;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        fitStatusBar();
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        mContext = context;
        mInflater = LayoutInflater.from(context);
        mCenterViewOnclick = mInflater.inflate(R.layout.hp_layout_title_bar_base, this, true).findViewById(R.id.title_center_onclick);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.title_bar_style, defStyle, 0);
        mBg = ta.getResourceId(R.styleable.title_bar_style_bg, -1);
        int left = ta.getResourceId(R.styleable.title_bar_style_left, -1);
        int right = ta.getResourceId(R.styleable.title_bar_style_right, -1);
        int center = ta.getResourceId(R.styleable.title_bar_style_center, -1);
        int bottom = ta.getResourceId(R.styleable.title_bar_style_bottom, -1);
        this.considerStatusBar = ta.getBoolean(R.styleable.title_bar_style_consider_status_bar, false);
        setLeftLayout(left);
        setRightLayout(right);
        setCenterLayout(center);
        setBottomLayout(bottom);
        if (mBg > 0) {
            this.setBackgroundResource(mBg);
        }
        ta.recycle();
    }

    public void setConsiderStatusBar(boolean considerStatusBar) {
        this.considerStatusBar = considerStatusBar;
        requestLayout();
    }

    public int getBottomLayout() {
        return mBottomLayout;
    }

    public void setBottomLayout(int bottomLayout) {
        this.mBottomLayout = bottomLayout;
        if (mBottomLayout > 0) {
            setBottomView(mInflater.inflate(mBottomLayout, null, false));
        }
    }

    public void setBottomView(View bottomView) {
        if (bottomView == null)
            return;
        if (this.mBottomView != null)
            removeView(this.mBottomView);
        this.mBottomView = bottomView;
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, 1);
        //params.addRule(CENTER_VERTICAL);
        ((ViewGroup) findViewById(R.id.title_bottom_line)).addView(this.mBottomView, params);
    }

    public int getLeftLayout() {
        return mLeftLayout;
    }

    public void setLeftLayout(int leftLayout) {
        this.mLeftLayout = leftLayout;
        if (mLeftLayout > 0) {
            setLeftView(mInflater.inflate(mLeftLayout, null));
        }
    }

    public View getLeftView() {
        return mLeftView;
    }

    public void setLeftView(View leftView) {
        if (leftView == null)
            return;
        if (this.mLeftView != null)
            removeView(this.mLeftView);
        this.mLeftView = leftView;
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.addRule(CENTER_VERTICAL);
        ((ViewGroup) findViewById(R.id.title_left)).addView(this.mLeftView, params);
    }


    public int getRightLayout() {
        return mRightLayout;
    }

    public void setRightLayout(int rightLayout) {
        this.mRightLayout = rightLayout;
        if (mRightLayout > 0) {
            setRightView(mInflater.inflate(mRightLayout, null));
        }
    }

    public View getRightView() {
        return mRightView;
    }

    public void setRightView(View rightView) {
        if (rightView == null)
            return;
        if (this.mRightView != null)
            removeView(this.mRightView);
        this.mRightView = rightView;
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.addRule(CENTER_VERTICAL);
        ((ViewGroup) findViewById(R.id.title_right)).addView(this.mRightView, params);
    }

    public int getCenterLayout() {
        return mCenterLayout;
    }


    public void setCenterLayout(int centerLayout) {
        this.mCenterLayout = centerLayout;
        if (mCenterLayout > 0) {
            setCenterView(mInflater.inflate(mCenterLayout, null));
        }
    }

    public View getCenterView() {
        return mCenterView;
    }

    public void setCenterView(View centerView) {
        if (centerView == null)
            return;
        if (this.mCenterView != null)
            removeView(this.mCenterView);
        this.mCenterView = centerView;
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.addRule(CENTER_VERTICAL);
        ((ViewGroup) findViewById(R.id.title_center)).addView(this.mCenterView, params);
    }

    public void setCenterOnClickListener(final OnClickListener listener) {
        if (mCenterViewOnclick != null) {
            mCenterViewOnclick.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    listener.onClick(view);
                }
            });
        }
    }
}
