package com.yy.mobile.ui.widget.titlebar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.yy.mobile.plugin.pluginunionhomepage.R;

/**
 * Created by xujiexing on 14-6-19.
 */
public class SimpleTitleBar extends TitleBar {
    private TextView mCenterTitle;
    private ImageView mCenterImage;

    public SimpleTitleBar(Context context) {
        super(context);
        addChilds();
        setBg();
    }

    public SimpleTitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        addChilds();
        setBg();
    }

    public SimpleTitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        addChilds();
        setBg();
    }

    private void addChilds() {
        setLeftLayout(R.layout.hp_layout_simple_title_left);
        setCenterLayout(R.layout.hp_layout_simple_title_center);
        setRightLayout(R.layout.hp_layout_simple_title_right);
        setBottomLayout(R.layout.hp_layout_simple_title_bottom);

        mLeftView.setVisibility(View.GONE);
        mRightView.setVisibility(View.GONE);
        mCenterView.setVisibility(View.GONE);
        mBottomView.setVisibility(GONE);//6.0默认分割线消失
        //
        // mBottomView.setVisibility(VISIBLE);
        mCenterTitle = (TextView) mCenterView.findViewById(R.id.simple_title_center_text);
        mCenterImage = (ImageView) mCenterView.findViewById(R.id.simple_title_center_image);
    }

    private void setBg() {
        if(mBg > 0){
            setBackgroundColor(getResources().getColor(mBg));
        }else{
            setBackgroundColor(getResources().getColor(R.color.hp_simple_title_divider_color));
        }
    }

    public void setBg(int color) {
        mBg = color;
        setBg();
    }

    public void setBottomLineVisibility(boolean visibility) {
        if(visibility){
            mBottomView.setVisibility(VISIBLE);
        }else{
            mBottomView.setVisibility(GONE);
        }
    }

    public void setLeftBtn(int resId, OnClickListener listener){
        mLeftView.setVisibility(View.VISIBLE);
        ((ImageView)(mLeftView.findViewById(R.id.simple_title_left))).setImageResource(resId);
        mLeftView.setOnClickListener(listener);
    }

    public void setLeftBtn(int resId,boolean isShow){
        if(!isShow){
            mLeftView.setVisibility(View.GONE);
        }else{
            mLeftView.setVisibility(View.VISIBLE);
            ((ImageView)(mLeftView.findViewById(R.id.simple_title_left))).setImageResource(resId);
        }
    }

    public void setLeftBtn(int resId){
        mLeftView.setVisibility(View.VISIBLE);
        ((ImageView)(mLeftView.findViewById(R.id.simple_title_left))).setImageResource(resId);
    }

    public void setRightBtn(int resId, OnClickListener listener){
        mRightView.setVisibility(View.VISIBLE);
        ((ImageView)(mRightView.findViewById(R.id.simple_title_right))).setImageResource(resId);
        mRightView.setOnClickListener(listener);
    }

    public void setRightBtn(int resId){
        mRightView.setVisibility(View.VISIBLE);
        ((ImageView)(mRightView.findViewById(R.id.simple_title_right))).setImageResource(resId);
    }

    public void setTitlte(String title){
        mCenterView.setVisibility(View.VISIBLE);
        mCenterTitle.setVisibility(View.VISIBLE);
        mCenterImage.setVisibility(View.GONE);
        mCenterTitle.setTextColor(getResources().getColor(R.color.hp_color_black));
        mCenterTitle.setText(title);
    }

    public TextView setViewTitle(String title){
        mCenterView.setVisibility(View.VISIBLE);
        mCenterTitle.setVisibility(View.VISIBLE);
        mCenterImage.setVisibility(View.GONE);
        mCenterTitle.setTextColor(getResources().getColor(R.color.hp_color_black));
        mCenterTitle.setText(title);
        return mCenterTitle;
    }

    public void setTitlte(String title,int color){
        setTitlte(title, color, 17);
    }

    public void setTitlte(String title,int color, int textSize){
        mCenterView.setVisibility(View.VISIBLE);
        mCenterTitle.setVisibility(View.VISIBLE);
        mCenterImage.setVisibility(View.GONE);
        mCenterTitle.setTextColor(color);
        mCenterTitle.setText(title);
        mCenterTitle.setTextSize(textSize);
    }

    public void setTitleImage(int drwableId){
        mCenterView.setVisibility(View.VISIBLE);
        mCenterImage.setVisibility(View.VISIBLE);
        mCenterTitle.setVisibility(View.GONE);
        mCenterImage.setImageResource(drwableId);
    }

    public TextView getCenterTitleTextView() {
        return mCenterTitle;
    }
}
