package com.yy.mobile.ui.widget.smartrefreshlayout.header;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.yy.mobile.data.main.HomepageData;
import com.yy.mobile.data.main.LineData;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshHeader;
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshKernel;
import com.yy.mobile.ui.widget.smartrefreshlayout.api.RefreshLayout;
import com.yy.mobile.ui.widget.smartrefreshlayout.constant.RefreshState;
import com.yy.mobile.ui.widget.smartrefreshlayout.constant.SpinnerStyle;

/**
 * Class Name: YYHeader
 * Description:
 * Author: 郑永欣
 * Date: 2017/7/27
 * Modified History: 修改记录，格式(Name)  (Version)  (Date) (Reason & Contents)
 */

public class YYHeader extends RelativeLayout implements RefreshHeader {

    private ImageView yyView;

    public YYHeader(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public YYHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public YYHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        View view = LayoutInflater.from(context).inflate(R.layout.hp_yy_header, this);
        yyView = (ImageView) view.findViewById(R.id.yy_header_view);
        yyView.setImageResource(R.drawable.hp_pulling_animation_list);
    }

    @NonNull
    @Override
    public View getView() {
        return this; //真实的视图就是自己，不能返回null
    }

    @Override
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Translate; //指定为平移，不能null
    }

    @Override
    public void setPrimaryColors(int... colors) {

    }

    @Override
    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {

    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {

    }

    @Override
    public void onStartAnimator(RefreshLayout layout, int height, int extendHeight) {
        ((AnimationDrawable) yyView.getDrawable()).start(); //开始动画
    }

    @Override
    public int onFinish(RefreshLayout layout, boolean success) {
        ((AnimationDrawable) yyView.getDrawable()).stop(); //停止动画
        return 500; //延迟500毫秒之后再弹回
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        switch (newState) {
            case None:
            case PullDownToRefresh: //下拉开始刷新
                yyView.setImageResource(R.drawable.hp_pulling_animation_list);
                ((AnimationDrawable) yyView.getDrawable()).start(); //开始动画
                break;
            case Refreshing: //正在刷新
                ((AnimationDrawable) yyView.getDrawable()).stop(); //开始动画
                yyView.setImageResource(R.drawable.hp_loading_animation_list);
                break;
            case ReleaseToRefresh: //释放立即刷新
                yyView.setImageResource(R.drawable.hp_pulling_animation_list);
                ((AnimationDrawable) yyView.getDrawable()).start(); //开始动画
                break;
            default:
                break;

        }
    }

    @Override
    public void onPullingDown(float percent, int offset, int headerHeight, int extendHeight) {

    }

    @Override
    public void onReleasing(float percent, int offset, int headerHeight, int extendHeight) {

    }
}
