package com.yy.mobile.ui.widget.banner;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.yy.mobile.constant.LivingCoreConstant;
import com.yy.mobile.data.meipai.MPBannerData;
import com.yy.mobile.data.nav.LiveNavInfo;
import com.yy.mobile.data.nav.SubLiveNavItem;
import com.yy.mobile.plugin.pluginunionhomepage.R;
import com.yy.mobile.statistic.HiidoReportHelper;
import com.yy.mobile.utils.FP;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by duhongzhou on 2016/1/11.
 */
public class TopBanner extends RelativeLayout {
    private static final int THREE_SECOND_DURATION = 3000;
    private static final String TAG = "TopBanner";
    HPTopBannerGallery mGallery;
    private OnItemSelectedListener mOnItemSelectedListener;
    TextView txtDesc;
    RadioGroup mRadios;
    int type;
    private LiveNavInfo mNavInfo;
    private SubLiveNavItem mSubNavInfo;
    private String from;
    private int bannerId;
    public boolean inWindow = false; //曝光使用，是否banner在window种
    private List<MPBannerData> mData = new ArrayList<MPBannerData>();
    private AdapterView.OnItemSelectedListener mListener = new AdapterView.OnItemSelectedListener() {
        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            if (mOnItemSelectedListener != null) {
                mOnItemSelectedListener.onItemSelected(parent, view, position);
            }
            if (!FP.INSTANCE.empty(mGallery.getData())) {
                final MPBannerData info = mData.get(position % mData.size());
                mRadios.check(mRadios.getChildAt(position % mGallery.getData().size()).getId());
                final int pos = position % mData.size() + 1;
                if (type == LivingCoreConstant.Live_MODULE_BANNER_CODE) {
                    txtDesc.setText("");
                }
            }
            //曝光逻辑走这里，然后外部viewholder给一个标识位banner 是否在window内
            if (inWindow) {
                HiidoReportHelper.INSTANCE.exposure();
            }
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {

        }
    };

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    public TopBanner(Context context) {
        super(context);
        init();
    }

    public TopBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public TopBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    private void init() {
        LayoutInflater.from(getContext()).inflate(R.layout.hp_item_living_banner, this, true);
        mGallery = (HPTopBannerGallery) findViewById(R.id.banner_gallery);
        mRadios = (RadioGroup) findViewById(R.id.living_banner_radiogroup);
//        Banner修改，添加左边的直播预告时间
        txtDesc = (TextView) findViewById(R.id.banner_enter_live_btn_left);
        mGallery.setFlipInterval(THREE_SECOND_DURATION); //3s
        mGallery.setOnItemSelectedListener(mListener);
    }

    public void setData(List<MPBannerData> data, int fromType) {
        if (mData.equals(data) || data == null) {
            return;
        }

        mData.clear();
        mData.addAll(data);
        if (mRadios != null) {
            if (mData.size() <= 1) {
                mRadios.setVisibility(View.GONE);
            } else {
                mRadios.setVisibility(View.VISIBLE);
            }
        }
        mGallery.setData(data, fromType);
        this.type = fromType;
        addRadios(data);
        mRadios.check(mRadios.getChildAt(0).getId());
    }

    private void addRadios(List<MPBannerData> data) {
        mRadios.removeAllViews();
        for (int i = 0; i < data.size(); i++) {
            RadioButton radioButton = new RadioButton(getContext());
            radioButton.setId(0x1234 + i);
            radioButton.setButtonDrawable(getContext().getResources().getDrawable(R.drawable.hp_top_banner_selector));
            mRadios.addView(radioButton, generateDefaultParam());
        }
        mRadios.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                for (int i = 0; i < mData.size(); i++) {
                    RadioButton rb = (RadioButton) group.getChildAt(i);
                }
            }
        });
    }

    private RadioGroup.LayoutParams generateDefaultParam() {
        int buttonW = (int) getResources().getDimension(R.dimen.hp_home_top_banner_dot);
        int w = buttonW + 12;
        int h = buttonW;
        return new RadioGroup.LayoutParams(w, h);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        mGallery.setOnItemClickListener(listener);
    }

    public void startAutoScroll() {
        if (mData.size() > 1) {
            mGallery.startAutoScroll();
        }
    }

    public void endAutoScroll() {
        mGallery.endAutoScroll();
    }

    public void setBannerId(int id) {
        this.bannerId = id;
    }

    public void setNav(LiveNavInfo navInfo, SubLiveNavItem subNavInfo, String from) {
        this.mNavInfo = navInfo;
        this.mSubNavInfo = subNavInfo;
        this.from = from;
    }

    public interface OnItemSelectedListener {
        void onItemSelected(AdapterView<?> parent, View view, int position);
    }
}
